/*
 * Decompiled with CFR 0.152.
 */
package io.openvidu.java.client;

import io.openvidu.java.client.Connection;
import io.openvidu.java.client.MediaMode;
import io.openvidu.java.client.OpenVidu;
import io.openvidu.java.client.OpenViduHttpException;
import io.openvidu.java.client.OpenViduJavaClientException;
import io.openvidu.java.client.OpenViduRole;
import io.openvidu.java.client.Publisher;
import io.openvidu.java.client.Recording;
import io.openvidu.java.client.RecordingLayout;
import io.openvidu.java.client.RecordingMode;
import io.openvidu.java.client.SessionProperties;
import io.openvidu.java.client.TokenOptions;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Session {
    private static final Logger log = LoggerFactory.getLogger(Session.class);
    private String sessionId;
    private long createdAt;
    private SessionProperties properties;
    private Map<String, Connection> activeConnections = new ConcurrentHashMap<String, Connection>();
    private boolean recording = false;

    protected Session() throws OpenViduJavaClientException, OpenViduHttpException {
        this.properties = new SessionProperties.Builder().build();
        this.getSessionIdHttp();
    }

    protected Session(SessionProperties properties) throws OpenViduJavaClientException, OpenViduHttpException {
        this.properties = properties;
        this.getSessionIdHttp();
    }

    protected Session(JSONObject json) {
        this.resetSessionWithJson(json);
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public long createdAt() {
        return this.createdAt;
    }

    public String generateToken() throws OpenViduJavaClientException, OpenViduHttpException {
        return this.generateToken(new TokenOptions.Builder().role(OpenViduRole.PUBLISHER).build());
    }

    public String generateToken(TokenOptions tokenOptions) throws OpenViduJavaClientException, OpenViduHttpException {
        HttpResponse response;
        StringEntity params;
        if (!this.hasSessionId()) {
            this.getSessionId();
        }
        HttpPost request = new HttpPost(OpenVidu.urlOpenViduServer + "api/tokens");
        JSONObject json = new JSONObject();
        json.put((Object)"session", (Object)this.sessionId);
        json.put((Object)"role", (Object)tokenOptions.getRole().name());
        json.put((Object)"data", (Object)tokenOptions.getData());
        if (tokenOptions.getKurentoOptions() != null) {
            JSONObject kurentoOptions = new JSONObject();
            if (tokenOptions.getKurentoOptions().getVideoMaxRecvBandwidth() != null) {
                kurentoOptions.put((Object)"videoMaxRecvBandwidth", (Object)tokenOptions.getKurentoOptions().getVideoMaxRecvBandwidth());
            }
            if (tokenOptions.getKurentoOptions().getVideoMinRecvBandwidth() != null) {
                kurentoOptions.put((Object)"videoMinRecvBandwidth", (Object)tokenOptions.getKurentoOptions().getVideoMinRecvBandwidth());
            }
            if (tokenOptions.getKurentoOptions().getVideoMaxSendBandwidth() != null) {
                kurentoOptions.put((Object)"videoMaxSendBandwidth", (Object)tokenOptions.getKurentoOptions().getVideoMaxSendBandwidth());
            }
            if (tokenOptions.getKurentoOptions().getVideoMinSendBandwidth() != null) {
                kurentoOptions.put((Object)"videoMinSendBandwidth", (Object)tokenOptions.getKurentoOptions().getVideoMinSendBandwidth());
            }
            if (tokenOptions.getKurentoOptions().getAllowedFilters().length > 0) {
                JSONArray allowedFilters = new JSONArray();
                for (String filter : tokenOptions.getKurentoOptions().getAllowedFilters()) {
                    allowedFilters.add((Object)filter);
                }
                kurentoOptions.put((Object)"allowedFilters", (Object)allowedFilters);
            }
            json.put((Object)"kurentoOptions", (Object)kurentoOptions);
        }
        try {
            params = new StringEntity(json.toString());
        }
        catch (UnsupportedEncodingException e1) {
            throw new OpenViduJavaClientException(e1.getMessage(), e1.getCause());
        }
        request.setHeader("Content-Type", "application/json");
        request.setEntity((HttpEntity)params);
        try {
            response = OpenVidu.httpClient.execute((HttpUriRequest)request);
        }
        catch (IOException e2) {
            throw new OpenViduJavaClientException(e2.getMessage(), e2.getCause());
        }
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                String token = (String)this.httpResponseToJson(response).get((Object)"id");
                log.info("Returning a TOKEN: {}", (Object)token);
                String string = token;
                return string;
            }
            throw new OpenViduHttpException(statusCode);
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws OpenViduJavaClientException, OpenViduHttpException {
        block6: {
            HttpResponse response;
            HttpDelete request = new HttpDelete(OpenVidu.urlOpenViduServer + "api/sessions" + "/" + this.sessionId);
            request.setHeader("Content-Type", "application/x-www-form-urlencoded");
            try {
                response = OpenVidu.httpClient.execute((HttpUriRequest)request);
            }
            catch (IOException e) {
                throw new OpenViduJavaClientException(e.getMessage(), e.getCause());
            }
            try {
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 204) {
                    OpenVidu.activeSessions.remove(this.sessionId);
                    log.info("Session {} closed", (Object)this.sessionId);
                    break block6;
                }
                throw new OpenViduHttpException(statusCode);
            }
            finally {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }

    public boolean fetch() throws OpenViduJavaClientException, OpenViduHttpException {
        HttpResponse response;
        String beforeJSON = this.toJson();
        HttpGet request = new HttpGet(OpenVidu.urlOpenViduServer + "api/sessions" + "/" + this.sessionId);
        request.setHeader("Content-Type", "application/x-www-form-urlencoded");
        try {
            response = OpenVidu.httpClient.execute((HttpUriRequest)request);
        }
        catch (IOException e) {
            throw new OpenViduJavaClientException(e.getMessage(), e.getCause());
        }
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                this.resetSessionWithJson(this.httpResponseToJson(response));
                String afterJSON = this.toJson();
                boolean hasChanged = !beforeJSON.equals(afterJSON);
                log.info("Session info fetched for session '{}'. Any change: {}", (Object)this.sessionId, (Object)hasChanged);
                boolean bl = hasChanged;
                return bl;
            }
            throw new OpenViduHttpException(statusCode);
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
    }

    public void forceDisconnect(Connection connection) throws OpenViduJavaClientException, OpenViduHttpException {
        this.forceDisconnect(connection.getConnectionId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceDisconnect(String connectionId) throws OpenViduJavaClientException, OpenViduHttpException {
        block10: {
            HttpDelete request = new HttpDelete(OpenVidu.urlOpenViduServer + "api/sessions" + "/" + this.sessionId + "/connection/" + connectionId);
            request.setHeader("Content-Type", "application/x-www-form-urlencoded");
            HttpResponse response = null;
            try {
                response = OpenVidu.httpClient.execute((HttpUriRequest)request);
            }
            catch (IOException e) {
                throw new OpenViduJavaClientException(e.getMessage(), e.getCause());
            }
            try {
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 204) {
                    Connection connectionClosed = this.activeConnections.remove(connectionId);
                    if (connectionClosed != null) {
                        for (Publisher publisher : connectionClosed.getPublishers()) {
                            String streamId = publisher.getStreamId();
                            for (Connection connection : this.activeConnections.values()) {
                                connection.setSubscribers(connection.getSubscribers().stream().filter(subscriber -> !streamId.equals(subscriber)).collect(Collectors.toList()));
                            }
                        }
                    } else {
                        log.warn("The closed connection wasn't fetched in OpenVidu Java Client. No changes in the collection of active connections of the Session");
                    }
                    log.info("Connection {} closed", (Object)connectionId);
                    break block10;
                }
                throw new OpenViduHttpException(statusCode);
            }
            finally {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }

    public void forceUnpublish(Publisher publisher) throws OpenViduJavaClientException, OpenViduHttpException {
        this.forceUnpublish(publisher.getStreamId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceUnpublish(String streamId) throws OpenViduJavaClientException, OpenViduHttpException {
        block7: {
            HttpResponse response;
            HttpDelete request = new HttpDelete(OpenVidu.urlOpenViduServer + "api/sessions" + "/" + this.sessionId + "/stream/" + streamId);
            request.setHeader("Content-Type", "application/x-www-form-urlencoded");
            try {
                response = OpenVidu.httpClient.execute((HttpUriRequest)request);
            }
            catch (IOException e) {
                throw new OpenViduJavaClientException(e.getMessage(), e.getCause());
            }
            try {
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 204) {
                    for (Connection connection : this.activeConnections.values()) {
                        if (connection.publishers.remove(streamId) != null) continue;
                        connection.subscribers.remove(streamId);
                    }
                    log.info("Stream {} unpublished", (Object)streamId);
                    break block7;
                }
                throw new OpenViduHttpException(statusCode);
            }
            finally {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }

    public List<Connection> getActiveConnections() {
        return new ArrayList<Connection>(this.activeConnections.values());
    }

    public boolean isBeingRecorded() {
        return this.recording;
    }

    public SessionProperties getProperties() {
        return this.properties;
    }

    public String toString() {
        return this.sessionId;
    }

    private boolean hasSessionId() {
        return this.sessionId != null && !this.sessionId.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSessionIdHttp() throws OpenViduJavaClientException, OpenViduHttpException {
        block10: {
            HttpResponse response;
            if (this.hasSessionId()) {
                return;
            }
            HttpPost request = new HttpPost(OpenVidu.urlOpenViduServer + "api/sessions");
            JSONObject json = new JSONObject();
            json.put((Object)"mediaMode", (Object)this.properties.mediaMode().name());
            json.put((Object)"recordingMode", (Object)this.properties.recordingMode().name());
            json.put((Object)"defaultOutputMode", (Object)this.properties.defaultOutputMode().name());
            json.put((Object)"defaultRecordingLayout", (Object)this.properties.defaultRecordingLayout().name());
            json.put((Object)"defaultCustomLayout", (Object)this.properties.defaultCustomLayout());
            json.put((Object)"customSessionId", (Object)this.properties.customSessionId());
            StringEntity params = null;
            try {
                params = new StringEntity(json.toString());
            }
            catch (UnsupportedEncodingException e1) {
                throw new OpenViduJavaClientException(e1.getMessage(), e1.getCause());
            }
            request.setHeader("Content-Type", "application/json");
            request.setEntity((HttpEntity)params);
            try {
                response = OpenVidu.httpClient.execute((HttpUriRequest)request);
            }
            catch (IOException e2) {
                throw new OpenViduJavaClientException(e2.getMessage(), e2.getCause());
            }
            try {
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 200) {
                    JSONObject responseJson = this.httpResponseToJson(response);
                    this.sessionId = (String)responseJson.get((Object)"id");
                    this.createdAt = (Long)responseJson.get((Object)"createdAt");
                    log.info("Session '{}' created", (Object)this.sessionId);
                    break block10;
                }
                if (statusCode == 409) {
                    this.sessionId = this.properties.customSessionId();
                    break block10;
                }
                throw new OpenViduHttpException(statusCode);
            }
            finally {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }

    private JSONObject httpResponseToJson(HttpResponse response) throws OpenViduJavaClientException {
        JSONObject json;
        JSONParser parser = new JSONParser();
        try {
            json = (JSONObject)parser.parse(EntityUtils.toString((HttpEntity)response.getEntity()));
        }
        catch (IOException | ParseException | org.json.simple.parser.ParseException e) {
            throw new OpenViduJavaClientException(e.getMessage(), e.getCause());
        }
        return json;
    }

    protected void setIsBeingRecorded(boolean recording) {
        this.recording = recording;
    }

    protected Session resetSessionWithJson(JSONObject json) {
        this.sessionId = (String)json.get((Object)"sessionId");
        this.createdAt = (Long)json.get((Object)"createdAt");
        this.recording = (Boolean)json.get((Object)"recording");
        SessionProperties.Builder builder = new SessionProperties.Builder().mediaMode(MediaMode.valueOf((String)json.get((Object)"mediaMode"))).recordingMode(RecordingMode.valueOf((String)json.get((Object)"recordingMode"))).defaultOutputMode(Recording.OutputMode.valueOf((String)json.get((Object)"defaultOutputMode")));
        if (json.containsKey((Object)"defaultRecordingLayout")) {
            builder.defaultRecordingLayout(RecordingLayout.valueOf((String)json.get((Object)"defaultRecordingLayout")));
        }
        if (json.containsKey((Object)"defaultCustomLayout")) {
            builder.defaultCustomLayout((String)json.get((Object)"defaultCustomLayout"));
        }
        if (this.properties != null && this.properties.customSessionId() != null) {
            builder.customSessionId(this.properties.customSessionId());
        } else if (json.containsKey((Object)"customSessionId")) {
            builder.customSessionId((String)json.get((Object)"customSessionId"));
        }
        this.properties = builder.build();
        JSONArray jsonArrayConnections = (JSONArray)((JSONObject)json.get((Object)"connections")).get((Object)"content");
        this.activeConnections.clear();
        jsonArrayConnections.forEach(connection -> {
            JSONObject con = (JSONObject)connection;
            ConcurrentHashMap<String, Publisher> publishers = new ConcurrentHashMap<String, Publisher>();
            JSONArray jsonArrayPublishers = (JSONArray)con.get((Object)"publishers");
            jsonArrayPublishers.forEach(publisher -> {
                JSONObject pubJson = (JSONObject)publisher;
                JSONObject mediaOptions = (JSONObject)pubJson.get((Object)"mediaOptions");
                Publisher pub = new Publisher((String)pubJson.get((Object)"streamId"), (Long)pubJson.get((Object)"createdAt"), (Boolean)mediaOptions.get((Object)"hasAudio"), (Boolean)mediaOptions.get((Object)"hasVideo"), mediaOptions.get((Object)"audioActive"), mediaOptions.get((Object)"videoActive"), mediaOptions.get((Object)"frameRate"), mediaOptions.get((Object)"typeOfVideo"), mediaOptions.get((Object)"videoDimensions"));
                publishers.put(pub.getStreamId(), pub);
            });
            ArrayList<String> subscribers = new ArrayList<String>();
            JSONArray jsonArraySubscribers = (JSONArray)con.get((Object)"subscribers");
            jsonArraySubscribers.forEach(subscriber -> subscribers.add((String)((JSONObject)subscriber).get((Object)"streamId")));
            this.activeConnections.put((String)con.get((Object)"connectionId"), new Connection((String)con.get((Object)"connectionId"), (Long)con.get((Object)"createdAt"), OpenViduRole.valueOf((String)con.get((Object)"role")), (String)con.get((Object)"token"), (String)con.get((Object)"location"), (String)con.get((Object)"platform"), (String)con.get((Object)"serverData"), (String)con.get((Object)"clientData"), publishers, subscribers));
        });
        return this;
    }

    protected String toJson() {
        JSONObject json = new JSONObject();
        json.put((Object)"sessionId", (Object)this.sessionId);
        json.put((Object)"createdAt", (Object)this.createdAt);
        json.put((Object)"customSessionId", (Object)this.properties.customSessionId());
        json.put((Object)"recording", (Object)this.recording);
        json.put((Object)"mediaMode", (Object)this.properties.mediaMode().name());
        json.put((Object)"recordingMode", (Object)this.properties.recordingMode().name());
        json.put((Object)"defaultOutputMode", (Object)this.properties.defaultOutputMode().name());
        json.put((Object)"defaultRecordingLayout", (Object)this.properties.defaultRecordingLayout().name());
        json.put((Object)"defaultCustomLayout", (Object)this.properties.defaultCustomLayout());
        JSONObject connections = new JSONObject();
        connections.put((Object)"numberOfElements", (Object)this.getActiveConnections().size());
        JSONArray jsonArrayConnections = new JSONArray();
        this.getActiveConnections().forEach(con -> {
            JSONObject c = new JSONObject();
            c.put((Object)"connectionId", (Object)con.getConnectionId());
            c.put((Object)"role", (Object)con.getRole().name());
            c.put((Object)"token", (Object)con.getToken());
            c.put((Object)"clientData", (Object)con.getClientData());
            c.put((Object)"serverData", (Object)con.getServerData());
            JSONArray pubs = new JSONArray();
            con.getPublishers().forEach(p -> pubs.add((Object)p.toJson()));
            JSONArray subs = new JSONArray();
            con.getSubscribers().forEach(s -> subs.add(s));
            c.put((Object)"publishers", (Object)pubs);
            c.put((Object)"subscribers", (Object)subs);
            jsonArrayConnections.add((Object)c);
        });
        connections.put((Object)"content", (Object)jsonArrayConnections);
        json.put((Object)"connections", (Object)connections);
        return json.toJSONString();
    }
}

