/*
 * Decompiled with CFR 0.152.
 */
package io.openvidu.java.client;

import io.openvidu.java.client.RecordingLayout;
import io.openvidu.java.client.RecordingProperties;
import org.json.simple.JSONObject;

public class Recording {
    private Status status;
    private String id;
    private String sessionId;
    private long createdAt;
    private long size;
    private double duration;
    private String url;
    private RecordingProperties recordingProperties;

    protected Recording(JSONObject json) {
        this.id = (String)json.get((Object)"id");
        this.sessionId = (String)json.get((Object)"sessionId");
        this.createdAt = (Long)json.get((Object)"createdAt");
        this.size = (Long)json.get((Object)"size");
        this.duration = (Double)json.get((Object)"duration");
        this.url = (String)json.get((Object)"url");
        this.status = Status.valueOf((String)json.get((Object)"status"));
        boolean hasAudio = (Boolean)json.get((Object)"hasAudio");
        boolean hasVideo = (Boolean)json.get((Object)"hasVideo");
        OutputMode outputMode = OutputMode.valueOf((String)json.get((Object)"outputMode"));
        RecordingProperties.Builder builder = new RecordingProperties.Builder().name((String)json.get((Object)"name")).outputMode(outputMode).hasAudio(hasAudio).hasVideo(hasVideo);
        if (OutputMode.COMPOSED.equals((Object)outputMode) && hasVideo) {
            builder.resolution((String)json.get((Object)"resolution"));
            builder.recordingLayout(RecordingLayout.valueOf((String)json.get((Object)"recordingLayout")));
            String customLayout = (String)json.get((Object)"customLayout");
            if (customLayout != null) {
                builder.customLayout(customLayout);
            }
        }
        this.recordingProperties = builder.build();
    }

    public Status getStatus() {
        return this.status;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.recordingProperties.name();
    }

    public OutputMode getOutputMode() {
        return this.recordingProperties.outputMode();
    }

    public RecordingLayout getRecordingLayout() {
        return this.recordingProperties.recordingLayout();
    }

    public String getCustomLayout() {
        return this.recordingProperties.customLayout();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public long getSize() {
        return this.size;
    }

    public double getDuration() {
        return this.duration;
    }

    public String getUrl() {
        return this.url;
    }

    public String getResolution() {
        return this.recordingProperties.resolution();
    }

    public boolean hasAudio() {
        return this.recordingProperties.hasAudio();
    }

    public boolean hasVideo() {
        return this.recordingProperties.hasVideo();
    }

    public static enum OutputMode {
        COMPOSED,
        INDIVIDUAL;

    }

    public static enum Status {
        starting,
        started,
        stopped,
        available,
        failed;

    }
}

