/*
 * Decompiled with CFR 0.152.
 */
package io.openvidu.java.client;

import io.openvidu.java.client.OpenViduHttpException;
import io.openvidu.java.client.OpenViduJavaClientException;
import io.openvidu.java.client.Recording;
import io.openvidu.java.client.RecordingLayout;
import io.openvidu.java.client.RecordingProperties;
import io.openvidu.java.client.Session;
import io.openvidu.java.client.SessionProperties;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenVidu {
    private static final Logger log = LoggerFactory.getLogger(OpenVidu.class);
    private String secret;
    protected static String urlOpenViduServer;
    protected static HttpClient httpClient;
    protected static Map<String, Session> activeSessions;
    protected static final String API_SESSIONS = "api/sessions";
    protected static final String API_TOKENS = "api/tokens";
    protected static final String API_RECORDINGS = "api/recordings";
    protected static final String API_RECORDINGS_START = "/start";
    protected static final String API_RECORDINGS_STOP = "/stop";

    public OpenVidu(String urlOpenViduServer, String secret) {
        SSLContext sslContext;
        OpenVidu.urlOpenViduServer = urlOpenViduServer;
        if (!OpenVidu.urlOpenViduServer.endsWith("/")) {
            OpenVidu.urlOpenViduServer = OpenVidu.urlOpenViduServer + "/";
        }
        this.secret = secret;
        TrustStrategy trustStrategy = new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                return true;
            }
        };
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("OPENVIDUAPP", this.secret);
        provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
        try {
            sslContext = new SSLContextBuilder().loadTrustMaterial(null, trustStrategy).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        RequestConfig.Builder requestBuilder = RequestConfig.custom();
        requestBuilder = requestBuilder.setConnectTimeout(30000);
        requestBuilder = requestBuilder.setConnectionRequestTimeout(30000);
        httpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestBuilder.build()).setConnectionTimeToLive(30L, TimeUnit.SECONDS).setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).setSSLContext(sslContext).setDefaultCredentialsProvider((CredentialsProvider)provider).build();
    }

    public Session createSession() throws OpenViduJavaClientException, OpenViduHttpException {
        Session s = new Session();
        activeSessions.put(s.getSessionId(), s);
        return s;
    }

    public Session createSession(SessionProperties properties) throws OpenViduJavaClientException, OpenViduHttpException {
        Session s = new Session(properties);
        activeSessions.put(s.getSessionId(), s);
        return s;
    }

    public Recording startRecording(String sessionId, RecordingProperties properties) throws OpenViduJavaClientException, OpenViduHttpException {
        HttpResponse response;
        HttpPost request = new HttpPost(urlOpenViduServer + API_RECORDINGS + API_RECORDINGS_START);
        JSONObject json = new JSONObject();
        json.put((Object)"session", (Object)sessionId);
        json.put((Object)"name", (Object)properties.name());
        json.put((Object)"outputMode", (Object)properties.outputMode().name());
        json.put((Object)"hasAudio", (Object)properties.hasAudio());
        json.put((Object)"hasVideo", (Object)properties.hasVideo());
        if (Recording.OutputMode.COMPOSED.equals((Object)properties.outputMode()) && properties.hasVideo()) {
            json.put((Object)"resolution", (Object)properties.resolution());
            json.put((Object)"recordingLayout", (Object)(properties.recordingLayout() != null ? properties.recordingLayout().name() : ""));
            if (RecordingLayout.CUSTOM.equals((Object)properties.recordingLayout())) {
                json.put((Object)"customLayout", (Object)(properties.customLayout() != null ? properties.customLayout() : ""));
            }
        }
        StringEntity params = null;
        try {
            params = new StringEntity(json.toString());
        }
        catch (UnsupportedEncodingException e1) {
            throw new OpenViduJavaClientException(e1.getMessage(), e1.getCause());
        }
        request.setHeader("Content-Type", "application/json");
        request.setEntity((HttpEntity)params);
        try {
            response = httpClient.execute((HttpUriRequest)request);
        }
        catch (IOException e2) {
            throw new OpenViduJavaClientException(e2.getMessage(), e2.getCause());
        }
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                Recording r = new Recording(this.httpResponseToJson(response));
                Session activeSession = activeSessions.get(r.getSessionId());
                if (activeSession != null) {
                    activeSession.setIsBeingRecorded(true);
                } else {
                    log.warn("No active session found for sessionId '" + r.getSessionId() + "'. This instance of OpenVidu Java Client didn't create this session");
                }
                Recording recording = r;
                return recording;
            }
            throw new OpenViduHttpException(statusCode);
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
    }

    public Recording startRecording(String sessionId, String name) throws OpenViduJavaClientException, OpenViduHttpException {
        if (name == null) {
            name = "";
        }
        return this.startRecording(sessionId, new RecordingProperties.Builder().name(name).build());
    }

    public Recording startRecording(String sessionId) throws OpenViduJavaClientException, OpenViduHttpException {
        return this.startRecording(sessionId, "");
    }

    public Recording stopRecording(String recordingId) throws OpenViduJavaClientException, OpenViduHttpException {
        HttpResponse response;
        HttpPost request = new HttpPost(urlOpenViduServer + API_RECORDINGS + API_RECORDINGS_STOP + "/" + recordingId);
        try {
            response = httpClient.execute((HttpUriRequest)request);
        }
        catch (IOException e) {
            throw new OpenViduJavaClientException(e.getMessage(), e.getCause());
        }
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                Recording r = new Recording(this.httpResponseToJson(response));
                Session activeSession = activeSessions.get(r.getSessionId());
                if (activeSession != null) {
                    activeSession.setIsBeingRecorded(false);
                } else {
                    log.warn("No active session found for sessionId '" + r.getSessionId() + "'. This instance of OpenVidu Java Client didn't create this session");
                }
                Recording recording = r;
                return recording;
            }
            throw new OpenViduHttpException(statusCode);
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
    }

    public Recording getRecording(String recordingId) throws OpenViduJavaClientException, OpenViduHttpException {
        HttpResponse response;
        HttpGet request = new HttpGet(urlOpenViduServer + API_RECORDINGS + "/" + recordingId);
        try {
            response = httpClient.execute((HttpUriRequest)request);
        }
        catch (IOException e) {
            throw new OpenViduJavaClientException(e.getMessage(), e.getCause());
        }
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                Recording recording = new Recording(this.httpResponseToJson(response));
                return recording;
            }
            throw new OpenViduHttpException(statusCode);
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
    }

    public List<Recording> listRecordings() throws OpenViduJavaClientException, OpenViduHttpException {
        HttpResponse response;
        HttpGet request = new HttpGet(urlOpenViduServer + API_RECORDINGS);
        try {
            response = httpClient.execute((HttpUriRequest)request);
        }
        catch (IOException e) {
            throw new OpenViduJavaClientException(e.getMessage(), e.getCause());
        }
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                ArrayList<Recording> recordings = new ArrayList<Recording>();
                JSONObject json = this.httpResponseToJson(response);
                JSONArray array = (JSONArray)json.get((Object)"items");
                array.forEach(item -> recordings.add(new Recording((JSONObject)item)));
                ArrayList<Recording> arrayList = recordings;
                return arrayList;
            }
            throw new OpenViduHttpException(statusCode);
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRecording(String recordingId) throws OpenViduJavaClientException, OpenViduHttpException {
        HttpResponse response;
        HttpDelete request = new HttpDelete(urlOpenViduServer + API_RECORDINGS + "/" + recordingId);
        try {
            response = httpClient.execute((HttpUriRequest)request);
        }
        catch (IOException e) {
            throw new OpenViduJavaClientException(e.getMessage(), e.getCause());
        }
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 204) {
                throw new OpenViduHttpException(statusCode);
            }
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
    }

    public List<Session> getActiveSessions() {
        return new ArrayList<Session>(activeSessions.values());
    }

    public boolean fetch() throws OpenViduJavaClientException, OpenViduHttpException {
        HttpResponse response;
        HttpGet request = new HttpGet(urlOpenViduServer + API_SESSIONS);
        try {
            response = httpClient.execute((HttpUriRequest)request);
        }
        catch (IOException e2) {
            throw new OpenViduJavaClientException(e2.getMessage(), e2.getCause());
        }
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                JSONObject jsonSessions = this.httpResponseToJson(response);
                JSONArray jsonArraySessions = (JSONArray)jsonSessions.get((Object)"content");
                HashSet fetchedSessionIds = new HashSet();
                boolean[] hasChanged = new boolean[]{false};
                jsonArraySessions.forEach(session -> {
                    String sessionId = (String)((JSONObject)session).get((Object)"sessionId");
                    fetchedSessionIds.add(sessionId);
                    activeSessions.computeIfPresent(sessionId, (sId, s) -> {
                        String afterJSON;
                        String beforeJSON = s.toJson();
                        boolean changed = !beforeJSON.equals(afterJSON = (s = s.resetSessionWithJson((JSONObject)session)).toJson());
                        hasChanged[0] = hasChanged[0] || changed;
                        log.info("Available session '{}' info fetched. Any change: {}", (Object)sessionId, (Object)changed);
                        return s;
                    });
                    activeSessions.computeIfAbsent(sessionId, sId -> {
                        log.info("New session '{}' fetched", (Object)sessionId);
                        hasChanged[0] = true;
                        return new Session((JSONObject)session);
                    });
                });
                activeSessions = activeSessions.entrySet().stream().filter(entry -> {
                    if (fetchedSessionIds.contains(entry.getKey())) {
                        return true;
                    }
                    log.info("Removing closed session {}" + (String)entry.getKey());
                    hasChanged[0] = true;
                    return false;
                }).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Session)e.getValue()));
                log.info("Active sessions info fetched: {}", activeSessions.keySet());
                boolean bl = hasChanged[0];
                return bl;
            }
            throw new OpenViduHttpException(statusCode);
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
    }

    private JSONObject httpResponseToJson(HttpResponse response) throws OpenViduJavaClientException {
        JSONObject json;
        JSONParser parser = new JSONParser();
        try {
            json = (JSONObject)parser.parse(EntityUtils.toString((HttpEntity)response.getEntity()));
        }
        catch (IOException | org.apache.http.ParseException | ParseException e) {
            throw new OpenViduJavaClientException(e.getMessage(), e.getCause());
        }
        return json;
    }

    static {
        activeSessions = new ConcurrentHashMap<String, Session>();
    }
}

