/*
 * Decompiled with CFR 0.152.
 */
package io.openvidu.java.client;

import io.openvidu.java.client.MediaMode;
import io.openvidu.java.client.RecordingLayout;
import io.openvidu.java.client.RecordingMode;

public class SessionProperties {
    private MediaMode mediaMode;
    private RecordingMode recordingMode;
    private RecordingLayout defaultRecordingLayout;
    private String defaultCustomLayout;
    private String customSessionId;

    protected SessionProperties() {
        this.mediaMode = MediaMode.ROUTED;
        this.recordingMode = RecordingMode.MANUAL;
        this.defaultRecordingLayout = RecordingLayout.BEST_FIT;
        this.defaultCustomLayout = "";
        this.customSessionId = "";
    }

    private SessionProperties(MediaMode mediaMode, RecordingMode recordingMode, RecordingLayout layout, String defaultCustomLayout, String customSessionId) {
        this.mediaMode = mediaMode;
        this.recordingMode = recordingMode;
        this.defaultRecordingLayout = layout;
        this.defaultCustomLayout = defaultCustomLayout;
        this.customSessionId = customSessionId;
    }

    public RecordingMode recordingMode() {
        return this.recordingMode;
    }

    public MediaMode mediaMode() {
        return this.mediaMode;
    }

    public RecordingLayout defaultRecordingLayout() {
        return this.defaultRecordingLayout;
    }

    public String defaultCustomLayout() {
        return this.defaultCustomLayout;
    }

    public String customSessionId() {
        return this.customSessionId;
    }

    public static class Builder {
        private MediaMode mediaMode = MediaMode.ROUTED;
        private RecordingMode recordingMode = RecordingMode.MANUAL;
        private RecordingLayout defaultRecordingLayout = RecordingLayout.BEST_FIT;
        private String defaultCustomLayout = "";
        private String customSessionId = "";

        public SessionProperties build() {
            return new SessionProperties(this.mediaMode, this.recordingMode, this.defaultRecordingLayout, this.defaultCustomLayout, this.customSessionId);
        }

        public Builder mediaMode(MediaMode mediaMode) {
            this.mediaMode = mediaMode;
            return this;
        }

        public Builder recordingMode(RecordingMode recordingMode) {
            this.recordingMode = recordingMode;
            return this;
        }

        public Builder defaultRecordingLayout(RecordingLayout layout) {
            this.defaultRecordingLayout = layout;
            return this;
        }

        public Builder defaultCustomLayout(String path) {
            this.defaultCustomLayout = path;
            return this;
        }

        public Builder customSessionId(String customSessionId) {
            this.customSessionId = customSessionId;
            return this;
        }
    }
}

