/*
 * Decompiled with CFR 0.152.
 */
package io.openvidu.java.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import io.openvidu.java.client.KurentoOptions;
import io.openvidu.java.client.OpenViduRole;

public class TokenOptions {
    private OpenViduRole role;
    private String data;
    private KurentoOptions kurentoOptions;

    TokenOptions(OpenViduRole role, String data, KurentoOptions kurentoOptions) {
        this.role = role;
        this.data = data;
        this.kurentoOptions = kurentoOptions;
    }

    public OpenViduRole getRole() {
        return this.role;
    }

    public String getData() {
        return this.data;
    }

    public KurentoOptions getKurentoOptions() {
        return this.kurentoOptions;
    }

    protected JsonObject toJsonObject(String sessionId) {
        JsonObject json = new JsonObject();
        json.addProperty("session", sessionId);
        if (this.getRole() != null) {
            json.addProperty("role", this.getRole().name());
        } else {
            json.add("role", (JsonElement)JsonNull.INSTANCE);
        }
        if (this.getData() != null) {
            json.addProperty("data", this.getData());
        } else {
            json.add("data", (JsonElement)JsonNull.INSTANCE);
        }
        if (this.kurentoOptions != null) {
            json.add("kurentoOptions", (JsonElement)this.kurentoOptions.toJson());
        }
        return json;
    }

    public static class Builder {
        private OpenViduRole role = OpenViduRole.PUBLISHER;
        private String data;
        private KurentoOptions kurentoOptions;

        public TokenOptions build() {
            return new TokenOptions(this.role, this.data, this.kurentoOptions);
        }

        public Builder role(OpenViduRole role) {
            this.role = role;
            return this;
        }

        public Builder data(String data) {
            this.data = data;
            return this;
        }

        public Builder kurentoOptions(KurentoOptions kurentoOptions) {
            this.kurentoOptions = kurentoOptions;
            return this;
        }
    }
}

