/*
 * Decompiled with CFR 0.152.
 */
package io.openvidu.java.client;

import com.google.gson.JsonObject;
import java.net.Inet6Address;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashSet;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.validator.routines.DomainValidator;
import org.apache.commons.validator.routines.InetAddressValidator;

public class IceServerProperties {
    private String url;
    private String username;
    private String credential;

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getCredential() {
        return this.credential;
    }

    private IceServerProperties(String url, String username, String credential) {
        this.url = url;
        this.username = username;
        this.credential = credential;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("url", this.getUrl());
        if (this.getUsername() != null && !this.getUsername().isEmpty()) {
            json.addProperty("username", this.getUsername());
        }
        if (this.getCredential() != null && !this.getCredential().isEmpty()) {
            json.addProperty("credential", this.getCredential());
        }
        return json;
    }

    public static class Builder {
        private String url;
        private String username;
        private String credential;
        private String staticAuthSecret;
        private boolean ignoreEmptyUrl = false;

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder username(String userName) {
            this.username = userName;
            return this;
        }

        public Builder credential(String credential) {
            this.credential = credential;
            return this;
        }

        public Builder staticAuthSecret(String staticAuthSecret) {
            this.staticAuthSecret = staticAuthSecret;
            return this;
        }

        public Builder ignoreEmptyUrl(boolean ignore) {
            this.ignoreEmptyUrl = true;
            return this;
        }

        public Builder clone() {
            return new Builder().url(this.url).username(this.username).credential(this.credential).staticAuthSecret(this.staticAuthSecret);
        }

        public IceServerProperties build() throws IllegalArgumentException {
            if (this.ignoreEmptyUrl) {
                if (this.staticAuthSecret != null && this.username == null && this.credential == null) {
                    try {
                        this.generateTURNCredentials();
                        return new IceServerProperties(this.url, this.username, this.credential);
                    }
                    catch (InvalidKeyException | NoSuchAlgorithmException e) {
                        throw new IllegalArgumentException("Error while generating credentials: " + e.getMessage());
                    }
                }
                throw new IllegalArgumentException("ignoreEmptyUrl=true can only be used with staticAuthSecret defined");
            }
            if (this.url == null) {
                throw new IllegalArgumentException("External turn url cannot be null");
            }
            this.checkValidStunTurn(this.url);
            if (this.url.startsWith("turn")) {
                if (this.staticAuthSecret != null) {
                    if (this.username != null || this.credential != null) {
                        throw new IllegalArgumentException("You can't define username or credential if staticAuthSecret is defined");
                    }
                    try {
                        this.generateTURNCredentials();
                    }
                    catch (InvalidKeyException | NoSuchAlgorithmException e) {
                        throw new IllegalArgumentException("Error while generating credentials: " + e.getMessage());
                    }
                }
                if (this.username == null || this.credential == null) {
                    throw new IllegalArgumentException("Credentials must be defined while using turn");
                }
            } else if (this.url.startsWith("stun") && (this.username != null || this.credential != null)) {
                throw new IllegalArgumentException("Credentials can not be defined while using stun.");
            }
            return new IceServerProperties(this.url, this.username, this.credential);
        }

        private void checkValidStunTurn(String uri) throws IllegalArgumentException {
            int endIpv6Index;
            String TCP_TRANSPORT_SUFFIX = "?transport=tcp";
            String UDP_TRANSPORT_SUFFIX = "?transport=udp";
            HashSet<String> TURN_PROTOCOLS = new HashSet<String>(Arrays.asList("turn", "turns"));
            HashSet<String> STUN_PROTOCOLS = new HashSet<String>(Arrays.asList("stun", "stuns"));
            int firstColonPos = uri.indexOf(58);
            if (firstColonPos == -1) {
                throw new IllegalArgumentException("Not a valid TURN/STUN uri provided. No colons found in: '" + uri + "'");
            }
            String protocol = uri.substring(0, firstColonPos);
            if (!TURN_PROTOCOLS.contains(protocol) && !STUN_PROTOCOLS.contains(protocol)) {
                throw new IllegalArgumentException("The protocol '" + protocol + "' is invalid. Only valid values are: " + TURN_PROTOCOLS + " " + STUN_PROTOCOLS);
            }
            int qmarkPos = uri.indexOf(63);
            String hostAndPort = uri.substring(firstColonPos + 1);
            if (qmarkPos != -1) {
                if (TURN_PROTOCOLS.contains(protocol)) {
                    String rawTransportType = uri.substring(qmarkPos);
                    hostAndPort = uri.substring(firstColonPos + 1, qmarkPos);
                    if (!"?transport=tcp".equals(rawTransportType) && !"?transport=udp".equals(rawTransportType)) {
                        throw new IllegalArgumentException("Wrong value specified in STUN/TURN uri: '" + uri + "'. Unique valid arguments after '?' are '?transport=tcp' or '?transport=udp");
                    }
                } else {
                    throw new IllegalArgumentException("STUN uri can't have any '?' query param");
                }
            }
            int portColon = hostAndPort.indexOf(58);
            int startIpv6Index = hostAndPort.indexOf(91);
            if (startIpv6Index == -1 ^ (endIpv6Index = hostAndPort.indexOf(93)) == -1) {
                throw new IllegalArgumentException("Not closed bracket '[' or ']' in uri: " + uri);
            }
            if (portColon != -1) {
                if (startIpv6Index == -1 && endIpv6Index == -1) {
                    String[] splittedHostAndPort = hostAndPort.split(":");
                    if (splittedHostAndPort.length != 2) {
                        throw new IllegalArgumentException("Host or port are not correctly defined in STUN/TURN uri: '" + uri + "'");
                    }
                    String host = splittedHostAndPort[0];
                    String port = splittedHostAndPort[1];
                    this.checkHostAndPort(uri, host, port);
                } else {
                    String ipv6 = hostAndPort.substring(startIpv6Index + 1, endIpv6Index);
                    String auxPort = hostAndPort.substring(endIpv6Index + 1);
                    if (auxPort.startsWith(":")) {
                        if (auxPort.length() == 1) {
                            throw new IllegalArgumentException("Host or port are not correctly defined in STUN/TURN uri: " + uri);
                        }
                        String host = ipv6;
                        String port = auxPort.substring(1);
                        this.checkHostAndPort(uri, host, port);
                    } else if (auxPort.length() > 0) {
                        throw new IllegalArgumentException("Port is not specified correctly after IPv6 in uri: '" + uri + "'");
                    }
                }
            } else {
                String host = hostAndPort;
                this.checkHost(uri, host);
            }
        }

        private void checkHost(String uri, String host) {
            if (host == null || host.isEmpty()) {
                throw new IllegalArgumentException("Host defined in '" + uri + "' is empty or null");
            }
            if (DomainValidator.getInstance().isValid(host)) {
                return;
            }
            InetAddressValidator ipValidator = InetAddressValidator.getInstance();
            if (ipValidator.isValid(host)) {
                return;
            }
            try {
                Inet6Address.getByName(host).getHostAddress();
                return;
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("Is not a valid Internet Address (IP or Domain Name): '" + host + "'");
            }
        }

        private void checkPort(String uri, String port) {
            if (port == null || port.isEmpty()) {
                throw new IllegalArgumentException("Port defined in '" + uri + "' is empty or null");
            }
            try {
                int parsedPort = Integer.parseInt(port);
                if (parsedPort <= 0 || parsedPort > 65535) {
                    throw new IllegalArgumentException("The port defined in '" + uri + "' is not a valid port number (0-65535)");
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("The port defined in '" + uri + "' is not a number (0-65535)");
            }
        }

        private void checkHostAndPort(String uri, String host, String port) {
            this.checkHost(uri, host);
            this.checkPort(uri, port);
        }

        private void generateTURNCredentials() throws NoSuchAlgorithmException, InvalidKeyException {
            char[] ALPHANUMERIC = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".toCharArray();
            int MAX_LENGTH = 8;
            StringBuilder randomUsername = new StringBuilder();
            for (int i = 0; i < MAX_LENGTH; ++i) {
                int index = new SecureRandom().nextInt(ALPHANUMERIC.length);
                randomUsername.append(ALPHANUMERIC[index]);
            }
            String unixTimestamp = Long.toString(System.currentTimeMillis() / 1000L + 86400L);
            String username = unixTimestamp + ":" + randomUsername;
            SecretKeySpec signingKey = new SecretKeySpec(this.staticAuthSecret.getBytes(), "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(signingKey);
            String credential = new String(Base64.getEncoder().encode(mac.doFinal(username.getBytes())));
            this.username = username;
            this.credential = credential;
        }
    }
}

