/*
 * Decompiled with CFR 0.152.
 */
package io.openvidu.java.client;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.openvidu.java.client.Connection;
import io.openvidu.java.client.ConnectionProperties;
import io.openvidu.java.client.MediaMode;
import io.openvidu.java.client.OpenVidu;
import io.openvidu.java.client.OpenViduHttpException;
import io.openvidu.java.client.OpenViduJavaClientException;
import io.openvidu.java.client.OpenViduRole;
import io.openvidu.java.client.Publisher;
import io.openvidu.java.client.RecordingMode;
import io.openvidu.java.client.RecordingProperties;
import io.openvidu.java.client.SessionProperties;
import io.openvidu.java.client.TokenOptions;
import io.openvidu.java.client.VideoCodec;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Session {
    private static final Logger log = LoggerFactory.getLogger(Session.class);
    private String sessionId;
    private long createdAt;
    private OpenVidu openVidu;
    private SessionProperties properties;
    private Map<String, Connection> connections = new ConcurrentHashMap<String, Connection>();
    private boolean recording = false;

    protected Session(OpenVidu openVidu) throws OpenViduJavaClientException, OpenViduHttpException {
        this.openVidu = openVidu;
        this.properties = new SessionProperties.Builder().build();
        this.getSessionHttp();
    }

    protected Session(OpenVidu openVidu, SessionProperties properties) throws OpenViduJavaClientException, OpenViduHttpException {
        this.openVidu = openVidu;
        this.properties = properties;
        this.getSessionHttp();
    }

    protected Session(OpenVidu openVidu, JsonObject json) {
        this.openVidu = openVidu;
        this.resetWithJson(json);
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public long createdAt() {
        return this.createdAt;
    }

    @Deprecated
    public String generateToken() throws OpenViduJavaClientException, OpenViduHttpException {
        return this.generateToken(new TokenOptions.Builder().data("").role(OpenViduRole.PUBLISHER).build());
    }

    @Deprecated
    public String generateToken(TokenOptions tokenOptions) throws OpenViduJavaClientException, OpenViduHttpException {
        if (!this.hasSessionId()) {
            this.getSessionId();
        }
        HttpPost request = new HttpPost(this.openVidu.hostname + "openvidu/api/tokens");
        StringEntity params = new StringEntity(tokenOptions.toJsonObject(this.sessionId).toString(), "UTF-8");
        request.setHeader("Content-Type", "application/json");
        request.setEntity((HttpEntity)params);
        HttpResponse response = null;
        try {
            response = this.openVidu.httpClient.execute((HttpUriRequest)request);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                String token = this.httpResponseToJson(response).get("id").getAsString();
                log.info("Returning a TOKEN: {}", (Object)token);
                String string = token;
                return string;
            }
            try {
                throw new OpenViduHttpException(statusCode);
            }
            catch (IOException e) {
                throw new OpenViduJavaClientException(e.getMessage(), e.getCause());
            }
        }
        finally {
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }

    public Connection createConnection() throws OpenViduJavaClientException, OpenViduHttpException {
        return this.createConnection(new ConnectionProperties.Builder().data("").role(OpenViduRole.PUBLISHER).record(true).build());
    }

    public Connection createConnection(ConnectionProperties connectionProperties) throws OpenViduJavaClientException, OpenViduHttpException {
        if (!this.hasSessionId()) {
            this.getSessionId();
        }
        HttpPost request = new HttpPost(this.openVidu.hostname + "openvidu/api/sessions/" + this.sessionId + "/connection");
        StringEntity params = new StringEntity(connectionProperties.toJson(this.sessionId).toString(), "UTF-8");
        request.setHeader("Content-Type", "application/json");
        request.setEntity((HttpEntity)params);
        HttpResponse response = null;
        try {
            response = this.openVidu.httpClient.execute((HttpUriRequest)request);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                Connection connection = new Connection(this.httpResponseToJson(response));
                this.connections.put(connection.getConnectionId(), connection);
                Connection connection2 = connection;
                return connection2;
            }
            try {
                throw new OpenViduHttpException(statusCode);
            }
            catch (IOException e) {
                throw new OpenViduJavaClientException(e.getMessage(), e.getCause());
            }
        }
        finally {
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }

    public void close() throws OpenViduJavaClientException, OpenViduHttpException {
        block7: {
            HttpDelete request = new HttpDelete(this.openVidu.hostname + "openvidu/api/sessions/" + this.sessionId);
            request.setHeader("Content-Type", "application/x-www-form-urlencoded");
            HttpResponse response = null;
            try {
                response = this.openVidu.httpClient.execute((HttpUriRequest)request);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 204) {
                    this.openVidu.activeSessions.remove(this.sessionId);
                    log.info("Session {} closed", (Object)this.sessionId);
                    break block7;
                }
                throw new OpenViduHttpException(statusCode);
            }
            catch (IOException e) {
                throw new OpenViduJavaClientException(e.getMessage(), e.getCause());
            }
            finally {
                if (response != null) {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
        }
    }

    public boolean fetch() throws OpenViduJavaClientException, OpenViduHttpException {
        String beforeJSON = this.toJson();
        HttpGet request = new HttpGet(this.openVidu.hostname + "openvidu/api/sessions/" + this.sessionId + "?pendingConnections=true");
        request.setHeader("Content-Type", "application/x-www-form-urlencoded");
        HttpResponse response = null;
        try {
            response = this.openVidu.httpClient.execute((HttpUriRequest)request);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                this.resetWithJson(this.httpResponseToJson(response));
                String afterJSON = this.toJson();
                boolean hasChanged = !beforeJSON.equals(afterJSON);
                log.info("Session info fetched for session '{}'. Any change: {}", (Object)this.sessionId, (Object)hasChanged);
                boolean bl = hasChanged;
                return bl;
            }
            try {
                throw new OpenViduHttpException(statusCode);
            }
            catch (IOException e) {
                throw new OpenViduJavaClientException(e.getMessage(), e.getCause());
            }
        }
        finally {
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }

    public void forceDisconnect(Connection connection) throws OpenViduJavaClientException, OpenViduHttpException {
        this.forceDisconnect(connection.getConnectionId());
    }

    public void forceDisconnect(String connectionId) throws OpenViduJavaClientException, OpenViduHttpException {
        block11: {
            HttpDelete request = new HttpDelete(this.openVidu.hostname + "openvidu/api/sessions/" + this.sessionId + "/connection/" + connectionId);
            request.setHeader("Content-Type", "application/x-www-form-urlencoded");
            HttpResponse response = null;
            try {
                response = this.openVidu.httpClient.execute((HttpUriRequest)request);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 204) {
                    Connection connectionClosed = this.connections.remove(connectionId);
                    if (connectionClosed != null) {
                        for (Publisher publisher : connectionClosed.getPublishers()) {
                            String streamId = publisher.getStreamId();
                            for (Connection connection : this.connections.values()) {
                                connection.setSubscribers(connection.getSubscribers().stream().filter(subscriber -> !streamId.equals(subscriber)).collect(Collectors.toList()));
                            }
                        }
                    } else {
                        log.warn("The closed connection wasn't fetched in OpenVidu Java Client. No changes in the collection of active connections of the Session");
                    }
                    log.info("Connection {} closed", (Object)connectionId);
                    break block11;
                }
                throw new OpenViduHttpException(statusCode);
            }
            catch (IOException e) {
                throw new OpenViduJavaClientException(e.getMessage(), e.getCause());
            }
            finally {
                if (response != null) {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
        }
    }

    public void forceUnpublish(Publisher publisher) throws OpenViduJavaClientException, OpenViduHttpException {
        this.forceUnpublish(publisher.getStreamId());
    }

    public void forceUnpublish(String streamId) throws OpenViduJavaClientException, OpenViduHttpException {
        block8: {
            HttpDelete request = new HttpDelete(this.openVidu.hostname + "openvidu/api/sessions/" + this.sessionId + "/stream/" + streamId);
            request.setHeader("Content-Type", "application/x-www-form-urlencoded");
            HttpResponse response = null;
            try {
                response = this.openVidu.httpClient.execute((HttpUriRequest)request);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 204) {
                    for (Connection connection : this.connections.values()) {
                        if (connection.publishers.remove(streamId) != null) continue;
                        connection.subscribers.remove(streamId);
                    }
                    log.info("Stream {} unpublished", (Object)streamId);
                    break block8;
                }
                throw new OpenViduHttpException(statusCode);
            }
            catch (IOException e) {
                throw new OpenViduJavaClientException(e.getMessage(), e.getCause());
            }
            finally {
                if (response != null) {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
        }
    }

    public Connection updateConnection(String connectionId, ConnectionProperties connectionProperties) throws OpenViduJavaClientException, OpenViduHttpException {
        HttpPatch request = new HttpPatch(this.openVidu.hostname + "openvidu/api/sessions/" + this.sessionId + "/connection/" + connectionId);
        StringEntity params = new StringEntity(connectionProperties.toJson(this.sessionId).toString(), "UTF-8");
        request.setHeader("Content-Type", "application/json");
        request.setEntity((HttpEntity)params);
        HttpResponse response = null;
        try {
            response = this.openVidu.httpClient.execute((HttpUriRequest)request);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                log.info("Connection {} updated", (Object)connectionId);
            } else if (statusCode == 204) {
                log.info("Properties of Connection {} remain the same", (Object)connectionId);
            } else {
                throw new OpenViduHttpException(statusCode);
            }
            JsonObject json = this.httpResponseToJson(response);
            Connection existingConnection = this.connections.get(connectionId);
            if (existingConnection == null) {
                Connection newConnection = new Connection(json);
                this.connections.put(connectionId, newConnection);
                Connection connection = newConnection;
                return connection;
            }
            existingConnection.overrideConnectionProperties(connectionProperties);
            Connection connection = existingConnection;
            return connection;
        }
        catch (IOException e) {
            throw new OpenViduJavaClientException(e.getMessage(), e.getCause());
        }
        finally {
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }

    public Connection getConnection(String id) {
        return this.connections.get(id);
    }

    public List<Connection> getConnections() {
        return this.connections.values().stream().collect(Collectors.toList());
    }

    public List<Connection> getActiveConnections() {
        return this.connections.values().stream().filter(con -> "active".equals(con.getStatus())).collect(Collectors.toList());
    }

    public boolean isBeingRecorded() {
        return this.recording;
    }

    public SessionProperties getProperties() {
        return this.properties;
    }

    private boolean hasSessionId() {
        return this.sessionId != null && !this.sessionId.isEmpty();
    }

    private void getSessionHttp() throws OpenViduJavaClientException, OpenViduHttpException {
        block9: {
            if (this.hasSessionId()) {
                return;
            }
            HttpPost request = new HttpPost(this.openVidu.hostname + "openvidu/api/sessions");
            StringEntity params = new StringEntity(this.properties.toJson().toString(), "UTF-8");
            request.setHeader("Content-Type", "application/json");
            request.setEntity((HttpEntity)params);
            HttpResponse response = null;
            try {
                response = this.openVidu.httpClient.execute((HttpUriRequest)request);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 200) {
                    SessionProperties responseProperties;
                    JsonObject responseJson = this.httpResponseToJson(response);
                    this.sessionId = responseJson.get("id").getAsString();
                    this.createdAt = responseJson.get("createdAt").getAsLong();
                    VideoCodec forcedVideoCodec = VideoCodec.valueOf(responseJson.get("forcedVideoCodec").getAsString());
                    Boolean allowTranscoding = responseJson.get("allowTranscoding").getAsBoolean();
                    this.properties = responseProperties = new SessionProperties.Builder().mediaMode(this.properties.mediaMode()).recordingMode(this.properties.recordingMode()).defaultRecordingProperties(this.properties.defaultRecordingProperties()).customSessionId(this.properties.customSessionId()).mediaNode(this.properties.mediaNode()).forcedVideoCodec(forcedVideoCodec).allowTranscoding(allowTranscoding).build();
                    log.info("Session '{}' created", (Object)this.sessionId);
                    break block9;
                }
                if (statusCode == 409) {
                    this.sessionId = this.properties.customSessionId();
                    this.fetch();
                    break block9;
                }
                throw new OpenViduHttpException(statusCode);
            }
            catch (IOException e) {
                throw new OpenViduJavaClientException(e.getMessage(), e.getCause());
            }
            finally {
                if (response != null) {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
        }
    }

    private JsonObject httpResponseToJson(HttpResponse response) throws OpenViduJavaClientException {
        JsonObject json;
        try {
            json = (JsonObject)new Gson().fromJson(EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8"), JsonObject.class);
        }
        catch (JsonSyntaxException | IOException e) {
            throw new OpenViduJavaClientException(e.getMessage(), e.getCause());
        }
        return json;
    }

    protected void setIsBeingRecorded(boolean recording) {
        this.recording = recording;
    }

    protected Session resetWithJson(JsonObject json) {
        this.sessionId = json.get("sessionId").getAsString();
        this.createdAt = json.get("createdAt").getAsLong();
        this.recording = json.get("recording").getAsBoolean();
        SessionProperties.Builder builder = new SessionProperties.Builder().mediaMode(MediaMode.valueOf(json.get("mediaMode").getAsString())).recordingMode(RecordingMode.valueOf(json.get("recordingMode").getAsString()));
        if (json.has("defaultRecordingProperties")) {
            String jsonString = json.get("defaultRecordingProperties").getAsJsonObject().toString();
            RecordingProperties.Builder recBuilder = RecordingProperties.fromJson((Map)new Gson().fromJson(jsonString, Map.class), null);
            builder.defaultRecordingProperties(recBuilder.build());
        }
        if (json.has("customSessionId")) {
            builder.customSessionId(json.get("customSessionId").getAsString());
        }
        if (json.has("forcedVideoCodec")) {
            builder.forcedVideoCodec(VideoCodec.valueOf(json.get("forcedVideoCodec").getAsString()));
        }
        if (json.has("allowTranscoding")) {
            builder.allowTranscoding(json.get("allowTranscoding").getAsBoolean());
        }
        this.properties = builder.build();
        JsonArray jsonArrayConnections = json.get("connections").getAsJsonObject().get("content").getAsJsonArray();
        HashSet fetchedConnectionIds = new HashSet();
        jsonArrayConnections.forEach(connectionJsonElement -> {
            JsonObject connectionJson = connectionJsonElement.getAsJsonObject();
            Connection connectionObj = new Connection(connectionJson);
            String id = connectionObj.getConnectionId();
            fetchedConnectionIds.add(id);
            this.connections.computeIfPresent(id, (cId, c) -> {
                c = c.resetWithJson(connectionJson);
                return c;
            });
            this.connections.computeIfAbsent(id, cId -> connectionObj);
        });
        this.connections.entrySet().removeIf(entry -> !fetchedConnectionIds.contains(((Connection)entry.getValue()).getConnectionId()));
        return this;
    }

    protected String toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("sessionId", this.sessionId);
        json.addProperty("createdAt", (Number)this.createdAt);
        json.addProperty("recording", Boolean.valueOf(this.recording));
        JsonObject sessionPropertiesJson = this.properties.toJson();
        for (Map.Entry entry : sessionPropertiesJson.entrySet()) {
            json.add((String)entry.getKey(), ((JsonElement)entry.getValue()).deepCopy());
        }
        JsonObject connections = new JsonObject();
        connections.addProperty("numberOfElements", (Number)this.getConnections().size());
        JsonArray jsonArrayConnections = new JsonArray();
        this.getConnections().forEach(con -> jsonArrayConnections.add((JsonElement)con.toJson()));
        connections.add("content", (JsonElement)jsonArrayConnections);
        json.add("connections", (JsonElement)connections);
        return json.toString();
    }
}

