/*
 * Decompiled with CFR 0.152.
 */
package io.openvidu.java.client;

import com.google.gson.JsonObject;
import io.openvidu.java.client.Recording;
import io.openvidu.java.client.RecordingLayout;
import io.openvidu.java.client.SessionProperties;
import io.openvidu.java.client.utils.FormatChecker;
import java.util.Map;

public class RecordingProperties {
    private String name = "";
    private Boolean hasAudio = DefaultValues.hasAudio;
    private Boolean hasVideo = DefaultValues.hasVideo;
    private Recording.OutputMode outputMode = DefaultValues.outputMode;
    private RecordingLayout recordingLayout;
    private String resolution;
    private Integer frameRate;
    private Long shmSize;
    private String customLayout;
    private Boolean ignoreFailedStreams;
    private String mediaNode;

    protected RecordingProperties(String name, Boolean hasAudio, Boolean hasVideo, Recording.OutputMode outputMode, RecordingLayout layout, String resolution, Integer frameRate, Long shmSize, String customLayout, Boolean ignoreFailedStreams, String mediaNode) {
        this.name = name != null ? name : "";
        this.hasAudio = hasAudio != null ? hasAudio : DefaultValues.hasAudio;
        this.hasVideo = hasVideo != null ? hasVideo : DefaultValues.hasVideo;
        Recording.OutputMode outputMode2 = this.outputMode = outputMode != null ? outputMode : DefaultValues.outputMode;
        if ((Recording.OutputMode.COMPOSED.equals((Object)this.outputMode) || Recording.OutputMode.COMPOSED_QUICK_START.equals((Object)this.outputMode)) && this.hasVideo.booleanValue()) {
            this.recordingLayout = layout != null ? layout : DefaultValues.recordingLayout;
            this.resolution = resolution != null ? resolution : "1280x720";
            this.frameRate = frameRate != null ? frameRate : DefaultValues.frameRate;
            Long l = this.shmSize = shmSize != null ? shmSize : DefaultValues.shmSize;
            if (RecordingLayout.CUSTOM.equals((Object)this.recordingLayout)) {
                this.customLayout = customLayout;
            }
        }
        if (Recording.OutputMode.INDIVIDUAL.equals((Object)this.outputMode)) {
            this.ignoreFailedStreams = ignoreFailedStreams;
        }
        this.mediaNode = mediaNode;
    }

    public String name() {
        return this.name;
    }

    public Boolean hasAudio() {
        return this.hasAudio;
    }

    public Boolean hasVideo() {
        return this.hasVideo;
    }

    public Recording.OutputMode outputMode() {
        return this.outputMode;
    }

    public RecordingLayout recordingLayout() {
        return this.recordingLayout;
    }

    public String resolution() {
        return this.resolution;
    }

    public Integer frameRate() {
        return this.frameRate;
    }

    public Long shmSize() {
        return this.shmSize;
    }

    public String customLayout() {
        return this.customLayout;
    }

    public Boolean ignoreFailedStreams() {
        return this.ignoreFailedStreams;
    }

    public String mediaNode() {
        return this.mediaNode;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("name", this.name != null ? this.name : "");
        json.addProperty("hasAudio", this.hasAudio != null ? this.hasAudio : DefaultValues.hasAudio);
        json.addProperty("hasVideo", this.hasVideo != null ? this.hasVideo : DefaultValues.hasVideo);
        json.addProperty("outputMode", this.outputMode != null ? this.outputMode.name() : DefaultValues.outputMode.name());
        if ((Recording.OutputMode.COMPOSED.equals((Object)this.outputMode) || Recording.OutputMode.COMPOSED_QUICK_START.equals((Object)this.outputMode)) && this.hasVideo.booleanValue()) {
            json.addProperty("recordingLayout", this.recordingLayout != null ? this.recordingLayout.name() : DefaultValues.recordingLayout.name());
            json.addProperty("resolution", this.resolution != null ? this.resolution : "1280x720");
            json.addProperty("frameRate", (Number)(this.frameRate != null ? this.frameRate : DefaultValues.frameRate));
            json.addProperty("shmSize", (Number)(this.shmSize != null ? this.shmSize : DefaultValues.shmSize));
            if (RecordingLayout.CUSTOM.equals((Object)this.recordingLayout)) {
                json.addProperty("customLayout", this.customLayout != null ? this.customLayout : "");
            }
        }
        if (Recording.OutputMode.INDIVIDUAL.equals((Object)this.outputMode)) {
            json.addProperty("ignoreFailedStreams", this.ignoreFailedStreams != null ? this.ignoreFailedStreams : DefaultValues.ignoreFailedStreams);
        }
        if (this.mediaNode != null) {
            json.addProperty("mediaNode", this.mediaNode);
        }
        return json;
    }

    /*
     * Unable to fully structure code
     */
    public static Builder fromJson(Map<String, ?> params, RecordingProperties defaultProps) throws RuntimeException {
        nameFinal = null;
        hasAudioFinal = null;
        hasVideoFinal = null;
        outputModeFinal = null;
        recordingLayoutFinal = null;
        resolutionFinal = null;
        frameRateFinal = null;
        shmSizeFinal = null;
        customLayoutFinal = null;
        ignoreFailedStreamsFinal = null;
        nameDefault = null;
        hasAudioDefault = null;
        hasVideoDefault = null;
        outputModeDefault = null;
        recordingLayoutDefault = null;
        resolutionDefault = null;
        frameRateDefault = null;
        shmSizeDefault = null;
        customLayoutDefault = null;
        ignoreFailedStreamsDefault = null;
        mediaNodeDefault = null;
        if (defaultProps != null) {
            nameDefault = defaultProps.name();
            hasAudioDefault = defaultProps.hasAudio();
            hasVideoDefault = defaultProps.hasVideo();
            outputModeDefault = defaultProps.outputMode();
            recordingLayoutDefault = defaultProps.recordingLayout();
            resolutionDefault = defaultProps.resolution();
            frameRateDefault = defaultProps.frameRate();
            shmSizeDefault = defaultProps.shmSize();
            customLayoutDefault = defaultProps.customLayout();
            ignoreFailedStreamsDefault = defaultProps.ignoreFailedStreams();
            mediaNodeDefault = defaultProps.mediaNode();
        }
        nameDefault = nameDefault != null ? nameDefault : "";
        hasAudioDefault = hasAudioDefault != null ? hasAudioDefault : DefaultValues.hasAudio;
        hasVideoDefault = hasVideoDefault != null ? hasVideoDefault : DefaultValues.hasVideo;
        outputModeDefault = outputModeDefault != null ? outputModeDefault : DefaultValues.outputMode;
        recordingLayoutDefault = recordingLayoutDefault != null ? recordingLayoutDefault : DefaultValues.recordingLayout;
        resolutionDefault = resolutionDefault != null ? resolutionDefault : "1280x720";
        frameRateDefault = frameRateDefault != null ? frameRateDefault : DefaultValues.frameRate;
        shmSizeDefault = shmSizeDefault != null ? shmSizeDefault : DefaultValues.shmSize;
        customLayoutDefault = customLayoutDefault != null ? customLayoutDefault : "";
        ignoreFailedStreamsDefault = ignoreFailedStreamsDefault != null ? ignoreFailedStreamsDefault : DefaultValues.ignoreFailedStreams;
        shmSizeParam = null;
        try {
            session = (String)params.get("session");
            nameParam = (String)params.get("name");
            hasAudioParam = (Boolean)params.get("hasAudio");
            hasVideoParam = (Boolean)params.get("hasVideo");
            outputModeStringParam = (String)params.get("outputMode");
            recordingLayoutStringParam = (String)params.get("recordingLayout");
            resolutionParam = (String)params.get("resolution");
            frameRateParam = (Number)params.get("frameRate");
            if (params.get("shmSize") != null) {
                shmSize = (Number)params.get("shmSize");
                shmSizeParam = shmSize.longValue();
            }
            customLayoutParam = (String)params.get("customLayout");
            ignoreFailedStreamsParam = (Boolean)params.get("ignoreFailedStreams");
        }
        catch (ClassCastException | NumberFormatException e) {
            throw new IllegalArgumentException("Type error in some parameter: " + e.getMessage());
        }
        if (nameParam != null && !nameParam.isEmpty()) {
            if (!FormatChecker.isValidRecordingName(nameParam)) {
                throw new IllegalArgumentException("Parameter 'name' is wrong. Must be an alphanumeric string [a-zA-Z0-9_-~]+");
            }
            nameFinal = nameParam;
        } else {
            nameFinal = nameDefault;
        }
        hasAudioFinal = hasAudioParam != null ? hasAudioParam : hasAudioDefault;
        hasVideoFinal = hasVideoParam != null ? hasVideoParam : hasVideoDefault;
        if (!hasAudioFinal.booleanValue() && !hasVideoFinal.booleanValue()) {
            throw new IllegalStateException("Cannot start a recording with both \"hasAudio\" and \"hasVideo\" set to false");
        }
        if (outputModeStringParam != null) {
            try {
                outputModeFinal = Recording.OutputMode.valueOf(outputModeStringParam);
                if (defaultProps != null && Recording.OutputMode.COMPOSED_QUICK_START.equals((Object)defaultProps.outputMode()) && Recording.OutputMode.COMPOSED.equals((Object)outputModeFinal)) {
                    outputModeFinal = Recording.OutputMode.COMPOSED_QUICK_START;
                }
                if (defaultProps == null || !Recording.OutputMode.COMPOSED.equals((Object)defaultProps.outputMode()) || !Recording.OutputMode.COMPOSED_QUICK_START.equals((Object)outputModeFinal)) ** GOTO lbl84
                outputModeFinal = Recording.OutputMode.COMPOSED;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Type error in parameter 'outputMode'");
            }
        } else {
            outputModeFinal = outputModeDefault;
        }
lbl84:
        // 4 sources

        if (RecordingProperties.IS_COMPOSED(outputModeFinal)) {
            if (recordingLayoutStringParam != null) {
                try {
                    recordingLayoutFinal = RecordingLayout.valueOf(recordingLayoutStringParam);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Type error in parameter 'recordingLayout'");
                }
            } else {
                recordingLayoutFinal = recordingLayoutDefault;
            }
            if (resolutionParam != null) {
                if (!FormatChecker.isAcceptableRecordingResolution(resolutionParam)) {
                    throw new IllegalStateException("Wrong 'resolution' parameter. Acceptable values from 100 to 1999 for both width and height");
                }
                resolutionFinal = resolutionParam;
            } else {
                resolutionFinal = resolutionDefault;
            }
            if (frameRateParam != null) {
                if (!FormatChecker.isAcceptableRecordingFrameRate(frameRateParam.intValue())) {
                    throw new IllegalStateException("Wrong 'frameRate' parameter. Acceptable values are within range [1,120]");
                }
                frameRateFinal = frameRateParam.intValue();
            } else {
                frameRateFinal = frameRateDefault;
            }
            if (shmSizeParam != null) {
                if (!FormatChecker.isAcceptableRecordingShmSize(shmSizeParam)) {
                    throw new IllegalStateException("Wrong 'shmSize' parameter. Must be 134217728 (128 MB) minimum");
                }
                shmSizeFinal = shmSizeParam;
            } else {
                shmSizeFinal = shmSizeDefault;
            }
            if (RecordingLayout.CUSTOM.equals((Object)recordingLayoutFinal)) {
                customLayoutFinal = customLayoutParam != null ? customLayoutParam : customLayoutDefault;
            }
        } else if (Recording.OutputMode.INDIVIDUAL.equals((Object)outputModeFinal)) {
            ignoreFailedStreamsFinal = ignoreFailedStreamsParam != null ? ignoreFailedStreamsParam : ignoreFailedStreamsDefault;
        }
        builder = new Builder();
        builder.name(nameFinal).hasAudio(hasAudioFinal).hasVideo(hasVideoFinal).outputMode(outputModeFinal);
        if (RecordingProperties.IS_COMPOSED(outputModeFinal) && hasVideoFinal.booleanValue()) {
            builder.recordingLayout(recordingLayoutFinal);
            builder.resolution(resolutionFinal);
            builder.frameRate(frameRateFinal);
            builder.shmSize(shmSizeFinal);
            if (RecordingLayout.CUSTOM.equals((Object)recordingLayoutFinal)) {
                builder.customLayout(customLayoutFinal);
            }
        }
        if (Recording.OutputMode.INDIVIDUAL.equals((Object)outputModeFinal)) {
            builder.ignoreFailedStreams(ignoreFailedStreamsFinal);
        }
        if (RecordingProperties.IS_COMPOSED(outputModeFinal)) {
            block40: {
                if (mediaNodeDefault == null) {
                    try {
                        mediaNodeDefault = SessionProperties.getMediaNodeProperty(params);
                    }
                    catch (IllegalArgumentException e) {
                        if (!params.containsKey("mediaNode")) break block40;
                        try {
                            mediaNodeDefault = (String)params.get("mediaNode");
                        }
                        catch (Exception e2) {
                            throw new IllegalArgumentException("Wrong 'mediaNode' parameter. Wrong type");
                        }
                    }
                }
            }
            if (mediaNodeDefault != null && !mediaNodeDefault.isEmpty()) {
                builder.mediaNode = mediaNodeDefault;
            }
        }
        return builder;
    }

    public static final boolean IS_COMPOSED(Recording.OutputMode outputMode) {
        return Recording.OutputMode.COMPOSED.equals((Object)outputMode) || Recording.OutputMode.COMPOSED_QUICK_START.equals((Object)outputMode);
    }

    public static class Builder {
        private String name = "";
        private Boolean hasAudio = DefaultValues.hasAudio;
        private Boolean hasVideo = DefaultValues.hasVideo;
        private Recording.OutputMode outputMode = DefaultValues.outputMode;
        private RecordingLayout recordingLayout = DefaultValues.recordingLayout;
        private String resolution = "1280x720";
        private Integer frameRate = DefaultValues.frameRate;
        private Long shmSize = DefaultValues.shmSize;
        private String customLayout = "";
        private Boolean ignoreFailedStreams = DefaultValues.ignoreFailedStreams;
        private String mediaNode;

        public Builder() {
        }

        public Builder(RecordingProperties props) {
            this.name = props.name();
            this.hasAudio = props.hasAudio();
            this.hasVideo = props.hasVideo();
            this.outputMode = props.outputMode();
            this.recordingLayout = props.recordingLayout();
            this.resolution = props.resolution();
            this.frameRate = props.frameRate();
            this.shmSize = props.shmSize();
            this.customLayout = props.customLayout();
            this.ignoreFailedStreams = props.ignoreFailedStreams();
            this.mediaNode = props.mediaNode();
        }

        public RecordingProperties build() {
            return new RecordingProperties(this.name, this.hasAudio, this.hasVideo, this.outputMode, this.recordingLayout, this.resolution, this.frameRate, this.shmSize, this.customLayout, this.ignoreFailedStreams, this.mediaNode);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder hasAudio(boolean hasAudio) {
            this.hasAudio = hasAudio;
            return this;
        }

        public Builder hasVideo(boolean hasVideo) {
            this.hasVideo = hasVideo;
            return this;
        }

        public Builder outputMode(Recording.OutputMode outputMode) {
            this.outputMode = outputMode;
            return this;
        }

        public Builder recordingLayout(RecordingLayout layout) {
            this.recordingLayout = layout;
            return this;
        }

        public Builder resolution(String resolution) {
            this.resolution = resolution;
            return this;
        }

        public Builder frameRate(int frameRate) {
            this.frameRate = frameRate;
            return this;
        }

        public Builder shmSize(long shmSize) {
            this.shmSize = shmSize;
            return this;
        }

        public Builder customLayout(String path) {
            this.customLayout = path;
            return this;
        }

        public Builder ignoreFailedStreams(boolean ignoreFailedStreams) {
            this.ignoreFailedStreams = ignoreFailedStreams;
            return this;
        }

        public Builder mediaNode(String mediaNodeId) {
            this.mediaNode = mediaNodeId;
            return this;
        }
    }

    public static class DefaultValues {
        public static final String name = "";
        public static final Boolean hasAudio = true;
        public static final Boolean hasVideo = true;
        public static final Recording.OutputMode outputMode = Recording.OutputMode.COMPOSED;
        public static final RecordingLayout recordingLayout = RecordingLayout.BEST_FIT;
        public static final String resolution = "1280x720";
        public static final Integer frameRate = 25;
        public static final Long shmSize = 0x20000000L;
        public static final String customLayout = "";
        public static final Boolean ignoreFailedStreams = false;
    }
}

