/*
 * Decompiled with CFR 0.152.
 */
package io.openvidu.java.client;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.openvidu.java.client.OpenViduHttpException;
import io.openvidu.java.client.OpenViduJavaClientException;
import io.openvidu.java.client.Recording;
import io.openvidu.java.client.RecordingProperties;
import io.openvidu.java.client.Session;
import io.openvidu.java.client.SessionProperties;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenVidu {
    private static final Logger log = LoggerFactory.getLogger(OpenVidu.class);
    private String secret;
    protected String hostname;
    protected HttpClient httpClient;
    protected Map<String, Session> activeSessions = new ConcurrentHashMap<String, Session>();
    protected static final String API_PATH = "openvidu/api";
    protected static final String API_SESSIONS = "openvidu/api/sessions";
    protected static final String API_TOKENS = "openvidu/api/tokens";
    protected static final String API_RECORDINGS = "openvidu/api/recordings";
    protected static final String API_RECORDINGS_START = "openvidu/api/recordings/start";
    protected static final String API_RECORDINGS_STOP = "openvidu/api/recordings/stop";

    public OpenVidu(String hostname, String secret) {
        SSLContext sslContext;
        this.hostname = hostname;
        if (!this.hostname.endsWith("/")) {
            this.hostname = this.hostname + "/";
        }
        this.secret = secret;
        TrustStrategy trustStrategy = new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                return true;
            }
        };
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("OPENVIDUAPP", this.secret);
        provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
        try {
            sslContext = new SSLContextBuilder().loadTrustMaterial(null, trustStrategy).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        RequestConfig.Builder requestBuilder = RequestConfig.custom();
        requestBuilder = requestBuilder.setConnectTimeout(30000);
        requestBuilder = requestBuilder.setConnectionRequestTimeout(30000);
        this.httpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestBuilder.build()).setConnectionTimeToLive(30L, TimeUnit.SECONDS).setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).setSSLContext(sslContext).setDefaultCredentialsProvider((CredentialsProvider)provider).build();
    }

    public Session createSession() throws OpenViduJavaClientException, OpenViduHttpException {
        Session s = new Session(this);
        this.activeSessions.put(s.getSessionId(), s);
        return s;
    }

    public Session createSession(SessionProperties properties) throws OpenViduJavaClientException, OpenViduHttpException {
        Session s = new Session(this, properties);
        this.activeSessions.put(s.getSessionId(), s);
        return s;
    }

    public Recording startRecording(String sessionId, RecordingProperties properties) throws OpenViduJavaClientException, OpenViduHttpException {
        HttpPost request = new HttpPost(this.hostname + API_RECORDINGS_START);
        JsonObject json = properties.toJson();
        json.addProperty("session", sessionId);
        StringEntity params = new StringEntity(json.toString(), "UTF-8");
        request.setHeader("Content-Type", "application/json");
        request.setEntity((HttpEntity)params);
        HttpResponse response = null;
        try {
            response = this.httpClient.execute((HttpUriRequest)request);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                Recording r = new Recording(this.httpResponseToJson(response));
                Session activeSession = this.activeSessions.get(r.getSessionId());
                if (activeSession != null) {
                    activeSession.setIsBeingRecorded(true);
                } else {
                    log.warn("No active session found for sessionId '{}'. This instance of OpenVidu Java Client didn't create this session", (Object)r.getSessionId());
                }
                Recording recording = r;
                return recording;
            }
            try {
                throw new OpenViduHttpException(statusCode);
            }
            catch (IOException e) {
                throw new OpenViduJavaClientException(e.getMessage(), e.getCause());
            }
        }
        finally {
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }

    public Recording startRecording(String sessionId, String name) throws OpenViduJavaClientException, OpenViduHttpException {
        if (name == null) {
            name = "";
        }
        return this.startRecording(sessionId, new RecordingProperties.Builder().name(name).build());
    }

    public Recording startRecording(String sessionId) throws OpenViduJavaClientException, OpenViduHttpException {
        return this.startRecording(sessionId, "");
    }

    public Recording stopRecording(String recordingId) throws OpenViduJavaClientException, OpenViduHttpException {
        HttpPost request = new HttpPost(this.hostname + "openvidu/api/recordings/stop/" + recordingId);
        HttpResponse response = null;
        try {
            response = this.httpClient.execute((HttpUriRequest)request);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                Recording r = new Recording(this.httpResponseToJson(response));
                Session activeSession = this.activeSessions.get(r.getSessionId());
                if (activeSession != null) {
                    activeSession.setIsBeingRecorded(false);
                } else {
                    log.warn("No active session found for sessionId '{}'. This instance of OpenVidu Java Client didn't create this session", (Object)r.getSessionId());
                }
                Recording recording = r;
                return recording;
            }
            try {
                throw new OpenViduHttpException(statusCode);
            }
            catch (IOException e) {
                throw new OpenViduJavaClientException(e.getMessage(), e.getCause());
            }
        }
        finally {
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }

    public Recording getRecording(String recordingId) throws OpenViduJavaClientException, OpenViduHttpException {
        HttpGet request = new HttpGet(this.hostname + "openvidu/api/recordings/" + recordingId);
        HttpResponse response = null;
        try {
            response = this.httpClient.execute((HttpUriRequest)request);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                Recording recording = new Recording(this.httpResponseToJson(response));
                return recording;
            }
            try {
                throw new OpenViduHttpException(statusCode);
            }
            catch (IOException e) {
                throw new OpenViduJavaClientException(e.getMessage(), e.getCause());
            }
        }
        finally {
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }

    public List<Recording> listRecordings() throws OpenViduJavaClientException, OpenViduHttpException {
        HttpGet request = new HttpGet(this.hostname + API_RECORDINGS);
        HttpResponse response = null;
        try {
            response = this.httpClient.execute((HttpUriRequest)request);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                ArrayList<Recording> recordings = new ArrayList<Recording>();
                JsonObject json = this.httpResponseToJson(response);
                JsonArray array = json.get("items").getAsJsonArray();
                array.forEach(item -> recordings.add(new Recording(item.getAsJsonObject())));
                ArrayList<Recording> arrayList = recordings;
                return arrayList;
            }
            try {
                throw new OpenViduHttpException(statusCode);
            }
            catch (IOException e) {
                throw new OpenViduJavaClientException(e.getMessage(), e.getCause());
            }
        }
        finally {
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }

    public void deleteRecording(String recordingId) throws OpenViduJavaClientException, OpenViduHttpException {
        HttpDelete request = new HttpDelete(this.hostname + "openvidu/api/recordings/" + recordingId);
        HttpResponse response = null;
        try {
            response = this.httpClient.execute((HttpUriRequest)request);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 204) {
                throw new OpenViduHttpException(statusCode);
            }
        }
        catch (IOException e) {
            throw new OpenViduJavaClientException(e.getMessage(), e.getCause());
        }
        finally {
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }

    public List<Session> getActiveSessions() {
        return new ArrayList<Session>(this.activeSessions.values());
    }

    public Session getActiveSession(String sessionId) {
        return this.activeSessions.get(sessionId);
    }

    public boolean fetch() throws OpenViduJavaClientException, OpenViduHttpException {
        HttpGet request = new HttpGet(this.hostname + "openvidu/api/sessions?pendingConnections=true");
        HttpResponse response = null;
        try {
            response = this.httpClient.execute((HttpUriRequest)request);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                JsonObject jsonSessions = this.httpResponseToJson(response);
                JsonArray jsonArraySessions = jsonSessions.get("content").getAsJsonArray();
                boolean[] hasChanged = new boolean[]{false};
                HashSet fetchedSessionIds = new HashSet();
                jsonArraySessions.forEach(sessionJsonElement -> {
                    JsonObject sessionJson = sessionJsonElement.getAsJsonObject();
                    Session sessionObj = new Session(this, sessionJson);
                    String id = sessionObj.getSessionId();
                    fetchedSessionIds.add(id);
                    this.activeSessions.computeIfPresent(id, (sId, s) -> {
                        String afterJSON;
                        String beforeJSON = s.toJson();
                        boolean changed = !beforeJSON.equals(afterJSON = (s = s.resetWithJson(sessionJson)).toJson());
                        hasChanged[0] = hasChanged[0] || changed;
                        log.info("Available session '{}' info fetched. Any change: {}", (Object)id, (Object)changed);
                        return s;
                    });
                    this.activeSessions.computeIfAbsent(id, sId -> {
                        log.info("New session '{}' fetched", (Object)id);
                        hasChanged[0] = true;
                        return sessionObj;
                    });
                });
                this.activeSessions.entrySet().removeIf(entry -> {
                    if (fetchedSessionIds.contains(entry.getKey())) {
                        return false;
                    }
                    log.info("Removing closed session {}", entry.getKey());
                    hasChanged[0] = true;
                    return true;
                });
                log.info("Active sessions info fetched: {}", this.activeSessions.keySet());
                boolean bl = hasChanged[0];
                return bl;
            }
            try {
                throw new OpenViduHttpException(statusCode);
            }
            catch (IOException e) {
                throw new OpenViduJavaClientException(e.getMessage(), e.getCause());
            }
        }
        finally {
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }

    private JsonObject httpResponseToJson(HttpResponse response) throws OpenViduJavaClientException {
        try {
            JsonObject json = (JsonObject)new Gson().fromJson(EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8"), JsonObject.class);
            return json;
        }
        catch (JsonSyntaxException | IOException | ParseException e) {
            throw new OpenViduJavaClientException(e.getMessage(), e.getCause());
        }
    }
}

