/*
 * Decompiled with CFR 0.152.
 */
package io.openvidu.java.client;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.openvidu.java.client.Connection;
import io.openvidu.java.client.ConnectionProperties;
import io.openvidu.java.client.MediaMode;
import io.openvidu.java.client.OpenVidu;
import io.openvidu.java.client.OpenViduHttpException;
import io.openvidu.java.client.OpenViduJavaClientException;
import io.openvidu.java.client.OpenViduRole;
import io.openvidu.java.client.Publisher;
import io.openvidu.java.client.Recording;
import io.openvidu.java.client.RecordingLayout;
import io.openvidu.java.client.RecordingMode;
import io.openvidu.java.client.SessionProperties;
import io.openvidu.java.client.TokenOptions;
import io.openvidu.java.client.VideoCodec;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Session {
    private static final Logger log = LoggerFactory.getLogger(Session.class);
    private String sessionId;
    private long createdAt;
    private OpenVidu openVidu;
    private SessionProperties properties;
    private Map<String, Connection> connections = new ConcurrentHashMap<String, Connection>();
    private boolean recording = false;

    protected Session(OpenVidu openVidu) throws OpenViduJavaClientException, OpenViduHttpException {
        this.openVidu = openVidu;
        this.properties = new SessionProperties.Builder().build();
        this.getSessionHttp();
    }

    protected Session(OpenVidu openVidu, SessionProperties properties) throws OpenViduJavaClientException, OpenViduHttpException {
        this.openVidu = openVidu;
        this.properties = properties;
        this.getSessionHttp();
    }

    protected Session(OpenVidu openVidu, JsonObject json) {
        this.openVidu = openVidu;
        this.resetWithJson(json);
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public long createdAt() {
        return this.createdAt;
    }

    @Deprecated
    public String generateToken() throws OpenViduJavaClientException, OpenViduHttpException {
        return this.generateToken(new TokenOptions.Builder().data("").role(OpenViduRole.PUBLISHER).build());
    }

    @Deprecated
    public String generateToken(TokenOptions tokenOptions) throws OpenViduJavaClientException, OpenViduHttpException {
        HttpResponse response;
        StringEntity params;
        if (!this.hasSessionId()) {
            this.getSessionId();
        }
        HttpPost request = new HttpPost(this.openVidu.hostname + "openvidu/api/tokens");
        try {
            params = new StringEntity(tokenOptions.toJsonObject(this.sessionId).toString());
        }
        catch (UnsupportedEncodingException e1) {
            throw new OpenViduJavaClientException(e1.getMessage(), e1.getCause());
        }
        request.setHeader("Content-Type", "application/json");
        request.setEntity((HttpEntity)params);
        try {
            response = this.openVidu.httpClient.execute((HttpUriRequest)request);
        }
        catch (IOException e2) {
            throw new OpenViduJavaClientException(e2.getMessage(), e2.getCause());
        }
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                String token = this.httpResponseToJson(response).get("id").getAsString();
                log.info("Returning a TOKEN: {}", (Object)token);
                String string = token;
                return string;
            }
            throw new OpenViduHttpException(statusCode);
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
    }

    public Connection createConnection() throws OpenViduJavaClientException, OpenViduHttpException {
        return this.createConnection(new ConnectionProperties.Builder().data("").role(OpenViduRole.PUBLISHER).record(true).build());
    }

    public Connection createConnection(ConnectionProperties connectionProperties) throws OpenViduJavaClientException, OpenViduHttpException {
        HttpResponse response;
        StringEntity params;
        if (!this.hasSessionId()) {
            this.getSessionId();
        }
        HttpPost request = new HttpPost(this.openVidu.hostname + "openvidu/api/sessions" + "/" + this.sessionId + "/connection");
        try {
            params = new StringEntity(connectionProperties.toJson(this.sessionId).toString());
        }
        catch (UnsupportedEncodingException e1) {
            throw new OpenViduJavaClientException(e1.getMessage(), e1.getCause());
        }
        request.setHeader("Content-Type", "application/json");
        request.setEntity((HttpEntity)params);
        try {
            response = this.openVidu.httpClient.execute((HttpUriRequest)request);
        }
        catch (IOException e2) {
            throw new OpenViduJavaClientException(e2.getMessage(), e2.getCause());
        }
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                Connection connection = new Connection(this.httpResponseToJson(response));
                this.connections.put(connection.getConnectionId(), connection);
                Connection connection2 = connection;
                return connection2;
            }
            throw new OpenViduHttpException(statusCode);
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws OpenViduJavaClientException, OpenViduHttpException {
        block6: {
            HttpResponse response;
            HttpDelete request = new HttpDelete(this.openVidu.hostname + "openvidu/api/sessions" + "/" + this.sessionId);
            request.setHeader("Content-Type", "application/x-www-form-urlencoded");
            try {
                response = this.openVidu.httpClient.execute((HttpUriRequest)request);
            }
            catch (IOException e) {
                throw new OpenViduJavaClientException(e.getMessage(), e.getCause());
            }
            try {
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 204) {
                    this.openVidu.activeSessions.remove(this.sessionId);
                    log.info("Session {} closed", (Object)this.sessionId);
                    break block6;
                }
                throw new OpenViduHttpException(statusCode);
            }
            finally {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }

    public boolean fetch() throws OpenViduJavaClientException, OpenViduHttpException {
        HttpResponse response;
        String beforeJSON = this.toJson();
        HttpGet request = new HttpGet(this.openVidu.hostname + "openvidu/api/sessions" + "/" + this.sessionId + "?pendingConnections=true");
        request.setHeader("Content-Type", "application/x-www-form-urlencoded");
        try {
            response = this.openVidu.httpClient.execute((HttpUriRequest)request);
        }
        catch (IOException e) {
            throw new OpenViduJavaClientException(e.getMessage(), e.getCause());
        }
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                this.resetWithJson(this.httpResponseToJson(response));
                String afterJSON = this.toJson();
                boolean hasChanged = !beforeJSON.equals(afterJSON);
                log.info("Session info fetched for session '{}'. Any change: {}", (Object)this.sessionId, (Object)hasChanged);
                boolean bl = hasChanged;
                return bl;
            }
            throw new OpenViduHttpException(statusCode);
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
    }

    public void forceDisconnect(Connection connection) throws OpenViduJavaClientException, OpenViduHttpException {
        this.forceDisconnect(connection.getConnectionId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceDisconnect(String connectionId) throws OpenViduJavaClientException, OpenViduHttpException {
        block10: {
            HttpDelete request = new HttpDelete(this.openVidu.hostname + "openvidu/api/sessions" + "/" + this.sessionId + "/connection/" + connectionId);
            request.setHeader("Content-Type", "application/x-www-form-urlencoded");
            HttpResponse response = null;
            try {
                response = this.openVidu.httpClient.execute((HttpUriRequest)request);
            }
            catch (IOException e) {
                throw new OpenViduJavaClientException(e.getMessage(), e.getCause());
            }
            try {
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 204) {
                    Connection connectionClosed = this.connections.remove(connectionId);
                    if (connectionClosed != null) {
                        for (Publisher publisher : connectionClosed.getPublishers()) {
                            String streamId = publisher.getStreamId();
                            for (Connection connection : this.connections.values()) {
                                connection.setSubscribers(connection.getSubscribers().stream().filter(subscriber -> !streamId.equals(subscriber)).collect(Collectors.toList()));
                            }
                        }
                    } else {
                        log.warn("The closed connection wasn't fetched in OpenVidu Java Client. No changes in the collection of active connections of the Session");
                    }
                    log.info("Connection {} closed", (Object)connectionId);
                    break block10;
                }
                throw new OpenViduHttpException(statusCode);
            }
            finally {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }

    public void forceUnpublish(Publisher publisher) throws OpenViduJavaClientException, OpenViduHttpException {
        this.forceUnpublish(publisher.getStreamId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceUnpublish(String streamId) throws OpenViduJavaClientException, OpenViduHttpException {
        block7: {
            HttpResponse response;
            HttpDelete request = new HttpDelete(this.openVidu.hostname + "openvidu/api/sessions" + "/" + this.sessionId + "/stream/" + streamId);
            request.setHeader("Content-Type", "application/x-www-form-urlencoded");
            try {
                response = this.openVidu.httpClient.execute((HttpUriRequest)request);
            }
            catch (IOException e) {
                throw new OpenViduJavaClientException(e.getMessage(), e.getCause());
            }
            try {
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 204) {
                    for (Connection connection : this.connections.values()) {
                        if (connection.publishers.remove(streamId) != null) continue;
                        connection.subscribers.remove(streamId);
                    }
                    log.info("Stream {} unpublished", (Object)streamId);
                    break block7;
                }
                throw new OpenViduHttpException(statusCode);
            }
            finally {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection updateConnection(String connectionId, ConnectionProperties connectionProperties) throws OpenViduJavaClientException, OpenViduHttpException {
        HttpResponse response;
        StringEntity params;
        HttpPatch request = new HttpPatch(this.openVidu.hostname + "openvidu/api/sessions" + "/" + this.sessionId + "/connection/" + connectionId);
        try {
            params = new StringEntity(connectionProperties.toJson(this.sessionId).toString());
        }
        catch (UnsupportedEncodingException e1) {
            throw new OpenViduJavaClientException(e1.getMessage(), e1.getCause());
        }
        request.setHeader("Content-Type", "application/json");
        request.setEntity((HttpEntity)params);
        try {
            response = this.openVidu.httpClient.execute((HttpUriRequest)request);
        }
        catch (IOException e) {
            throw new OpenViduJavaClientException(e.getMessage(), e.getCause());
        }
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                log.info("Connection {} updated", (Object)connectionId);
            } else if (statusCode == 204) {
                log.info("Properties of Connection {} remain the same", (Object)connectionId);
            } else {
                throw new OpenViduHttpException(statusCode);
            }
            JsonObject json = this.httpResponseToJson(response);
            Connection existingConnection = this.connections.get(connectionId);
            if (existingConnection == null) {
                Connection newConnection = new Connection(json);
                this.connections.put(connectionId, newConnection);
                Connection connection = newConnection;
                return connection;
            }
            existingConnection.overrideConnectionProperties(connectionProperties);
            Connection connection = existingConnection;
            return connection;
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
    }

    public Connection getConnection(String id) {
        return this.connections.get(id);
    }

    public List<Connection> getConnections() {
        return this.connections.values().stream().collect(Collectors.toList());
    }

    public List<Connection> getActiveConnections() {
        return this.connections.values().stream().filter(con -> "active".equals(con.getStatus())).collect(Collectors.toList());
    }

    public boolean isBeingRecorded() {
        return this.recording;
    }

    public SessionProperties getProperties() {
        return this.properties;
    }

    private boolean hasSessionId() {
        return this.sessionId != null && !this.sessionId.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSessionHttp() throws OpenViduJavaClientException, OpenViduHttpException {
        block10: {
            HttpResponse response;
            if (this.hasSessionId()) {
                return;
            }
            HttpPost request = new HttpPost(this.openVidu.hostname + "openvidu/api/sessions");
            StringEntity params = null;
            try {
                params = new StringEntity(this.properties.toJson().toString());
            }
            catch (UnsupportedEncodingException e1) {
                throw new OpenViduJavaClientException(e1.getMessage(), e1.getCause());
            }
            request.setHeader("Content-Type", "application/json");
            request.setEntity((HttpEntity)params);
            try {
                response = this.openVidu.httpClient.execute((HttpUriRequest)request);
            }
            catch (IOException e2) {
                throw new OpenViduJavaClientException(e2.getMessage(), e2.getCause());
            }
            try {
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 200) {
                    SessionProperties responseProperties;
                    JsonObject responseJson = this.httpResponseToJson(response);
                    this.sessionId = responseJson.get("id").getAsString();
                    this.createdAt = responseJson.get("createdAt").getAsLong();
                    VideoCodec forcedVideoCodec = VideoCodec.valueOf(responseJson.get("forcedVideoCodec").getAsString());
                    Boolean allowTranscoding = responseJson.get("allowTranscoding").getAsBoolean();
                    this.properties = responseProperties = new SessionProperties.Builder().customSessionId(this.properties.customSessionId()).mediaMode(this.properties.mediaMode()).recordingMode(this.properties.recordingMode()).defaultOutputMode(this.properties.defaultOutputMode()).defaultRecordingLayout(this.properties.defaultRecordingLayout()).defaultCustomLayout(this.properties.defaultCustomLayout()).mediaNode(this.properties.mediaNode()).forcedVideoCodec(forcedVideoCodec).allowTranscoding(allowTranscoding).build();
                    log.info("Session '{}' created", (Object)this.sessionId);
                    break block10;
                }
                if (statusCode == 409) {
                    this.sessionId = this.properties.customSessionId();
                    break block10;
                }
                throw new OpenViduHttpException(statusCode);
            }
            finally {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }

    private JsonObject httpResponseToJson(HttpResponse response) throws OpenViduJavaClientException {
        JsonObject json;
        try {
            json = (JsonObject)new Gson().fromJson(EntityUtils.toString((HttpEntity)response.getEntity()), JsonObject.class);
        }
        catch (JsonSyntaxException | IOException e) {
            throw new OpenViduJavaClientException(e.getMessage(), e.getCause());
        }
        return json;
    }

    protected void setIsBeingRecorded(boolean recording) {
        this.recording = recording;
    }

    protected Session resetWithJson(JsonObject json) {
        this.sessionId = json.get("sessionId").getAsString();
        this.createdAt = json.get("createdAt").getAsLong();
        this.recording = json.get("recording").getAsBoolean();
        SessionProperties.Builder builder = new SessionProperties.Builder().mediaMode(MediaMode.valueOf(json.get("mediaMode").getAsString())).recordingMode(RecordingMode.valueOf(json.get("recordingMode").getAsString())).defaultOutputMode(Recording.OutputMode.valueOf(json.get("defaultOutputMode").getAsString()));
        if (json.has("defaultRecordingLayout")) {
            builder.defaultRecordingLayout(RecordingLayout.valueOf(json.get("defaultRecordingLayout").getAsString()));
        }
        if (json.has("defaultCustomLayout")) {
            builder.defaultCustomLayout(json.get("defaultCustomLayout").getAsString());
        }
        if (json.has("customSessionId")) {
            builder.customSessionId(json.get("customSessionId").getAsString());
        }
        if (json.has("forcedVideoCodec")) {
            builder.forcedVideoCodec(VideoCodec.valueOf(json.get("forcedVideoCodec").getAsString()));
        }
        if (json.has("allowTranscoding")) {
            builder.allowTranscoding(json.get("allowTranscoding").getAsBoolean());
        }
        this.properties = builder.build();
        JsonArray jsonArrayConnections = json.get("connections").getAsJsonObject().get("content").getAsJsonArray();
        HashSet fetchedConnectionIds = new HashSet();
        jsonArrayConnections.forEach(connectionJsonElement -> {
            JsonObject connectionJson = connectionJsonElement.getAsJsonObject();
            Connection connectionObj = new Connection(connectionJson);
            String id = connectionObj.getConnectionId();
            fetchedConnectionIds.add(id);
            this.connections.computeIfPresent(id, (cId, c) -> {
                c = c.resetWithJson(connectionJson);
                return c;
            });
            this.connections.computeIfAbsent(id, cId -> connectionObj);
        });
        this.connections.entrySet().removeIf(entry -> !fetchedConnectionIds.contains(((Connection)entry.getValue()).getConnectionId()));
        return this;
    }

    protected String toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("sessionId", this.sessionId);
        json.addProperty("createdAt", (Number)this.createdAt);
        json.addProperty("customSessionId", this.properties.customSessionId());
        json.addProperty("recording", Boolean.valueOf(this.recording));
        json.addProperty("mediaMode", this.properties.mediaMode().name());
        json.addProperty("recordingMode", this.properties.recordingMode().name());
        json.addProperty("defaultOutputMode", this.properties.defaultOutputMode().name());
        json.addProperty("defaultRecordingLayout", this.properties.defaultRecordingLayout().name());
        json.addProperty("defaultCustomLayout", this.properties.defaultCustomLayout());
        if (this.properties.forcedVideoCodec() != null) {
            json.addProperty("forcedVideoCodec", this.properties.forcedVideoCodec().name());
        }
        if (this.properties.isTranscodingAllowed() != null) {
            json.addProperty("allowTranscoding", this.properties.isTranscodingAllowed());
        }
        JsonObject connections = new JsonObject();
        connections.addProperty("numberOfElements", (Number)this.getConnections().size());
        JsonArray jsonArrayConnections = new JsonArray();
        this.getConnections().forEach(con -> jsonArrayConnections.add((JsonElement)con.toJson()));
        connections.add("content", (JsonElement)jsonArrayConnections);
        json.add("connections", (JsonElement)connections);
        return json.toString();
    }
}

