/*
 * Decompiled with CFR 0.152.
 */
package io.openvidu.java.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import io.openvidu.java.client.ConnectionType;
import io.openvidu.java.client.KurentoOptions;
import io.openvidu.java.client.OpenViduRole;

public class ConnectionProperties {
    private ConnectionType type;
    private String data;
    private Boolean record;
    private OpenViduRole role;
    private KurentoOptions kurentoOptions;
    private String rtspUri;
    private Boolean adaptativeBitrate;
    private Boolean onlyPlayWithSubscribers;
    private Integer networkCache;

    ConnectionProperties(ConnectionType type, String data, Boolean record, OpenViduRole role, KurentoOptions kurentoOptions, String rtspUri, Boolean adaptativeBitrate, Boolean onlyPlayWithSubscribers, Integer networkCache) {
        this.type = type;
        this.data = data;
        this.record = record;
        this.role = role;
        this.kurentoOptions = kurentoOptions;
        this.rtspUri = rtspUri;
        this.adaptativeBitrate = adaptativeBitrate;
        this.onlyPlayWithSubscribers = onlyPlayWithSubscribers;
        this.networkCache = networkCache;
    }

    public ConnectionType getType() {
        return this.type;
    }

    public String getData() {
        return this.data;
    }

    public Boolean record() {
        return this.record;
    }

    public OpenViduRole getRole() {
        return this.role;
    }

    public KurentoOptions getKurentoOptions() {
        return this.kurentoOptions;
    }

    public String getRtspUri() {
        return this.rtspUri;
    }

    public Boolean adaptativeBitrate() {
        return this.adaptativeBitrate;
    }

    public Boolean onlyPlayWithSubscribers() {
        return this.onlyPlayWithSubscribers;
    }

    public Integer getNetworkCache() {
        return this.networkCache;
    }

    public JsonObject toJson(String sessionId) {
        JsonObject json = new JsonObject();
        json.addProperty("session", sessionId);
        if (this.getType() != null) {
            json.addProperty("type", this.getType().name());
        } else {
            json.add("type", (JsonElement)JsonNull.INSTANCE);
        }
        if (this.getData() != null) {
            json.addProperty("data", this.getData());
        } else {
            json.add("data", (JsonElement)JsonNull.INSTANCE);
        }
        if (this.record() != null) {
            json.addProperty("record", this.record());
        } else {
            json.add("record", (JsonElement)JsonNull.INSTANCE);
        }
        if (this.getRole() != null) {
            json.addProperty("role", this.getRole().name());
        } else {
            json.add("role", (JsonElement)JsonNull.INSTANCE);
        }
        if (this.kurentoOptions != null) {
            json.add("kurentoOptions", (JsonElement)this.kurentoOptions.toJson());
        } else {
            json.add("kurentoOptions", (JsonElement)JsonNull.INSTANCE);
        }
        if (this.getRtspUri() != null) {
            json.addProperty("rtspUri", this.getRtspUri());
        } else {
            json.add("rtspUri", (JsonElement)JsonNull.INSTANCE);
        }
        if (this.adaptativeBitrate() != null) {
            json.addProperty("adaptativeBitrate", this.adaptativeBitrate());
        } else {
            json.add("adaptativeBitrate", (JsonElement)JsonNull.INSTANCE);
        }
        if (this.onlyPlayWithSubscribers() != null) {
            json.addProperty("onlyPlayWithSubscribers", this.onlyPlayWithSubscribers());
        } else {
            json.add("onlyPlayWithSubscribers", (JsonElement)JsonNull.INSTANCE);
        }
        if (this.getNetworkCache() != null) {
            json.addProperty("networkCache", (Number)this.getNetworkCache());
        } else {
            json.add("networkCache", (JsonElement)JsonNull.INSTANCE);
        }
        return json;
    }

    public static class Builder {
        private ConnectionType type;
        private String data;
        private Boolean record;
        private OpenViduRole role;
        private KurentoOptions kurentoOptions;
        private String rtspUri;
        private Boolean adaptativeBitrate;
        private Boolean onlyPlayWithSubscribers;
        private Integer networkCache;

        public ConnectionProperties build() {
            return new ConnectionProperties(this.type, this.data, this.record, this.role, this.kurentoOptions, this.rtspUri, this.adaptativeBitrate, this.onlyPlayWithSubscribers, this.networkCache);
        }

        public Builder type(ConnectionType type) {
            this.type = type;
            return this;
        }

        public Builder data(String data) {
            this.data = data;
            return this;
        }

        public Builder record(boolean record) {
            this.record = record;
            return this;
        }

        public Builder role(OpenViduRole role) {
            this.role = role;
            return this;
        }

        public Builder kurentoOptions(KurentoOptions kurentoOptions) {
            this.kurentoOptions = kurentoOptions;
            return this;
        }

        public Builder rtspUri(String rtspUri) {
            this.rtspUri = rtspUri;
            return this;
        }

        public Builder adaptativeBitrate(boolean adaptativeBitrate) {
            this.adaptativeBitrate = adaptativeBitrate;
            return this;
        }

        public Builder onlyPlayWithSubscribers(boolean onlyPlayWithSubscribers) {
            this.onlyPlayWithSubscribers = onlyPlayWithSubscribers;
            return this;
        }

        public Builder networkCache(int networkCache) {
            this.networkCache = networkCache;
            return this;
        }
    }
}

