/*
 * Decompiled with CFR 0.152.
 */
package io.openvidu.java.client;

import io.openvidu.java.client.KurentoOptions;
import io.openvidu.java.client.OpenViduRole;

public class TokenOptions {
    private String data;
    private OpenViduRole role;
    private KurentoOptions kurentoOptions;

    private TokenOptions(String data, OpenViduRole role, KurentoOptions kurentoOptions) {
        this.data = data;
        this.role = role;
        this.kurentoOptions = kurentoOptions;
    }

    public String getData() {
        return this.data;
    }

    public OpenViduRole getRole() {
        return this.role;
    }

    public KurentoOptions getKurentoOptions() {
        return this.kurentoOptions;
    }

    public static class Builder {
        private String data = "";
        private OpenViduRole role = OpenViduRole.PUBLISHER;
        private KurentoOptions kurentoOptions;

        public TokenOptions build() {
            return new TokenOptions(this.data, this.role, this.kurentoOptions);
        }

        public Builder data(String data) {
            this.data = data;
            return this;
        }

        public Builder role(OpenViduRole role) {
            this.role = role;
            return this;
        }

        public Builder kurentoOptions(KurentoOptions kurentoOptions) {
            this.kurentoOptions = kurentoOptions;
            return this;
        }
    }
}

