/*
 * Decompiled with CFR 0.152.
 */
package io.openvidu.java.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import io.openvidu.java.client.Connection;
import io.openvidu.java.client.MediaMode;
import io.openvidu.java.client.OpenVidu;
import io.openvidu.java.client.OpenViduHttpException;
import io.openvidu.java.client.OpenViduJavaClientException;
import io.openvidu.java.client.OpenViduRole;
import io.openvidu.java.client.Publisher;
import io.openvidu.java.client.Recording;
import io.openvidu.java.client.RecordingLayout;
import io.openvidu.java.client.RecordingMode;
import io.openvidu.java.client.SessionProperties;
import io.openvidu.java.client.TokenOptions;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Session {
    private static final Logger log = LoggerFactory.getLogger(Session.class);
    private String sessionId;
    private long createdAt;
    private OpenVidu openVidu;
    private SessionProperties properties;
    private Map<String, Connection> activeConnections = new ConcurrentHashMap<String, Connection>();
    private boolean recording = false;

    protected Session(OpenVidu openVidu) throws OpenViduJavaClientException, OpenViduHttpException {
        this.openVidu = openVidu;
        this.properties = new SessionProperties.Builder().build();
        this.getSessionIdHttp();
    }

    protected Session(OpenVidu openVidu, SessionProperties properties) throws OpenViduJavaClientException, OpenViduHttpException {
        this.openVidu = openVidu;
        this.properties = properties;
        this.getSessionIdHttp();
    }

    protected Session(OpenVidu openVidu, JsonObject json) {
        this.openVidu = openVidu;
        this.resetSessionWithJson(json);
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public long createdAt() {
        return this.createdAt;
    }

    public String generateToken() throws OpenViduJavaClientException, OpenViduHttpException {
        return this.generateToken(new TokenOptions.Builder().role(OpenViduRole.PUBLISHER).build());
    }

    public String generateToken(TokenOptions tokenOptions) throws OpenViduJavaClientException, OpenViduHttpException {
        HttpResponse response;
        StringEntity params;
        if (!this.hasSessionId()) {
            this.getSessionId();
        }
        HttpPost request = new HttpPost(this.openVidu.hostname + "api/tokens");
        JsonObject json = new JsonObject();
        json.addProperty("session", this.sessionId);
        json.addProperty("role", tokenOptions.getRole().name());
        json.addProperty("data", tokenOptions.getData());
        if (tokenOptions.getKurentoOptions() != null) {
            JsonObject kurentoOptions = new JsonObject();
            if (tokenOptions.getKurentoOptions().getVideoMaxRecvBandwidth() != null) {
                kurentoOptions.addProperty("videoMaxRecvBandwidth", (Number)tokenOptions.getKurentoOptions().getVideoMaxRecvBandwidth());
            }
            if (tokenOptions.getKurentoOptions().getVideoMinRecvBandwidth() != null) {
                kurentoOptions.addProperty("videoMinRecvBandwidth", (Number)tokenOptions.getKurentoOptions().getVideoMinRecvBandwidth());
            }
            if (tokenOptions.getKurentoOptions().getVideoMaxSendBandwidth() != null) {
                kurentoOptions.addProperty("videoMaxSendBandwidth", (Number)tokenOptions.getKurentoOptions().getVideoMaxSendBandwidth());
            }
            if (tokenOptions.getKurentoOptions().getVideoMinSendBandwidth() != null) {
                kurentoOptions.addProperty("videoMinSendBandwidth", (Number)tokenOptions.getKurentoOptions().getVideoMinSendBandwidth());
            }
            if (tokenOptions.getKurentoOptions().getAllowedFilters().length > 0) {
                JsonArray allowedFilters = new JsonArray();
                for (String filter : tokenOptions.getKurentoOptions().getAllowedFilters()) {
                    allowedFilters.add(filter);
                }
                kurentoOptions.add("allowedFilters", (JsonElement)allowedFilters);
            }
            json.add("kurentoOptions", (JsonElement)kurentoOptions);
        }
        try {
            params = new StringEntity(json.toString());
        }
        catch (UnsupportedEncodingException e1) {
            throw new OpenViduJavaClientException(e1.getMessage(), e1.getCause());
        }
        request.setHeader("Content-Type", "application/json");
        request.setEntity((HttpEntity)params);
        try {
            response = this.openVidu.httpClient.execute((HttpUriRequest)request);
        }
        catch (IOException e2) {
            throw new OpenViduJavaClientException(e2.getMessage(), e2.getCause());
        }
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                String token = this.httpResponseToJson(response).get("id").getAsString();
                log.info("Returning a TOKEN: {}", (Object)token);
                String string = token;
                return string;
            }
            throw new OpenViduHttpException(statusCode);
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws OpenViduJavaClientException, OpenViduHttpException {
        block6: {
            HttpResponse response;
            HttpDelete request = new HttpDelete(this.openVidu.hostname + "api/sessions" + "/" + this.sessionId);
            request.setHeader("Content-Type", "application/x-www-form-urlencoded");
            try {
                response = this.openVidu.httpClient.execute((HttpUriRequest)request);
            }
            catch (IOException e) {
                throw new OpenViduJavaClientException(e.getMessage(), e.getCause());
            }
            try {
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 204) {
                    this.openVidu.activeSessions.remove(this.sessionId);
                    log.info("Session {} closed", (Object)this.sessionId);
                    break block6;
                }
                throw new OpenViduHttpException(statusCode);
            }
            finally {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }

    public boolean fetch() throws OpenViduJavaClientException, OpenViduHttpException {
        HttpResponse response;
        String beforeJSON = this.toJson();
        HttpGet request = new HttpGet(this.openVidu.hostname + "api/sessions" + "/" + this.sessionId);
        request.setHeader("Content-Type", "application/x-www-form-urlencoded");
        try {
            response = this.openVidu.httpClient.execute((HttpUriRequest)request);
        }
        catch (IOException e) {
            throw new OpenViduJavaClientException(e.getMessage(), e.getCause());
        }
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                this.resetSessionWithJson(this.httpResponseToJson(response));
                String afterJSON = this.toJson();
                boolean hasChanged = !beforeJSON.equals(afterJSON);
                log.info("Session info fetched for session '{}'. Any change: {}", (Object)this.sessionId, (Object)hasChanged);
                boolean bl = hasChanged;
                return bl;
            }
            throw new OpenViduHttpException(statusCode);
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
    }

    public void forceDisconnect(Connection connection) throws OpenViduJavaClientException, OpenViduHttpException {
        this.forceDisconnect(connection.getConnectionId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceDisconnect(String connectionId) throws OpenViduJavaClientException, OpenViduHttpException {
        block10: {
            HttpDelete request = new HttpDelete(this.openVidu.hostname + "api/sessions" + "/" + this.sessionId + "/connection/" + connectionId);
            request.setHeader("Content-Type", "application/x-www-form-urlencoded");
            HttpResponse response = null;
            try {
                response = this.openVidu.httpClient.execute((HttpUriRequest)request);
            }
            catch (IOException e) {
                throw new OpenViduJavaClientException(e.getMessage(), e.getCause());
            }
            try {
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 204) {
                    Connection connectionClosed = this.activeConnections.remove(connectionId);
                    if (connectionClosed != null) {
                        for (Publisher publisher : connectionClosed.getPublishers()) {
                            String streamId = publisher.getStreamId();
                            for (Connection connection : this.activeConnections.values()) {
                                connection.setSubscribers(connection.getSubscribers().stream().filter(subscriber -> !streamId.equals(subscriber)).collect(Collectors.toList()));
                            }
                        }
                    } else {
                        log.warn("The closed connection wasn't fetched in OpenVidu Java Client. No changes in the collection of active connections of the Session");
                    }
                    log.info("Connection {} closed", (Object)connectionId);
                    break block10;
                }
                throw new OpenViduHttpException(statusCode);
            }
            finally {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }

    public void forceUnpublish(Publisher publisher) throws OpenViduJavaClientException, OpenViduHttpException {
        this.forceUnpublish(publisher.getStreamId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceUnpublish(String streamId) throws OpenViduJavaClientException, OpenViduHttpException {
        block7: {
            HttpResponse response;
            HttpDelete request = new HttpDelete(this.openVidu.hostname + "api/sessions" + "/" + this.sessionId + "/stream/" + streamId);
            request.setHeader("Content-Type", "application/x-www-form-urlencoded");
            try {
                response = this.openVidu.httpClient.execute((HttpUriRequest)request);
            }
            catch (IOException e) {
                throw new OpenViduJavaClientException(e.getMessage(), e.getCause());
            }
            try {
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 204) {
                    for (Connection connection : this.activeConnections.values()) {
                        if (connection.publishers.remove(streamId) != null) continue;
                        connection.subscribers.remove(streamId);
                    }
                    log.info("Stream {} unpublished", (Object)streamId);
                    break block7;
                }
                throw new OpenViduHttpException(statusCode);
            }
            finally {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }

    public List<Connection> getActiveConnections() {
        return new ArrayList<Connection>(this.activeConnections.values());
    }

    public boolean isBeingRecorded() {
        return this.recording;
    }

    public SessionProperties getProperties() {
        return this.properties;
    }

    public String toString() {
        return this.sessionId;
    }

    private boolean hasSessionId() {
        return this.sessionId != null && !this.sessionId.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSessionIdHttp() throws OpenViduJavaClientException, OpenViduHttpException {
        block10: {
            HttpResponse response;
            if (this.hasSessionId()) {
                return;
            }
            HttpPost request = new HttpPost(this.openVidu.hostname + "api/sessions");
            JsonObject json = new JsonObject();
            json.addProperty("mediaMode", this.properties.mediaMode().name());
            json.addProperty("recordingMode", this.properties.recordingMode().name());
            json.addProperty("defaultOutputMode", this.properties.defaultOutputMode().name());
            json.addProperty("defaultRecordingLayout", this.properties.defaultRecordingLayout().name());
            json.addProperty("defaultCustomLayout", this.properties.defaultCustomLayout());
            json.addProperty("customSessionId", this.properties.customSessionId());
            StringEntity params = null;
            try {
                params = new StringEntity(json.toString());
            }
            catch (UnsupportedEncodingException e1) {
                throw new OpenViduJavaClientException(e1.getMessage(), e1.getCause());
            }
            request.setHeader("Content-Type", "application/json");
            request.setEntity((HttpEntity)params);
            try {
                response = this.openVidu.httpClient.execute((HttpUriRequest)request);
            }
            catch (IOException e2) {
                throw new OpenViduJavaClientException(e2.getMessage(), e2.getCause());
            }
            try {
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 200) {
                    JsonObject responseJson = this.httpResponseToJson(response);
                    this.sessionId = responseJson.get("id").getAsString();
                    this.createdAt = responseJson.get("createdAt").getAsLong();
                    log.info("Session '{}' created", (Object)this.sessionId);
                    break block10;
                }
                if (statusCode == 409) {
                    this.sessionId = this.properties.customSessionId();
                    break block10;
                }
                throw new OpenViduHttpException(statusCode);
            }
            finally {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }

    private JsonObject httpResponseToJson(HttpResponse response) throws OpenViduJavaClientException {
        JsonObject json;
        try {
            json = JsonParser.parseString((String)EntityUtils.toString((HttpEntity)response.getEntity())).getAsJsonObject();
        }
        catch (JsonSyntaxException | IOException | ParseException e) {
            throw new OpenViduJavaClientException(e.getMessage(), e.getCause());
        }
        return json;
    }

    protected void setIsBeingRecorded(boolean recording) {
        this.recording = recording;
    }

    protected Session resetSessionWithJson(JsonObject json) {
        this.sessionId = json.get("sessionId").getAsString();
        this.createdAt = json.get("createdAt").getAsLong();
        this.recording = json.get("recording").getAsBoolean();
        SessionProperties.Builder builder = new SessionProperties.Builder().mediaMode(MediaMode.valueOf(json.get("mediaMode").getAsString())).recordingMode(RecordingMode.valueOf(json.get("recordingMode").getAsString())).defaultOutputMode(Recording.OutputMode.valueOf(json.get("defaultOutputMode").getAsString()));
        if (json.has("defaultRecordingLayout")) {
            builder.defaultRecordingLayout(RecordingLayout.valueOf(json.get("defaultRecordingLayout").getAsString()));
        }
        if (json.has("defaultCustomLayout")) {
            builder.defaultCustomLayout(json.get("defaultCustomLayout").getAsString());
        }
        if (this.properties != null && this.properties.customSessionId() != null) {
            builder.customSessionId(this.properties.customSessionId());
        } else if (json.has("customSessionId")) {
            builder.customSessionId(json.get("customSessionId").getAsString());
        }
        this.properties = builder.build();
        JsonArray jsonArrayConnections = json.get("connections").getAsJsonObject().get("content").getAsJsonArray();
        this.activeConnections.clear();
        jsonArrayConnections.forEach(connection -> {
            JsonObject con = connection.getAsJsonObject();
            ConcurrentHashMap<String, Publisher> publishers = new ConcurrentHashMap<String, Publisher>();
            JsonArray jsonArrayPublishers = con.get("publishers").getAsJsonArray();
            jsonArrayPublishers.forEach(publisher -> {
                JsonObject pubJson = publisher.getAsJsonObject();
                JsonObject mediaOptions = pubJson.get("mediaOptions").getAsJsonObject();
                Publisher pub = new Publisher(pubJson.get("streamId").getAsString(), pubJson.get("createdAt").getAsLong(), mediaOptions.get("hasAudio").getAsBoolean(), mediaOptions.get("hasVideo").getAsBoolean(), mediaOptions.get("audioActive"), mediaOptions.get("videoActive"), mediaOptions.get("frameRate"), mediaOptions.get("typeOfVideo"), mediaOptions.get("videoDimensions"));
                publishers.put(pub.getStreamId(), pub);
            });
            ArrayList<String> subscribers = new ArrayList<String>();
            JsonArray jsonArraySubscribers = con.get("subscribers").getAsJsonArray();
            jsonArraySubscribers.forEach(subscriber -> subscribers.add(subscriber.getAsJsonObject().get("streamId").getAsString()));
            this.activeConnections.put(con.get("connectionId").getAsString(), new Connection(con.get("connectionId").getAsString(), con.get("createdAt").getAsLong(), OpenViduRole.valueOf(con.get("role").getAsString()), con.get("token").getAsString(), con.get("location").getAsString(), con.get("platform").getAsString(), con.get("serverData").getAsString(), con.get("clientData").getAsString(), publishers, subscribers));
        });
        return this;
    }

    protected String toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("sessionId", this.sessionId);
        json.addProperty("createdAt", (Number)this.createdAt);
        json.addProperty("customSessionId", this.properties.customSessionId());
        json.addProperty("recording", Boolean.valueOf(this.recording));
        json.addProperty("mediaMode", this.properties.mediaMode().name());
        json.addProperty("recordingMode", this.properties.recordingMode().name());
        json.addProperty("defaultOutputMode", this.properties.defaultOutputMode().name());
        json.addProperty("defaultRecordingLayout", this.properties.defaultRecordingLayout().name());
        json.addProperty("defaultCustomLayout", this.properties.defaultCustomLayout());
        JsonObject connections = new JsonObject();
        connections.addProperty("numberOfElements", (Number)this.getActiveConnections().size());
        JsonArray jsonArrayConnections = new JsonArray();
        this.getActiveConnections().forEach(con -> {
            JsonObject c = new JsonObject();
            c.addProperty("connectionId", con.getConnectionId());
            c.addProperty("role", con.getRole().name());
            c.addProperty("token", con.getToken());
            c.addProperty("clientData", con.getClientData());
            c.addProperty("serverData", con.getServerData());
            JsonArray pubs = new JsonArray();
            con.getPublishers().forEach(p -> pubs.add((JsonElement)p.toJson()));
            JsonArray subs = new JsonArray();
            con.getSubscribers().forEach(s -> subs.add(s));
            c.add("publishers", (JsonElement)pubs);
            c.add("subscribers", (JsonElement)subs);
            jsonArrayConnections.add((JsonElement)c);
        });
        connections.add("content", (JsonElement)jsonArrayConnections);
        json.add("connections", (JsonElement)connections);
        return json.toString();
    }
}

