/*
 * Decompiled with CFR 0.152.
 */
package io.openvidu.java.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.openvidu.java.client.RecordingLayout;
import io.openvidu.java.client.RecordingProperties;

public class Recording {
    private Status status;
    private String id;
    private String sessionId;
    private long createdAt;
    private long size;
    private double duration;
    private String url;
    private RecordingProperties recordingProperties;

    protected Recording(JsonObject json) {
        this.id = json.get("id").getAsString();
        this.sessionId = json.get("sessionId").getAsString();
        this.createdAt = json.get("createdAt").getAsLong();
        this.size = json.get("size").getAsLong();
        this.duration = json.get("duration").getAsDouble();
        JsonElement urlElement = json.get("url");
        if (!urlElement.isJsonNull()) {
            this.url = urlElement.getAsString();
        }
        this.status = Status.valueOf(json.get("status").getAsString());
        boolean hasAudio = json.get("hasAudio").getAsBoolean();
        boolean hasVideo = json.get("hasVideo").getAsBoolean();
        OutputMode outputMode = OutputMode.valueOf(json.get("outputMode").getAsString());
        RecordingProperties.Builder builder = new RecordingProperties.Builder().name(json.get("name").getAsString()).outputMode(outputMode).hasAudio(hasAudio).hasVideo(hasVideo);
        if (OutputMode.COMPOSED.equals((Object)outputMode) && hasVideo) {
            builder.resolution(json.get("resolution").getAsString());
            builder.recordingLayout(RecordingLayout.valueOf(json.get("recordingLayout").getAsString()));
            JsonElement customLayout = json.get("customLayout");
            if (customLayout != null) {
                builder.customLayout(customLayout.getAsString());
            }
        }
        this.recordingProperties = builder.build();
    }

    public Status getStatus() {
        return this.status;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.recordingProperties.name();
    }

    public OutputMode getOutputMode() {
        return this.recordingProperties.outputMode();
    }

    public RecordingLayout getRecordingLayout() {
        return this.recordingProperties.recordingLayout();
    }

    public String getCustomLayout() {
        return this.recordingProperties.customLayout();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public long getSize() {
        return this.size;
    }

    public double getDuration() {
        return this.duration;
    }

    public String getUrl() {
        return this.url;
    }

    public String getResolution() {
        return this.recordingProperties.resolution();
    }

    public boolean hasAudio() {
        return this.recordingProperties.hasAudio();
    }

    public boolean hasVideo() {
        return this.recordingProperties.hasVideo();
    }

    public static enum OutputMode {
        COMPOSED,
        INDIVIDUAL;

    }

    public static enum Status {
        starting,
        started,
        stopped,
        ready,
        failed;

    }
}

