/*
 * Decompiled with CFR 0.152.
 */
package io.openvidu.java.client;

import io.openvidu.java.client.MediaMode;
import io.openvidu.java.client.Recording;
import io.openvidu.java.client.RecordingLayout;
import io.openvidu.java.client.RecordingMode;

public class SessionProperties {
    private MediaMode mediaMode;
    private RecordingMode recordingMode;
    private Recording.OutputMode defaultOutputMode;
    private RecordingLayout defaultRecordingLayout;
    private String defaultCustomLayout;
    private String customSessionId;

    protected SessionProperties() {
        this.mediaMode = MediaMode.ROUTED;
        this.recordingMode = RecordingMode.MANUAL;
        this.defaultOutputMode = Recording.OutputMode.COMPOSED;
        this.defaultRecordingLayout = RecordingLayout.BEST_FIT;
        this.defaultCustomLayout = "";
        this.customSessionId = "";
    }

    private SessionProperties(MediaMode mediaMode, RecordingMode recordingMode, Recording.OutputMode outputMode, RecordingLayout layout, String defaultCustomLayout, String customSessionId) {
        this.mediaMode = mediaMode;
        this.recordingMode = recordingMode;
        this.defaultOutputMode = outputMode;
        this.defaultRecordingLayout = layout;
        this.defaultCustomLayout = defaultCustomLayout;
        this.customSessionId = customSessionId;
    }

    public MediaMode mediaMode() {
        return this.mediaMode;
    }

    public RecordingMode recordingMode() {
        return this.recordingMode;
    }

    public Recording.OutputMode defaultOutputMode() {
        return this.defaultOutputMode;
    }

    public RecordingLayout defaultRecordingLayout() {
        return this.defaultRecordingLayout;
    }

    public String defaultCustomLayout() {
        return this.defaultCustomLayout;
    }

    public String customSessionId() {
        return this.customSessionId;
    }

    public static class Builder {
        private MediaMode mediaMode = MediaMode.ROUTED;
        private RecordingMode recordingMode = RecordingMode.MANUAL;
        private Recording.OutputMode defaultOutputMode = Recording.OutputMode.COMPOSED;
        private RecordingLayout defaultRecordingLayout = RecordingLayout.BEST_FIT;
        private String defaultCustomLayout = "";
        private String customSessionId = "";

        public SessionProperties build() {
            return new SessionProperties(this.mediaMode, this.recordingMode, this.defaultOutputMode, this.defaultRecordingLayout, this.defaultCustomLayout, this.customSessionId);
        }

        public Builder mediaMode(MediaMode mediaMode) {
            this.mediaMode = mediaMode;
            return this;
        }

        public Builder recordingMode(RecordingMode recordingMode) {
            this.recordingMode = recordingMode;
            return this;
        }

        public Builder defaultOutputMode(Recording.OutputMode outputMode) {
            this.defaultOutputMode = outputMode;
            return this;
        }

        public Builder defaultRecordingLayout(RecordingLayout layout) {
            this.defaultRecordingLayout = layout;
            return this;
        }

        public Builder defaultCustomLayout(String path) {
            this.defaultCustomLayout = path;
            return this;
        }

        public Builder customSessionId(String customSessionId) {
            this.customSessionId = customSessionId;
            return this;
        }
    }
}

