/*
 * Decompiled with CFR 0.152.
 */
package io.openvidu.java.client;

import io.openvidu.java.client.OpenViduHttpException;
import io.openvidu.java.client.OpenViduJavaClientException;
import io.openvidu.java.client.OpenViduRole;
import io.openvidu.java.client.SessionProperties;
import io.openvidu.java.client.TokenOptions;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class Session {
    private HttpClient httpClient;
    private String urlOpenViduServer;
    private String sessionId;
    private SessionProperties properties;
    static final String API_SESSIONS = "api/sessions";
    static final String API_TOKENS = "api/tokens";

    protected Session(HttpClient httpClient, String urlOpenViduServer) throws OpenViduJavaClientException, OpenViduHttpException {
        this.httpClient = httpClient;
        this.urlOpenViduServer = urlOpenViduServer;
        this.properties = new SessionProperties();
        this.getSessionIdHttp();
    }

    protected Session(HttpClient httpClient, String urlOpenViduServer, SessionProperties properties) throws OpenViduJavaClientException, OpenViduHttpException {
        this.httpClient = httpClient;
        this.urlOpenViduServer = urlOpenViduServer;
        this.properties = properties;
        this.getSessionIdHttp();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String generateToken() throws OpenViduJavaClientException, OpenViduHttpException {
        return this.generateToken(new TokenOptions.Builder().role(OpenViduRole.PUBLISHER).build());
    }

    public String generateToken(TokenOptions tokenOptions) throws OpenViduJavaClientException, OpenViduHttpException {
        HttpResponse response;
        StringEntity params;
        if (!this.hasSessionId()) {
            this.getSessionId();
        }
        HttpPost request = new HttpPost(this.urlOpenViduServer + API_TOKENS);
        JSONObject json = new JSONObject();
        json.put((Object)"session", (Object)this.sessionId);
        json.put((Object)"role", (Object)tokenOptions.getRole().name());
        json.put((Object)"data", (Object)tokenOptions.getData());
        try {
            params = new StringEntity(json.toString());
        }
        catch (UnsupportedEncodingException e1) {
            throw new OpenViduJavaClientException(e1.getMessage(), e1.getCause());
        }
        request.setHeader("Content-Type", "application/json");
        request.setEntity((HttpEntity)params);
        try {
            response = this.httpClient.execute((HttpUriRequest)request);
        }
        catch (IOException e2) {
            throw new OpenViduJavaClientException(e2.getMessage(), e2.getCause());
        }
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 200) {
            System.out.println("Returning a TOKEN");
            return (String)this.httpResponseToJson(response).get((Object)"id");
        }
        throw new OpenViduHttpException(statusCode);
    }

    public SessionProperties getProperties() {
        return this.properties;
    }

    public String toString() {
        return this.sessionId;
    }

    private boolean hasSessionId() {
        return this.sessionId != null && !this.sessionId.isEmpty();
    }

    private void getSessionIdHttp() throws OpenViduJavaClientException, OpenViduHttpException {
        HttpResponse response;
        if (this.hasSessionId()) {
            return;
        }
        HttpPost request = new HttpPost(this.urlOpenViduServer + API_SESSIONS);
        JSONObject json = new JSONObject();
        json.put((Object)"mediaMode", (Object)this.properties.mediaMode().name());
        json.put((Object)"recordingMode", (Object)this.properties.recordingMode().name());
        json.put((Object)"defaultRecordingLayout", (Object)this.properties.defaultRecordingLayout().name());
        json.put((Object)"defaultCustomLayout", (Object)this.properties.defaultCustomLayout());
        json.put((Object)"customSessionId", (Object)this.properties.customSessionId());
        StringEntity params = null;
        try {
            params = new StringEntity(json.toString());
        }
        catch (UnsupportedEncodingException e1) {
            throw new OpenViduJavaClientException(e1.getMessage(), e1.getCause());
        }
        request.setHeader("Content-Type", "application/json");
        request.setEntity((HttpEntity)params);
        try {
            response = this.httpClient.execute((HttpUriRequest)request);
        }
        catch (IOException e2) {
            throw new OpenViduJavaClientException(e2.getMessage(), e2.getCause());
        }
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 200) {
            String id;
            System.out.println("Returning a SESSIONID");
            this.sessionId = id = (String)this.httpResponseToJson(response).get((Object)"id");
        } else if (statusCode == 409) {
            this.sessionId = this.properties.customSessionId();
        } else {
            throw new OpenViduHttpException(statusCode);
        }
    }

    private JSONObject httpResponseToJson(HttpResponse response) throws OpenViduJavaClientException {
        JSONObject json;
        JSONParser parser = new JSONParser();
        try {
            json = (JSONObject)parser.parse(EntityUtils.toString((HttpEntity)response.getEntity()));
        }
        catch (IOException | ParseException | org.json.simple.parser.ParseException e) {
            throw new OpenViduJavaClientException(e.getMessage(), e.getCause());
        }
        return json;
    }
}

