/*
 * Decompiled with CFR 0.152.
 */
package io.openvidu.java.client;

import io.openvidu.java.client.OpenViduHttpException;
import io.openvidu.java.client.OpenViduJavaClientException;
import io.openvidu.java.client.Recording;
import io.openvidu.java.client.RecordingProperties;
import io.openvidu.java.client.Session;
import io.openvidu.java.client.SessionProperties;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class OpenVidu {
    private String urlOpenViduServer;
    private String secret;
    private HttpClient myHttpClient;
    static final String API_RECORDINGS = "api/recordings";
    static final String API_RECORDINGS_START = "/start";
    static final String API_RECORDINGS_STOP = "/stop";

    public OpenVidu(String urlOpenViduServer, String secret) {
        SSLContext sslContext;
        this.urlOpenViduServer = urlOpenViduServer;
        if (!this.urlOpenViduServer.endsWith("/")) {
            this.urlOpenViduServer = this.urlOpenViduServer + "/";
        }
        this.secret = secret;
        TrustStrategy trustStrategy = new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                return true;
            }
        };
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("OPENVIDUAPP", this.secret);
        provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
        try {
            sslContext = new SSLContextBuilder().loadTrustMaterial(null, trustStrategy).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        this.myHttpClient = HttpClients.custom().setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).setSSLContext(sslContext).setDefaultCredentialsProvider((CredentialsProvider)provider).build();
    }

    public Session createSession() throws OpenViduJavaClientException, OpenViduHttpException {
        Session s = new Session(this.myHttpClient, this.urlOpenViduServer);
        return s;
    }

    public Session createSession(SessionProperties properties) throws OpenViduJavaClientException, OpenViduHttpException {
        Session s = new Session(this.myHttpClient, this.urlOpenViduServer, properties);
        return s;
    }

    public Recording startRecording(String sessionId, RecordingProperties properties) throws OpenViduJavaClientException, OpenViduHttpException {
        HttpResponse response;
        HttpPost request = new HttpPost(this.urlOpenViduServer + API_RECORDINGS + API_RECORDINGS_START);
        JSONObject json = new JSONObject();
        json.put((Object)"session", (Object)sessionId);
        json.put((Object)"name", (Object)properties.name());
        json.put((Object)"recordingLayout", (Object)(properties.recordingLayout() != null ? properties.recordingLayout().name() : ""));
        json.put((Object)"customLayout", (Object)(properties.customLayout() != null ? properties.customLayout() : ""));
        StringEntity params = null;
        try {
            params = new StringEntity(json.toString());
        }
        catch (UnsupportedEncodingException e1) {
            throw new OpenViduJavaClientException(e1.getMessage(), e1.getCause());
        }
        request.setHeader("Content-Type", "application/json");
        request.setEntity((HttpEntity)params);
        try {
            response = this.myHttpClient.execute((HttpUriRequest)request);
        }
        catch (IOException e2) {
            throw new OpenViduJavaClientException(e2.getMessage(), e2.getCause());
        }
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 200) {
            return new Recording(this.httpResponseToJson(response));
        }
        throw new OpenViduHttpException(statusCode);
    }

    public Recording startRecording(String sessionId, String name) throws OpenViduJavaClientException, OpenViduHttpException {
        if (name == null) {
            name = "";
        }
        return this.startRecording(sessionId, new RecordingProperties.Builder().name(name).build());
    }

    public Recording startRecording(String sessionId) throws OpenViduJavaClientException, OpenViduHttpException {
        return this.startRecording(sessionId, "");
    }

    public Recording stopRecording(String recordingId) throws OpenViduJavaClientException, OpenViduHttpException {
        HttpResponse response;
        HttpPost request = new HttpPost(this.urlOpenViduServer + API_RECORDINGS + API_RECORDINGS_STOP + "/" + recordingId);
        try {
            response = this.myHttpClient.execute((HttpUriRequest)request);
        }
        catch (IOException e) {
            throw new OpenViduJavaClientException(e.getMessage(), e.getCause());
        }
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 200) {
            return new Recording(this.httpResponseToJson(response));
        }
        throw new OpenViduHttpException(statusCode);
    }

    public Recording getRecording(String recordingId) throws OpenViduJavaClientException, OpenViduHttpException {
        HttpResponse response;
        HttpGet request = new HttpGet(this.urlOpenViduServer + API_RECORDINGS + "/" + recordingId);
        try {
            response = this.myHttpClient.execute((HttpUriRequest)request);
        }
        catch (IOException e) {
            throw new OpenViduJavaClientException(e.getMessage(), e.getCause());
        }
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 200) {
            return new Recording(this.httpResponseToJson(response));
        }
        throw new OpenViduHttpException(statusCode);
    }

    public List<Recording> listRecordings() throws OpenViduJavaClientException, OpenViduHttpException {
        HttpResponse response;
        HttpGet request = new HttpGet(this.urlOpenViduServer + API_RECORDINGS);
        try {
            response = this.myHttpClient.execute((HttpUriRequest)request);
        }
        catch (IOException e) {
            throw new OpenViduJavaClientException(e.getMessage(), e.getCause());
        }
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 200) {
            ArrayList<Recording> recordings = new ArrayList<Recording>();
            JSONObject json = this.httpResponseToJson(response);
            JSONArray array = (JSONArray)json.get((Object)"items");
            array.forEach(item -> recordings.add(new Recording((JSONObject)item)));
            return recordings;
        }
        throw new OpenViduHttpException(statusCode);
    }

    public void deleteRecording(String recordingId) throws OpenViduJavaClientException, OpenViduHttpException {
        HttpResponse response;
        HttpDelete request = new HttpDelete(this.urlOpenViduServer + API_RECORDINGS + "/" + recordingId);
        try {
            response = this.myHttpClient.execute((HttpUriRequest)request);
        }
        catch (IOException e) {
            throw new OpenViduJavaClientException(e.getMessage(), e.getCause());
        }
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 204) {
            throw new OpenViduHttpException(statusCode);
        }
    }

    private JSONObject httpResponseToJson(HttpResponse response) throws OpenViduJavaClientException {
        JSONObject json;
        JSONParser parser = new JSONParser();
        try {
            json = (JSONObject)parser.parse(EntityUtils.toString((HttpEntity)response.getEntity()));
        }
        catch (IOException | ParseException | org.json.simple.parser.ParseException e) {
            throw new OpenViduJavaClientException(e.getMessage(), e.getCause());
        }
        return json;
    }
}

