/*
 * Decompiled with CFR 0.152.
 */
package io.openvidu.java.client;

import io.openvidu.java.client.OpenVidu;
import io.openvidu.java.client.OpenViduException;
import io.openvidu.java.client.OpenViduRole;
import io.openvidu.java.client.SessionProperties;
import io.openvidu.java.client.TokenOptions;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.json.simple.JSONObject;

public class Session {
    private HttpClient httpClient;
    private String urlOpenViduServer;
    private String sessionId;
    private SessionProperties properties;
    static final String API_SESSIONS = "api/sessions";
    static final String API_TOKENS = "api/tokens";

    protected Session(HttpClient httpClient, String urlOpenViduServer) throws OpenViduException {
        this.httpClient = httpClient;
        this.urlOpenViduServer = urlOpenViduServer;
        this.properties = new SessionProperties();
        this.sessionId = this.getSessionId();
    }

    protected Session(HttpClient httpClient, String urlOpenViduServer, SessionProperties properties) {
        this.httpClient = httpClient;
        this.urlOpenViduServer = urlOpenViduServer;
        this.properties = properties;
        this.sessionId = this.getSessionId();
    }

    public String getSessionId() throws OpenViduException {
        if (this.hasSessionId()) {
            return this.sessionId;
        }
        try {
            HttpPost request = new HttpPost(this.urlOpenViduServer + API_SESSIONS);
            JSONObject json = new JSONObject();
            json.put((Object)"archiveLayout", (Object)this.properties.archiveLayout().name());
            json.put((Object)"archiveMode", (Object)this.properties.archiveMode().name());
            json.put((Object)"mediaMode", (Object)this.properties.mediaMode().name());
            StringEntity params = new StringEntity(json.toString());
            request.setHeader("Content-Type", "application/json");
            request.setEntity((HttpEntity)params);
            HttpResponse response = this.httpClient.execute((HttpUriRequest)request);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                System.out.println("Returning a SESSIONID");
                String id = "";
                this.sessionId = id = (String)OpenVidu.httpResponseToJson(response).get((Object)"id");
                return id;
            }
            throw new OpenViduException(OpenViduException.Code.SESSIONID_CANNOT_BE_CREATED_ERROR_CODE, Integer.toString(statusCode));
        }
        catch (Exception e) {
            throw new OpenViduException(OpenViduException.Code.SESSIONID_CANNOT_BE_CREATED_ERROR_CODE, "Unable to generate a sessionId: " + e.getMessage());
        }
    }

    public String generateToken() throws OpenViduException {
        return this.generateToken(new TokenOptions.Builder().role(OpenViduRole.PUBLISHER).build());
    }

    public String generateToken(TokenOptions tokenOptions) throws OpenViduException {
        if (!this.hasSessionId()) {
            this.getSessionId();
        }
        try {
            HttpPost request = new HttpPost(this.urlOpenViduServer + API_TOKENS);
            JSONObject json = new JSONObject();
            json.put((Object)"session", (Object)this.sessionId);
            json.put((Object)"role", (Object)tokenOptions.getRole().name());
            json.put((Object)"data", (Object)tokenOptions.getData());
            StringEntity params = new StringEntity(json.toString());
            request.setHeader("Content-Type", "application/json");
            request.setEntity((HttpEntity)params);
            HttpResponse response = this.httpClient.execute((HttpUriRequest)request);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                System.out.println("Returning a TOKEN");
                return (String)OpenVidu.httpResponseToJson(response).get((Object)"id");
            }
            throw new OpenViduException(OpenViduException.Code.TOKEN_CANNOT_BE_CREATED_ERROR_CODE, Integer.toString(statusCode));
        }
        catch (Exception e) {
            throw new OpenViduException(OpenViduException.Code.TOKEN_CANNOT_BE_CREATED_ERROR_CODE, "Unable to generate a token: " + e.getMessage());
        }
    }

    public SessionProperties getProperties() {
        return this.properties;
    }

    public String toString() {
        return this.sessionId;
    }

    private boolean hasSessionId() {
        return this.sessionId != null && !this.sessionId.isEmpty();
    }
}

