/*
 * Decompiled with CFR 0.152.
 */
package io.openvidu.java.client;

import io.openvidu.java.client.Archive;
import io.openvidu.java.client.OpenViduException;
import io.openvidu.java.client.Session;
import io.openvidu.java.client.SessionProperties;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class OpenVidu {
    private String urlOpenViduServer;
    private String secret;
    private HttpClient myHttpClient;
    static final String API_RECORDINGS = "api/recordings";
    static final String API_RECORDINGS_START = "/start";
    static final String API_RECORDINGS_STOP = "/stop";

    public OpenVidu(String urlOpenViduServer, String secret) {
        SSLContext sslContext;
        this.urlOpenViduServer = urlOpenViduServer;
        if (!this.urlOpenViduServer.endsWith("/")) {
            this.urlOpenViduServer = this.urlOpenViduServer + "/";
        }
        this.secret = secret;
        TrustStrategy trustStrategy = new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                return true;
            }
        };
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("OPENVIDUAPP", this.secret);
        provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
        try {
            sslContext = new SSLContextBuilder().loadTrustMaterial(null, trustStrategy).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        this.myHttpClient = HttpClients.custom().setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).setSSLContext(sslContext).setDefaultCredentialsProvider((CredentialsProvider)provider).build();
    }

    public Session createSession() throws OpenViduException {
        Session s = new Session(this.myHttpClient, this.urlOpenViduServer);
        return s;
    }

    public Session createSession(SessionProperties properties) throws OpenViduException {
        Session s = new Session(this.myHttpClient, this.urlOpenViduServer, properties);
        return s;
    }

    public Archive startRecording(String sessionId) throws OpenViduException {
        try {
            HttpPost request = new HttpPost(this.urlOpenViduServer + API_RECORDINGS + API_RECORDINGS_START);
            JSONObject json = new JSONObject();
            json.put((Object)"session", (Object)sessionId);
            StringEntity params = new StringEntity(json.toString());
            request.setHeader("Content-Type", "application/json");
            request.setEntity((HttpEntity)params);
            HttpResponse response = this.myHttpClient.execute((HttpUriRequest)request);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                return new Archive(OpenVidu.httpResponseToJson(response));
            }
            throw new OpenViduException(OpenViduException.Code.RECORDING_START_ERROR_CODE, Integer.toString(statusCode));
        }
        catch (Exception e) {
            throw new OpenViduException(OpenViduException.Code.RECORDING_START_ERROR_CODE, "Unable to start recording for session '" + sessionId + "': " + e.getMessage());
        }
    }

    public Archive stopRecording(String recordingId) throws OpenViduException {
        try {
            HttpPost request = new HttpPost(this.urlOpenViduServer + API_RECORDINGS + API_RECORDINGS_STOP + "/" + recordingId);
            HttpResponse response = this.myHttpClient.execute((HttpUriRequest)request);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                return new Archive(OpenVidu.httpResponseToJson(response));
            }
            throw new OpenViduException(OpenViduException.Code.RECORDING_STOP_ERROR_CODE, Integer.toString(statusCode));
        }
        catch (Exception e) {
            throw new OpenViduException(OpenViduException.Code.RECORDING_STOP_ERROR_CODE, "Unable to stop recording '" + recordingId + "': " + e.getMessage());
        }
    }

    public Archive getRecording(String recordingId) throws OpenViduException {
        try {
            HttpGet request = new HttpGet(this.urlOpenViduServer + API_RECORDINGS + "/" + recordingId);
            HttpResponse response = this.myHttpClient.execute((HttpUriRequest)request);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                return new Archive(OpenVidu.httpResponseToJson(response));
            }
            throw new OpenViduException(OpenViduException.Code.RECORDING_LIST_ERROR_CODE, Integer.toString(statusCode));
        }
        catch (Exception e) {
            throw new OpenViduException(OpenViduException.Code.RECORDING_LIST_ERROR_CODE, "Unable to get recording '" + recordingId + "': " + e.getMessage());
        }
    }

    public List<Archive> listRecordings() throws OpenViduException {
        try {
            HttpGet request = new HttpGet(this.urlOpenViduServer + API_RECORDINGS);
            HttpResponse response = this.myHttpClient.execute((HttpUriRequest)request);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                ArrayList<Archive> archives = new ArrayList<Archive>();
                JSONObject json = OpenVidu.httpResponseToJson(response);
                JSONArray array = (JSONArray)json.get((Object)"items");
                array.forEach(item -> archives.add(new Archive((JSONObject)item)));
                return archives;
            }
            throw new OpenViduException(OpenViduException.Code.RECORDING_LIST_ERROR_CODE, Integer.toString(statusCode));
        }
        catch (Exception e) {
            throw new OpenViduException(OpenViduException.Code.RECORDING_LIST_ERROR_CODE, "Unable to list recordings: " + e.getMessage());
        }
    }

    public void deleteRecording(String recordingId) throws OpenViduException {
        try {
            HttpDelete request = new HttpDelete(this.urlOpenViduServer + API_RECORDINGS + "/" + recordingId);
            HttpResponse response = this.myHttpClient.execute((HttpUriRequest)request);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 204) {
                throw new OpenViduException(OpenViduException.Code.RECORDING_DELETE_ERROR_CODE, Integer.toString(statusCode));
            }
        }
        catch (Exception e) {
            throw new OpenViduException(OpenViduException.Code.RECORDING_DELETE_ERROR_CODE, "Unable to delete recording '" + recordingId + "': " + e.getMessage());
        }
    }

    public static JSONObject httpResponseToJson(HttpResponse response) throws ParseException, IOException {
        JSONParser parser = new JSONParser();
        return (JSONObject)parser.parse(EntityUtils.toString((HttpEntity)response.getEntity()));
    }
}

