/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.openapi.utils;

import io.openvalidation.common.model.RuleValidatorInfo;
import io.openvalidation.openapi.model.OApiOperation;
import io.openvalidation.openapi.model.OApiRuleContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;

public class OApiModelUtils {
    public static List<OApiOperation> getOperationInfo(Map<String, Object> objs) {
        Map operations;
        ArrayList<OApiOperation> out = new ArrayList<OApiOperation>();
        if (objs != null && (operations = (Map)objs.get("operations")) != null) {
            List ops = (List)operations.get("operation");
            for (CodegenOperation operation : ops) {
                if (!operation.getHasBodyParam()) continue;
                OApiOperation modelInfo = new OApiOperation();
                modelInfo.setOperationID(operation.operationId);
                modelInfo.setPath(operation.path);
                modelInfo.setMethod(operation.httpMethod);
                modelInfo.setModelType(operation.bodyParam.dataType);
                out.add(modelInfo);
            }
        }
        return out;
    }

    public static List<CodegenModel> getModelsAsList(List<Object> allModels) {
        ArrayList<CodegenModel> out = new ArrayList<CodegenModel>();
        for (Object om : allModels) {
            HashMap hm = (HashMap)om;
            out.addAll(hm.values().stream().filter(v -> v instanceof CodegenModel).map(v -> (CodegenModel)v).collect(Collectors.toList()));
        }
        return out;
    }

    public static List<OApiRuleContainer> mergeOperationRulesWithOperationInfo(List<OApiOperation> modelInfos, List<OApiRuleContainer> containers) {
        ArrayList<OApiRuleContainer> out = new ArrayList<OApiRuleContainer>();
        if (modelInfos != null && modelInfos.size() > 0) {
            for (OApiOperation mi : modelInfos) {
                OApiRuleContainer cont = OApiModelUtils.mergeOperationRuleWithOperationInfo(mi, containers);
                if (cont == null) continue;
                out.add(cont);
            }
        }
        return out;
    }

    public static OApiRuleContainer mergeOperationRuleWithOperationInfo(OApiOperation modelInfo, List<OApiRuleContainer> containers) {
        if (modelInfo != null && containers != null && containers.size() > 0) {
            for (OApiRuleContainer container : containers) {
                if (!modelInfo.getPath().equalsIgnoreCase(container.getPath()) || !modelInfo.getMethod().equalsIgnoreCase(container.getMethod())) continue;
                container.setModelName(modelInfo.getModelType());
                container.setOperationId(modelInfo.getOperationID());
                return container;
            }
        }
        return null;
    }

    public static List<RuleValidatorInfo> convertToRuleValidatorInfo(List<OApiRuleContainer> ruleContainers, String pckg) {
        return ruleContainers.stream().map(o -> new RuleValidatorInfo(o.getName(), o.getOperationId(), pckg)).collect(Collectors.toList());
    }
}

