/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.openapi.utils;

import io.openvalidation.common.model.CodeGenerationResult;
import io.openvalidation.common.model.Language;
import io.openvalidation.common.utils.LanguageUtils;
import io.openvalidation.common.utils.StringUtils;
import java.util.List;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.SupportingFile;

public class OApiCodegenTemplateUtils {
    public static void addOVFrameworkTemplate(DefaultCodegen codegen, String code, String validationFolder, Language language) {
        codegen.additionalProperties().put("framework_code", code);
        codegen.supportingFiles().add(new SupportingFile("ovFramework.mustache", validationFolder, "OVFramework." + LanguageUtils.getExtensionFor((Language)language)));
    }

    public static void addOVAdapterTemplate(DefaultCodegen codegen, String validationFolder, Language language, String customAdapterClassName) {
        codegen.supportingFiles().add(new SupportingFile("ovValidatorAdapter.mustache", validationFolder, (StringUtils.isNullOrEmpty((String)customAdapterClassName) ? "OVValdatorAdapter" : customAdapterClassName) + "." + LanguageUtils.getExtensionFor((Language)language)));
    }

    public static void addOVFactoryTemplate(DefaultCodegen codegen, String code, String validationFolder, Language language) {
        codegen.additionalProperties().put("factory_code", code);
        codegen.supportingFiles().add(new SupportingFile("ovFactory.mustache", validationFolder, "OpenValidatorFactory." + LanguageUtils.getExtensionFor((Language)language)));
    }

    public static void addOVReadmeTemplate(DefaultCodegen codegen, String content, String validationFolder) {
        codegen.additionalProperties().put("content", content);
        codegen.supportingFiles().add(new SupportingFile("readme.md", validationFolder, "readme.md"));
    }

    public static void addOVSingleFileTemplate(DefaultCodegen codegen, String code, String validationFolder, Language language) {
        codegen.additionalProperties().put("single_file_code", code);
        codegen.supportingFiles().add(new SupportingFile("ovRules.mustache", validationFolder, "OVRules." + LanguageUtils.getExtensionFor((Language)language)));
    }

    public static void addOVRulesImplementationTemplate(List<CodeGenerationResult> results, DefaultCodegen codegen, Language language, String validationFolder) {
        String extension = LanguageUtils.getExtensionFor((Language)language);
        codegen.additionalProperties().put("code_results", results);
        codegen.supportingFiles().add(new SupportingFile("ovValidationRules.mustache", validationFolder, "OVRules." + extension));
    }
}

