/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.openapi.parser;

import io.openvalidation.openapi.model.OApiRule;
import io.openvalidation.openapi.model.OApiRuleContainer;
import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.parser.core.models.ParseOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OApiSpecParserSimple {
    private OpenAPI _oapi;
    ParseOptions po = new ParseOptions();

    public OApiSpecParserSimple(String url) {
        this.po.setResolve(true);
        this.po.setResolveFully(true);
        this._oapi = new OpenAPIParser().readLocation(url, null, this.po).getOpenAPI();
    }

    public List<PathItem> getPaths() {
        ArrayList<PathItem> items = new ArrayList<PathItem>();
        for (String key : this._oapi.getPaths().keySet()) {
            items.add((PathItem)this._oapi.getPaths().get((Object)key));
        }
        return items;
    }

    public List<Operation> getOperations() {
        ArrayList<Operation> operations = new ArrayList<Operation>();
        for (PathItem path : this.getPaths()) {
            operations.addAll(path.readOperations());
        }
        return operations;
    }

    public List<RequestBody> getRequestBodies() {
        ArrayList<RequestBody> requestBodies = new ArrayList<RequestBody>();
        for (Operation operation : this.getOperations()) {
            requestBodies.add(operation.getRequestBody());
        }
        return requestBodies;
    }

    public List<MediaType> getBodyMediaTypes() {
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
        for (RequestBody body : this.getRequestBodies()) {
            for (String mk : body.getContent().keySet()) {
                mediaTypes.add((MediaType)body.getContent().get((Object)mk));
            }
        }
        return mediaTypes;
    }

    public List<OApiRuleContainer> getRuleContainers() {
        ArrayList<OApiRuleContainer> xOVRules = new ArrayList<OApiRuleContainer>();
        for (MediaType mtype : this.getBodyMediaTypes()) {
            Map xovrules;
            Map extensions = mtype.getExtensions();
            if (extensions == null || extensions.size() <= 0 || !extensions.containsKey("x-ov-rules") || (xovrules = (Map)extensions.get("x-ov-rules")) == null || xovrules.size() <= 0) continue;
            OApiRuleContainer ruleContainer = new OApiRuleContainer();
            ruleContainer.setRule(new OApiRule((String)xovrules.get("rule")));
            xOVRules.add(ruleContainer);
        }
        return xOVRules;
    }
}

