/*
 * Decompiled with CFR 0.152.
 */
import com.reprezen.kaizen.oasparser.model3.Schema;
import io.openvalidation.common.data.DataSchema;
import io.openvalidation.common.utils.Console;
import io.openvalidation.core.OpenValidation;
import io.openvalidation.openapi.parser.OApiSpecParserKaizen;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.json.JSONObject;
import org.junit.jupiter.api.Test;

public class Yaml2DataSchemaTests {
    @Test
    public void resolve_bipro_claims_habitation_schema() throws Exception {
        DataSchema schema = this.convert("org.bipro.claims.habitation__ov.yaml", "/claims", "post");
        MatcherAssert.assertThat((Object)schema, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    private DataSchema convert(String yamlFile, String path, String method) throws Exception {
        DataSchema schema = null;
        Schema kaizenSchema = null;
        JSONObject jsonSchema = null;
        String json = null;
        try {
            OApiSpecParserKaizen gen = new OApiSpecParserKaizen();
            kaizenSchema = gen.parseFromLocalResource(yamlFile).getSchemaOfRequest(path, method);
            MatcherAssert.assertThat((Object)kaizenSchema, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            jsonSchema = gen.resolveSchema(kaizenSchema);
            MatcherAssert.assertThat((Object)jsonSchema, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            Console.printl((String)jsonSchema.toString(4));
            OpenValidation ov = OpenValidation.createDefault();
            json = jsonSchema.toString();
            MatcherAssert.assertThat((Object)json, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            ov.setSchema(json);
            schema = ov.getSchema();
        }
        catch (Exception exp) {
            Console.error((String)"ERROR while coverting yaml to json \n\n");
            if (jsonSchema != null) {
                Console.printl((String)"JSON: \n");
                Console.printl((String)jsonSchema.toString(4));
            }
            Console.printError((Exception)exp);
        }
        return schema;
    }
}

