/*
 * Decompiled with CFR 0.152.
 */
import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.parser.core.models.ParseOptions;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.openapitools.codegen.OpenAPIGenerator;

public class RuleLoaderTest {
    @Test
    public void load_spec_from_resource() throws Exception {
        String spec = this.getResourceConent("sample.yaml");
        MatcherAssert.assertThat((Object)spec, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void load_spec_from_resource_using_oapi() throws Exception {
        OpenAPI openAPI = new OpenAPIParser().readLocation("sample.yaml", null, new ParseOptions()).getOpenAPI();
        MatcherAssert.assertThat((Object)openAPI, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Paths paths = openAPI.getPaths();
        MatcherAssert.assertThat((Object)paths, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)paths.size(), (Matcher)Matchers.is((Object)7));
    }

    @Test
    public void execute_generator() throws Exception {
        OpenAPIGenerator generator = new OpenAPIGenerator();
        MatcherAssert.assertThat((Object)generator, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    public String getResourceConent(String resourceName) throws Exception {
        InputStream is = this.getCallerClass().getClassLoader().getResourceAsStream(resourceName);
        if (is != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            return reader.lines().collect(Collectors.joining(System.lineSeparator()));
        }
        return null;
    }

    public Class getCallerClass() throws Exception {
        String callerClassName = Thread.currentThread().getStackTrace()[2].getClassName();
        return Class.forName(callerClassName);
    }
}

