/*
 * Decompiled with CFR 0.152.
 */
import io.openvalidation.openapi.model.OApiRuleContainer;
import io.openvalidation.openapi.parser.OApiSpecParserSimple;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class OApiSpecParserSimpleTest {
    private static String TEST_SPEC_FILE = "sample.yaml";

    @Test
    public void load_operations_from_schema() throws Exception {
        OApiSpecParserSimple gen = new OApiSpecParserSimple(TEST_SPEC_FILE);
        List operations = gen.getOperations();
        MatcherAssert.assertThat((Object)operations, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)operations.size(), (Matcher)Matchers.is((Object)7));
    }

    @Test
    public void load_requestbodies_from_schema() throws Exception {
        OApiSpecParserSimple gen = new OApiSpecParserSimple(TEST_SPEC_FILE);
        List bodies = gen.getRequestBodies();
        MatcherAssert.assertThat((Object)bodies, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)bodies.size(), (Matcher)Matchers.is((Object)7));
    }

    @Test
    public void load_bodymediatypes_from_schema() throws Exception {
        OApiSpecParserSimple gen = new OApiSpecParserSimple(TEST_SPEC_FILE);
        List mediaTypes = gen.getBodyMediaTypes();
        MatcherAssert.assertThat((Object)mediaTypes, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)mediaTypes.size(), (Matcher)Matchers.is((Object)7));
    }

    @Test
    @Disabled
    public void load_xovrules_from_schema() throws Exception {
        OApiSpecParserSimple gen = new OApiSpecParserSimple(TEST_SPEC_FILE);
        List ruleContainers = gen.getRuleContainers();
        MatcherAssert.assertThat((Object)ruleContainers, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)ruleContainers.size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)((OApiRuleContainer)ruleContainers.get(0)).getName(), (Matcher)Matchers.is((Object)"Simple"));
        MatcherAssert.assertThat((Object)((OApiRuleContainer)ruleContainers.get(0)).getRuleAsStirng(), (Matcher)Matchers.containsString((String)"was f\u00fcr ein Quatsch!"));
        MatcherAssert.assertThat((Object)((OApiRuleContainer)ruleContainers.get(1)).getName(), (Matcher)Matchers.is((Object)"OneOfValidation"));
    }
}

