/*
 * Decompiled with CFR 0.152.
 */
import com.reprezen.kaizen.oasparser.model3.Schema;
import io.openvalidation.common.utils.ResourceUtils;
import io.openvalidation.openapi.model.OApiRule;
import io.openvalidation.openapi.model.OApiRuleContainer;
import io.openvalidation.openapi.parser.OApiSpecParserKaizen;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.json.JSONObject;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class OApiSpecParserKaizenTest {
    @Test
    public void load_schema_from_string() throws Exception {
        OApiSpecParserKaizen gen = new OApiSpecParserKaizen();
        String yaml = ResourceUtils.getResourceConent((String)"sample.yaml");
        Schema sma = gen.parse(yaml).getSchemaOfResponse("/simple", "post", "200");
        MatcherAssert.assertThat((Object)sma, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)sma.getProperty("code"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void get_schema_of_response() throws Exception {
        OApiSpecParserKaizen gen = new OApiSpecParserKaizen();
        Schema sma = gen.parseFromLocalResource("sample.yaml").getSchemaOfResponse("/simple", "post", "200");
        MatcherAssert.assertThat((Object)sma, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)sma.getProperty("code"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)sma.getProperty("code").getType(), (Matcher)Matchers.is((Object)"number"));
    }

    @Test
    public void resolve_nested_schema_recursive() throws Exception {
        OApiSpecParserKaizen gen = new OApiSpecParserKaizen();
        Schema sma = gen.parseFromLocalResource("nestedschema.yaml").getSchemaOfRequest("/life/contract", "put");
        MatcherAssert.assertThat((Object)sma, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        JSONObject jsonSchema = gen.resolveSchema(sma);
        MatcherAssert.assertThat((Object)jsonSchema, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        JSONObject properties = jsonSchema.getJSONObject("properties");
        MatcherAssert.assertThat((Object)properties, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)properties.keySet().size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)properties.getJSONObject("product"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)properties.getJSONObject("portfolio"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)properties.getJSONObject("product").get("type").toString(), (Matcher)Matchers.is((Object)"string"));
        MatcherAssert.assertThat((Object)properties.getJSONObject("portfolio").get("type").toString(), (Matcher)Matchers.is((Object)"object"));
        JSONObject portfolio = properties.getJSONObject("portfolio").getJSONObject("properties");
        MatcherAssert.assertThat((Object)portfolio, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)portfolio.getJSONObject("name"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        JSONObject shares = portfolio.getJSONObject("shares");
        MatcherAssert.assertThat((Object)shares, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)shares.get("type"), (Matcher)Matchers.is((Object)"array"));
        MatcherAssert.assertThat((Object)shares.has("items"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)shares.getJSONObject("items"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)shares.getJSONObject("items").has("properties"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)shares.getJSONObject("items").has("type"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)shares.getJSONObject("items").get("type").toString(), (Matcher)Matchers.is((Object)"object"));
        MatcherAssert.assertThat((Object)shares.getJSONObject("items").getJSONObject("properties").has("percentage"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)shares.getJSONObject("items").getJSONObject("properties").getJSONObject("percentage").has("type"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)shares.getJSONObject("items").getJSONObject("properties").getJSONObject("percentage").get("type").toString(), (Matcher)Matchers.is((Object)"integer"));
    }

    @Test
    public void resolve_schema_rule_containers() throws Exception {
        OApiSpecParserKaizen gen = new OApiSpecParserKaizen();
        List containers = gen.parseFromLocalResource("sample.yaml").getRuleContainers();
        MatcherAssert.assertThat((Object)containers, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)containers.size(), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void resolve_schema_rule_ref_container() throws Exception {
        OApiSpecParserKaizen gen = new OApiSpecParserKaizen();
        List containers = gen.parseFromLocalResource("sample.yaml").getRuleContainers();
        MatcherAssert.assertThat((Object)containers, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)containers.size(), (Matcher)Matchers.is((Object)3));
        OApiRule rule = ((OApiRuleContainer)containers.get(1)).getRule();
        MatcherAssert.assertThat((Object)rule, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)rule.getPlainRule(), (Matcher)Matchers.containsString((String)"123"));
    }

    @Test
    public void resolve_schema_rule_name() throws Exception {
        OApiSpecParserKaizen gen = new OApiSpecParserKaizen();
        List containers = gen.parseFromLocalResource("sample.yaml").getRuleContainers();
        MatcherAssert.assertThat((Object)containers, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)containers.size(), (Matcher)Matchers.is((Object)3));
        OApiRuleContainer cnt = (OApiRuleContainer)containers.get(0);
        MatcherAssert.assertThat((Object)cnt, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)cnt.getPath(), (Matcher)Matchers.is((Object)"/simple"));
        MatcherAssert.assertThat((Object)cnt.getMethod(), (Matcher)Matchers.is((Object)"POST"));
        OApiRuleContainer cnt1 = (OApiRuleContainer)containers.get(1);
        MatcherAssert.assertThat((Object)cnt1, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)cnt1.getPath(), (Matcher)Matchers.is((Object)"/oneof"));
        MatcherAssert.assertThat((Object)cnt1.getMethod(), (Matcher)Matchers.is((Object)"POST"));
        OApiRuleContainer cnt2 = (OApiRuleContainer)containers.get(2);
        MatcherAssert.assertThat((Object)cnt2, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)cnt2.getPath(), (Matcher)Matchers.is((Object)"/duplicates"));
    }

    @Test
    public void should_contains_culture_param() throws Exception {
        OApiSpecParserKaizen gen = new OApiSpecParserKaizen();
        String yaml = ResourceUtils.getResourceConent((String)"sample.yaml");
        List containers = gen.parse(yaml).getRuleContainers();
        List cultures = containers.stream().map(c -> c.getOptions().getLocale().toString()).collect(Collectors.toList());
        MatcherAssert.assertThat(cultures, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat(cultures, (Matcher)Matchers.hasItem((Object)"en"));
    }

    @Test
    @Disabled
    public void resolve_schema_allOf() throws Exception {
        OApiSpecParserKaizen gen = new OApiSpecParserKaizen();
        Schema sma = gen.parseFromLocalResource("sample.yaml").getSchemaOfRequest("/allof", "post");
        MatcherAssert.assertThat((Object)sma, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        JSONObject jsonSchema = gen.resolveSchema(sma);
        MatcherAssert.assertThat((Object)jsonSchema, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        JSONObject properties = jsonSchema.getJSONObject("properties");
        MatcherAssert.assertThat((Object)properties, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)properties.keySet().size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)properties.getJSONObject("name"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)properties.getJSONObject("value"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)properties.getJSONObject("name").get("type").toString(), (Matcher)Matchers.is((Object)"string"));
        MatcherAssert.assertThat((Object)properties.getJSONObject("value").get("type").toString(), (Matcher)Matchers.is((Object)"integer"));
    }

    @Test
    @Disabled
    public void resolve_schema_allOf_from_response() throws Exception {
        OApiSpecParserKaizen gen = new OApiSpecParserKaizen();
        Schema sma = gen.parseFromLocalResource("sample.yaml").getSchemaOfResponse("/allof", "post", "200");
        MatcherAssert.assertThat((Object)sma, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        JSONObject jsonSchema = gen.resolveSchema(sma);
        MatcherAssert.assertThat((Object)jsonSchema, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        JSONObject properties = jsonSchema.getJSONObject("properties");
        MatcherAssert.assertThat((Object)properties, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)properties.keySet().size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)properties.getJSONObject("name"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)properties.getJSONObject("value"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)properties.getJSONObject("name").get("type").toString(), (Matcher)Matchers.is((Object)"string"));
        MatcherAssert.assertThat((Object)properties.getJSONObject("value").get("type").toString(), (Matcher)Matchers.is((Object)"integer"));
    }

    @Test
    @Disabled
    public void resolve_schema_duplicates() throws Exception {
        OApiSpecParserKaizen gen = new OApiSpecParserKaizen();
        Schema sma = gen.parseFromLocalResource("sample.yaml").getSchemaOfRequest("/duplicates", "post");
        MatcherAssert.assertThat((Object)sma, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        JSONObject jsonSchema = gen.resolveSchema(sma);
        MatcherAssert.assertThat((Object)jsonSchema, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        JSONObject properties = jsonSchema.getJSONObject("properties");
        MatcherAssert.assertThat((Object)properties, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)properties.keySet().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)properties.getJSONObject("name"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)properties.getJSONObject("name").get("type").toString(), (Matcher)Matchers.is((Object)"string"));
    }

    @Test
    @Disabled
    public void resolve_schema_oneOf() throws Exception {
        OApiSpecParserKaizen gen = new OApiSpecParserKaizen();
        Schema sma = gen.parseFromLocalResource("sample.yaml").getSchemaOfRequest("/oneof", "post");
        MatcherAssert.assertThat((Object)sma, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        JSONObject jsonSchema = gen.resolveSchema(sma);
        MatcherAssert.assertThat((Object)jsonSchema, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        JSONObject properties = jsonSchema.getJSONObject("properties");
        MatcherAssert.assertThat((Object)properties, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)properties.keySet().size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)properties.getJSONObject("name"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)properties.getJSONObject("value"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)properties.getJSONObject("name").get("type").toString(), (Matcher)Matchers.is((Object)"string"));
        MatcherAssert.assertThat((Object)properties.getJSONObject("value").get("type").toString(), (Matcher)Matchers.is((Object)"integer"));
    }

    @Test
    @Disabled
    public void resolve_schema_anyOf() throws Exception {
        OApiSpecParserKaizen gen = new OApiSpecParserKaizen();
        Schema sma = gen.parseFromLocalResource("sample.yaml").getSchemaOfRequest("/anyof", "post");
        MatcherAssert.assertThat((Object)sma, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        JSONObject jsonSchema = gen.resolveSchema(sma);
        MatcherAssert.assertThat((Object)jsonSchema, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        JSONObject properties = jsonSchema.getJSONObject("properties");
        MatcherAssert.assertThat((Object)properties, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)properties.keySet().size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)properties.getJSONObject("name"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)properties.getJSONObject("value"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)properties.getJSONObject("name").get("type").toString(), (Matcher)Matchers.is((Object)"string"));
        MatcherAssert.assertThat((Object)properties.getJSONObject("value").get("type").toString(), (Matcher)Matchers.is((Object)"integer"));
    }

    @Test
    @Disabled
    public void resolve_schema_recursive() throws Exception {
        OApiSpecParserKaizen gen = new OApiSpecParserKaizen();
        Schema sma = gen.parseFromLocalResource("sample.yaml").getSchemaOfRequest("/recursive", "post");
        MatcherAssert.assertThat((Object)sma, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        JSONObject jsonSchema = gen.resolveSchema(sma);
        MatcherAssert.assertThat((Object)jsonSchema, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        JSONObject properties = jsonSchema.getJSONObject("properties");
        MatcherAssert.assertThat((Object)properties, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)properties.keySet().size(), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((Object)properties.getJSONObject("name"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)properties.getJSONObject("value"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)properties.getJSONObject("art"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)properties.getJSONObject("name").get("type").toString(), (Matcher)Matchers.is((Object)"string"));
        MatcherAssert.assertThat((Object)properties.getJSONObject("value").get("type").toString(), (Matcher)Matchers.is((Object)"integer"));
        MatcherAssert.assertThat((Object)properties.getJSONObject("art").get("type").toString(), (Matcher)Matchers.is((Object)"boolean"));
    }
}

