/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.generation;

import io.openvalidation.common.ast.ASTItem;
import io.openvalidation.common.ast.ASTModel;
import io.openvalidation.common.exceptions.OpenValidationException;
import io.openvalidation.common.interfaces.IOpenValidationGenerator;
import io.openvalidation.common.log.ProcessLogger;
import io.openvalidation.common.model.Language;
import io.openvalidation.common.utils.ResourceUtils;
import io.openvalidation.generation.CodeGenerator;
import java.util.Map;

public class OpenValidationGenerator
implements IOpenValidationGenerator {
    public String generate(ASTModel ast, Language language) throws Exception {
        return this.generate(ast, language, "main");
    }

    public String generateFramework(ASTModel ast, Language language) throws Exception {
        return this.generate(ast, language, "framework");
    }

    public String generateValidatorFactory(Map<String, Object> params, Language language) throws Exception {
        ASTModel ast = new ASTModel();
        ast.addParams(params);
        return this.generate(ast, language, "validatorfactory");
    }

    private String generate(ASTModel ast, Language language, String template) throws Exception {
        try {
            String templateFile = "/" + language.getName().toLowerCase() + "/" + template + ".hbs";
            if (!ResourceUtils.exists((String)templateFile)) {
                if (template.equalsIgnoreCase("main")) {
                    throw new OpenValidationException("Generation of '" + language.getName() + "' Language is not implemented. Missing main.hbs template.");
                }
                throw new OpenValidationException("Generation of '" + language.getName() + "' Language failed. Missing '" + templateFile + "' template.");
            }
            ast.setDefault("generated_class_name", "HUMLValidator");
            ast.setDefault("generated_class_namespace", "io.openvalidation.rules");
            String code = CodeGenerator.generate(language.getName().toLowerCase(), template, (ASTItem)ast, false);
            ProcessLogger.success((String)ProcessLogger.GENERATOR);
            return code;
        }
        catch (Exception e) {
            ProcessLogger.error((String)ProcessLogger.GENERATOR);
            throw e;
        }
    }
}

