/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.generation;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.helper.ConditionalHelpers;
import com.github.jknack.handlebars.io.ClassPathTemplateLoader;
import com.github.jknack.handlebars.io.TemplateLoader;
import com.github.jknack.handlebars.io.TemplateSource;
import io.openvalidation.common.ast.ASTArithmeticalOperator;
import io.openvalidation.common.ast.ASTComparisonOperator;
import io.openvalidation.common.ast.ASTItem;
import io.openvalidation.common.ast.condition.ASTConditionConnector;
import io.openvalidation.common.utils.ResourceUtils;
import io.openvalidation.common.validation.Validator;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class CodeGenerator {
    private static Map<String, String> inheritance = new HashMap<String, String>();

    public static String generate(final String language, String partial, ASTItem model, boolean isInlinePartial) throws Exception {
        Validator.shouldNotBeEmpty((String)partial, (String)"Name of partial Template");
        Validator.shouldNotBeEmpty((String)language, (String)"output Programming Language");
        Validator.shouldNotBeEmpty((Object)model, (String)"AST model");
        if (!partial.equals("{{tmpl}}")) {
            if (!(partial.equals("main") && model.getType().equals("astmodel") || partial.equals("framework") && model.getType().equals("astmodel") || partial.equals("validatorfactory") && model.getType().equals("astmodel"))) {
                Validator.shouldEquals((Object)model.getType(), (Object)partial, (String)"model type", (String)("model type: '" + model.getType() + "' - partial template name'" + partial + "'"));
            }
            Validator.shouldBeFals((boolean)isInlinePartial, (String)"cause partial content is not {{tmpl}}, IS INLINE PARTIAL");
        } else {
            Validator.shouldBeTrue((boolean)isInlinePartial, (String)"cause partial content is {{tmpl}}, IS INLINE PARTIAL");
        }
        ClassPathTemplateLoader loader = new ClassPathTemplateLoader();
        Handlebars handlebars = new Handlebars((TemplateLoader)loader);
        handlebars.registerHelpers(ConditionalHelpers.class);
        handlebars.infiniteLoops(true);
        handlebars.registerHelper("equals", (Helper)new Helper<Object>(){

            public CharSequence apply(Object a, Options options) throws IOException {
                Object b = options.param(0, null);
                if (a == null || b == null) {
                    return options.inverse();
                }
                return a.toString().toLowerCase().equals(b.toString().toLowerCase()) ? options.fn() : options.inverse();
            }
        });
        handlebars.registerHelper("not_equals", (Helper)new Helper<Object>(){

            public CharSequence apply(Object a, Options options) throws IOException {
                Object b = options.param(0, null);
                if (a == null || b == null) {
                    return a == null && b == null ? options.inverse() : options.fn();
                }
                return a.toString().toLowerCase().equals(b.toString().toLowerCase()) ? options.inverse() : options.fn();
            }
        });
        handlebars.registerHelper("tmpl", (Helper)new Helper<Object>(){

            public CharSequence apply(Object a, Options options) throws IOException {
                Object b = options.param(0, null);
                String tmplFullName = null;
                String tmplName = null;
                String errors = "";
                TemplateSource t = null;
                Template tmpl = null;
                try {
                    tmplName = a != null && a instanceof String ? a.toString() : (options.context.model() instanceof ASTArithmeticalOperator ? ((ASTArithmeticalOperator)options.context.model()).getType() : (options.context.model() instanceof ASTComparisonOperator ? ASTComparisonOperator.class.getSimpleName().toLowerCase() : (options.context.model() instanceof ASTConditionConnector ? ASTConditionConnector.class.getSimpleName().toLowerCase() : ((ASTItem)options.context.model()).getType())));
                    tmplFullName = ResourceUtils.exists((String)("/" + language + "/" + tmplName + ".hbs")) ? "/" + language + "/" + tmplName : (inheritance.containsKey(language) && ResourceUtils.exists((String)("/" + (String)inheritance.get(language) + "/" + tmplName + ".hbs")) ? "/" + (String)inheritance.get(language) + "/" + tmplName : "/common/" + tmplName);
                    t = options.handlebars.getLoader().sourceAt(tmplFullName);
                    tmpl = options.handlebars.compile(t);
                    return new Handlebars.SafeString((CharSequence)tmpl.apply(options.context));
                }
                catch (Exception e) {
                    String stcktr = String.join((CharSequence)"\n", Arrays.stream(e.getStackTrace()).map(s -> s.toString()).collect(Collectors.toList()));
                    errors = errors + "\n\n### ERRROR: \n\n" + e.toString() + stcktr + "\n\n:ERRROR ###\n\n";
                    if (t != null) {
                        errors = "\n\n Template NAME: " + t.filename() + errors + "\n\n";
                    }
                    if (tmpl != null) {
                        errors = "\n\n Template Content: " + tmpl.text() + errors + "\n\n";
                    }
                    boolean bl = false;
                    return "TEMPLATE [" + tmplName + " - " + tmplFullName + " language: " + language + "] NOT FOUND!]\n\n" + errors;
                }
            }
        });
        Template template = isInlinePartial ? handlebars.compileInline(partial) : handlebars.compile("/" + language + "/" + partial);
        return template.apply((Object)model);
    }

    static {
        inheritance.put("node", "javascript");
    }
}

