/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.core.validation.functions;

import io.openvalidation.common.ast.ASTItem;
import io.openvalidation.common.ast.operand.ASTOperandBase;
import io.openvalidation.common.ast.operand.ASTOperandFunction;
import io.openvalidation.common.ast.operand.ASTOperandStaticNumber;
import io.openvalidation.common.ast.operand.ASTOperandVariable;
import io.openvalidation.common.ast.operand.property.ASTOperandProperty;
import io.openvalidation.common.data.DataPropertyType;
import io.openvalidation.common.exceptions.ASTValidationException;
import io.openvalidation.common.utils.StringUtils;
import io.openvalidation.core.validation.functions.FunctionValidatorBase;
import java.util.List;

public class FunctionFirstValidator
extends FunctionValidatorBase {
    public FunctionFirstValidator(ASTOperandFunction function) {
        this.function = function;
    }

    @Override
    public void validateFunction() throws Exception {
        List parameters = this.function.getParameters();
        if (parameters.isEmpty()) {
            throw new ASTValidationException("The function " + this.function.getName() + " requires at least one parameter", (ASTItem)this.function);
        }
        if (parameters.size() <= 2) {
            ASTOperandBase firstParam = (ASTOperandBase)parameters.get(0);
            String firstParamClassName = StringUtils.getUserFriendlyClassName((Object)firstParam);
            if (!(firstParam instanceof ASTOperandProperty || firstParam instanceof ASTOperandFunction || firstParam instanceof ASTOperandVariable)) {
                throw new ASTValidationException("The function " + this.function.getName() + " has to be applied on a property, variable or a nested function of type 'Array'. Currently applied on a " + firstParamClassName + "(" + firstParam.getClass().getSimpleName() + ").", (ASTItem)this.function);
            }
            if (firstParam.getDataType() != DataPropertyType.Array) {
                throw new ASTValidationException("The function " + this.function.getName() + " has to be applied on a " + firstParamClassName + " of type 'Array'. But is applied on " + firstParamClassName + " of type '" + firstParam.getDataType() + "'.", (ASTItem)this.function);
            }
            if (parameters.size() == 2) {
                ASTOperandBase secondParam = (ASTOperandBase)parameters.get(1);
                String secondParamClassName = StringUtils.getUserFriendlyClassName((Object)secondParam);
                if (!(secondParam instanceof ASTOperandStaticNumber)) {
                    throw new ASTValidationException("The function " + this.function.getName() + " only takes a number as its second parameter. Current second parameter is " + secondParamClassName + "(" + secondParam.getClass().getSimpleName() + ").", (ASTItem)this.function);
                }
                if (((ASTOperandStaticNumber)secondParam).getNumberValue() < 1.0) {
                    throw new ASTValidationException("The function " + this.function.getName() + " only takes numbers with a value greater or equal to 1 as the second parameter. Current value is " + ((ASTOperandStaticNumber)secondParam).getNumberValue(), (ASTItem)this.function);
                }
            }
        } else {
            throw new ASTValidationException("Invalid number of parameters (" + parameters.size() + ")", (ASTItem)this.function);
        }
    }
}

