/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.core.validation;

import io.openvalidation.common.ast.ASTActionError;
import io.openvalidation.common.ast.ASTComment;
import io.openvalidation.common.ast.ASTItem;
import io.openvalidation.common.ast.ASTRule;
import io.openvalidation.common.ast.ASTUnknown;
import io.openvalidation.common.ast.ASTVariable;
import io.openvalidation.common.ast.condition.ASTCondition;
import io.openvalidation.common.ast.condition.ASTConditionGroup;
import io.openvalidation.common.ast.operand.ASTOperandBase;
import io.openvalidation.common.ast.operand.ASTOperandFunction;
import io.openvalidation.common.ast.operand.ASTOperandVariable;
import io.openvalidation.common.ast.operand.arithmetical.ASTOperandArithmetical;
import io.openvalidation.common.ast.operand.arithmetical.ASTOperandArithmeticalItemBase;
import io.openvalidation.common.ast.operand.arithmetical.ASTOperandArithmeticalOperation;
import io.openvalidation.common.ast.operand.lambda.ASTOperandLambdaCondition;
import io.openvalidation.common.exceptions.OpenValidationException;
import io.openvalidation.core.validation.ASTConditionGroupValidator;
import io.openvalidation.core.validation.ASTConditionValidator;
import io.openvalidation.core.validation.ASTErrorValidator;
import io.openvalidation.core.validation.ASTOperandFunctionValidator;
import io.openvalidation.core.validation.ASTOperandLambdaConditionValidator;
import io.openvalidation.core.validation.ASTOperandVariableValidator;
import io.openvalidation.core.validation.ASTRuleValidator;
import io.openvalidation.core.validation.ASTUnknownValidator;
import io.openvalidation.core.validation.ASTVariableValidator;
import io.openvalidation.core.validation.EmptyValidator;
import io.openvalidation.core.validation.ValidatorBase;
import io.openvalidation.core.validation.operand.arithmetical.ASTArithmeticalOperationValidator;
import io.openvalidation.core.validation.operand.arithmetical.ASTArithmeticalValidator;

public class ValidatorFactory {
    public static ValidatorBase Create(ASTItem item) throws Exception {
        if (item instanceof ASTRule) {
            return new ASTRuleValidator((ASTRule)item);
        }
        if (item instanceof ASTActionError) {
            return new ASTErrorValidator((ASTActionError)item);
        }
        if (item instanceof ASTConditionGroup) {
            return new ASTConditionGroupValidator((ASTConditionGroup)item);
        }
        if (item instanceof ASTCondition) {
            return new ASTConditionValidator((ASTCondition)item);
        }
        if (item instanceof ASTVariable) {
            return new ASTVariableValidator((ASTVariable)item);
        }
        if (item instanceof ASTOperandArithmetical) {
            return new ASTArithmeticalValidator((ASTOperandArithmetical)item);
        }
        if (item instanceof ASTOperandArithmeticalOperation) {
            return new ASTArithmeticalOperationValidator((ASTOperandArithmeticalOperation)item);
        }
        if (item instanceof ASTOperandVariable) {
            return new ASTOperandVariableValidator((ASTOperandVariable)item);
        }
        if (item instanceof ASTOperandFunction) {
            return new ASTOperandFunctionValidator((ASTOperandFunction)item);
        }
        if (item instanceof ASTOperandLambdaCondition) {
            return new ASTOperandLambdaConditionValidator((ASTOperandLambdaCondition)item);
        }
        if (item instanceof ASTUnknown) {
            return new ASTUnknownValidator((ASTUnknown)item);
        }
        if (item instanceof ASTComment) {
            return new EmptyValidator();
        }
        if (item instanceof ASTOperandBase) {
            return new EmptyValidator();
        }
        if (item instanceof ASTOperandArithmeticalItemBase) {
            return new EmptyValidator();
        }
        throw new OpenValidationException("No Validator for type : " + item.getType() + " found");
    }
}

