/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.core.validation;

import io.openvalidation.common.ast.ASTItem;
import io.openvalidation.common.ast.ASTRule;
import io.openvalidation.common.ast.condition.ASTConditionBase;
import io.openvalidation.common.exceptions.ASTValidationException;
import io.openvalidation.core.validation.ValidatorBase;

public class ASTRuleValidator
extends ValidatorBase {
    private ASTRule _rule;

    public ASTRuleValidator(ASTRule rule) {
        this._rule = rule;
    }

    @Override
    public void validate() throws Exception {
        ASTConditionBase condition = this._rule.getCondition();
        if (condition == null) {
            throw new ASTValidationException("a Rule should contains at least one condition.", (ASTItem)this._rule);
        }
        if (this._rule.getAction() == null) {
            throw new ASTValidationException("a Rule should contains an error message.", (ASTItem)this._rule);
        }
        if (this._rule.getAction() != null) {
            this.validate((ASTItem)this._rule.getAction(), this._rule.getGlobalPosition());
        }
        this.validate((ASTItem)condition, this._rule.getGlobalPosition());
        if (this._rule.getInvalidConditions() != null && this._rule.getInvalidConditions().size() > 0) {
            throw new ASTValidationException("missing AND/OR connector in combined condition.", (ASTItem)this._rule.getInvalidConditions().get(0));
        }
    }
}

