/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.core.validation;

import io.openvalidation.common.ast.ASTItem;
import io.openvalidation.common.ast.operand.ASTOperandFunction;
import io.openvalidation.common.exceptions.ASTValidationException;
import io.openvalidation.core.validation.ValidatorBase;
import io.openvalidation.core.validation.functions.FunctionFirstValidator;
import io.openvalidation.core.validation.functions.FunctionGetArrayOfValidator;
import io.openvalidation.core.validation.functions.FunctionLastValidator;
import io.openvalidation.core.validation.functions.FunctionSumOfValidator;
import io.openvalidation.core.validation.functions.FunctionTakeValidator;
import io.openvalidation.core.validation.functions.FunctionValidatorBase;
import io.openvalidation.core.validation.functions.FunctionWhereValidator;

public class ASTOperandFunctionValidator
extends ValidatorBase {
    private ASTOperandFunction function;

    public ASTOperandFunctionValidator(ASTOperandFunction function) {
        this.function = function;
    }

    @Override
    public void validate() throws Exception {
        if (this.function.getName() == null || this.function.getName().isEmpty()) {
            throw new ASTValidationException("The function must have a name", (ASTItem)this.function);
        }
        FunctionValidatorBase subFunctionValidator = this.createFunctionSubValidator();
        subFunctionValidator.setContext(this.context);
        subFunctionValidator.validate();
    }

    private FunctionValidatorBase createFunctionSubValidator() throws Exception {
        switch (this.function.getName()) {
            case "FIRST": {
                return new FunctionFirstValidator(this.function);
            }
            case "LAST": {
                return new FunctionLastValidator(this.function);
            }
            case "TAKE": {
                return new FunctionTakeValidator(this.function);
            }
            case "SUM_OF": {
                return new FunctionSumOfValidator(this.function);
            }
            case "GET_ARRAY_OF": {
                return new FunctionGetArrayOfValidator(this.function);
            }
            case "WHERE": {
                return new FunctionWhereValidator(this.function);
            }
        }
        throw new ASTValidationException("Function with name '" + this.function.getName() + "' is not known", (ASTItem)this.function);
    }
}

