/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.core.validation;

import io.openvalidation.common.ast.ASTItem;
import io.openvalidation.common.ast.condition.ASTConditionBase;
import io.openvalidation.common.ast.condition.ASTConditionGroup;
import io.openvalidation.common.exceptions.ASTValidationException;
import io.openvalidation.core.validation.ValidatorBase;

public class ASTConditionGroupValidator
extends ValidatorBase {
    private ASTConditionGroup _conditionGroup;
    private int _level;

    public ASTConditionGroupValidator(ASTConditionGroup conditionGroup) {
        this._conditionGroup = conditionGroup;
    }

    public void setLevel(int level) {
        this._level = level;
    }

    @Override
    public void validate() throws Exception {
        if (this._level > 0 && this._conditionGroup.getConnector() == null) {
            throw new ASTValidationException("missing AND/OR connector in combined condition.", (ASTItem)this._conditionGroup, this.globalPosition);
        }
        if (this._conditionGroup.getConditions().size() == 1 && this._conditionGroup.getConditions().get(0) instanceof ASTConditionGroup) {
            throw new ASTValidationException("condition group size is 1 and contains a single condition group. Unnecessary wrapping.", (ASTItem)this._conditionGroup, this.globalPosition);
        }
        for (ASTConditionBase cond : this._conditionGroup.getConditions()) {
            this.validate((ASTItem)cond, this.globalPosition);
        }
    }
}

