/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.core.preprocessing;

import io.openvalidation.common.model.PreProcessorContext;
import io.openvalidation.common.utils.ReflectionUtils;
import io.openvalidation.core.preprocessing.PreProcessorStepBase;
import io.openvalidation.core.preprocessing.steps.PreProcessorAliasResolutionStep;
import io.openvalidation.core.preprocessing.steps.PreProcessorIncludeResolutionStep;
import io.openvalidation.core.preprocessing.steps.PreProcessorKeywordCollisionStep;
import io.openvalidation.core.preprocessing.steps.PreProcessorLastParagraphCleanup;
import io.openvalidation.core.preprocessing.steps.PreProcessorVariableNamesStep;
import java.util.ArrayList;
import java.util.List;

public class PreProcessorStepFactory {
    public static List<PreProcessorStepBase> create(PreProcessorContext ctx) {
        ArrayList<PreProcessorStepBase> allSteps = new ArrayList<PreProcessorStepBase>();
        Class[] stepClasses = new Class[]{PreProcessorIncludeResolutionStep.class, PreProcessorAliasResolutionStep.class, PreProcessorKeywordCollisionStep.class, PreProcessorVariableNamesStep.class, PreProcessorLastParagraphCleanup.class};
        try {
            for (Class cls : stepClasses) {
                allSteps.add((PreProcessorStepBase)PreProcessorStepFactory.createStep(cls, ctx));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("while creating preprocessing steps.", e);
        }
        return allSteps;
    }

    public static <T extends PreProcessorStepBase> T createStep(Class<T> cls, PreProcessorContext ctx) throws Exception {
        PreProcessorStepBase ste = (PreProcessorStepBase)ReflectionUtils.createInstance(cls);
        ste.setContext(ctx);
        return (T)ste;
    }
}

