/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.core;

import io.openvalidation.common.exceptions.OpenValidationException;
import io.openvalidation.common.utils.FileSystemUtils;
import io.openvalidation.common.utils.NameMasking;
import io.openvalidation.common.utils.ResourceUtils;
import io.openvalidation.common.utils.StringUtils;
import io.openvalidation.common.utils.UTF8Control;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Aliases {
    public static List<String> availableCultures = ResourceUtils.getAvailableCultures();
    private static Map<String, String> _customAliases;

    public static String normalize(String alias) {
        return Aliases.normalize(Locale.getDefault().toLanguageTag(), alias);
    }

    public static String normalize(String locale, String alias) {
        String normalizedValue = null;
        Map<String, String> available = Aliases.getAvailableAliases(locale);
        if (available.containsKey(alias)) {
            normalizedValue = available.get(alias);
        }
        if (normalizedValue == null && _customAliases != null && _customAliases.containsKey(alias)) {
            normalizedValue = _customAliases.get(alias);
        }
        return normalizedValue != null ? normalizedValue : "[NOTFOUND_" + locale + "_" + alias + "]";
    }

    public static Map<String, String> getAvailableAliases() {
        return Aliases.getAvailableAliases(Locale.getDefault().toLanguageTag());
    }

    public static Map<String, String> getAvailableAliases(String locale) {
        HashMap<String, String> available = new HashMap<String, String>();
        ResourceBundle bundle = ResourceBundle.getBundle(Aliases.class.getSimpleName().toLowerCase(), new Locale(locale), (ResourceBundle.Control)new UTF8Control());
        for (String key : Collections.list(bundle.getKeys())) {
            String[] values;
            for (String val : values = bundle.getString(key).split(",")) {
                String v = val.trim();
                if (v.isEmpty()) continue;
                available.put(val.trim(), key);
            }
        }
        if (_customAliases != null) {
            for (String alias : _customAliases.keySet()) {
                if (available.containsKey(alias)) {
                    available.replace(alias, _customAliases.get(alias));
                    continue;
                }
                available.put(alias, _customAliases.get(alias));
            }
        }
        return available;
    }

    public static boolean hasAlias(String alias, Locale locale) {
        return Aliases.hasAlias(alias, locale.toLanguageTag());
    }

    public static boolean hasAlias(String alias, String locale) {
        return Aliases.getAvailableAliases(locale).keySet().stream().anyMatch(k -> k.toLowerCase().equals(alias.toLowerCase()));
    }

    public static List<String> getAliasByToken(String locale, String ... tokens) {
        Map<String, String> allAliases = Aliases.getAvailableAliases(locale);
        ArrayList<String> returnList = new ArrayList<String>();
        for (String token : tokens) {
            Map<String, String> tmpSet = allAliases.entrySet().stream().filter(tuple -> ((String)tuple.getValue()).equals(token)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            returnList.addAll(tmpSet.keySet());
        }
        return returnList;
    }

    public static String resolve(String plainText, Locale locale) {
        String ruleContent = "MAGICSTUFF:\n" + plainText.trim().replaceAll("\r\n", "\n") + "\n:MAGICSTUFF";
        Map<String, String> aliases = Aliases.getAvailableAliases(locale.toLanguageTag());
        List keysSorted = aliases.keySet().stream().sorted(Comparator.comparing(String::length)).collect(Collectors.toList());
        Collections.reverse(keysSorted);
        for (String alias : keysSorted) {
            List originalKeywords = StringUtils.findMatches((String)ruleContent, (String)alias);
            if (originalKeywords == null || originalKeywords.size() <= 0) continue;
            for (String ok : originalKeywords) {
                String replacement = aliases.get(alias);
                if (!Aliases.endsWithKeywordSymbol(replacement)) {
                    replacement = replacement + "\u02ac";
                }
                replacement = replacement + NameMasking.maskName((String)ok);
                ruleContent = StringUtils.replaceWord((String)ruleContent, (String)ok, (String)replacement);
            }
        }
        ruleContent = ruleContent.replaceAll("MAGICSTUFF:\n", "").replaceAll("\n:MAGICSTUFF", "").replaceAll("MAGICSTUFF:", "").replaceAll(":MAGICSTUFF", "");
        return ruleContent.trim();
    }

    private static boolean endsWithKeywordSymbol(String input) {
        String endingChar = String.valueOf(input.charAt(input.length() - 1));
        return endingChar.equalsIgnoreCase("\u02ac");
    }

    public static String resolve(String plainText, String includedKeys, Locale locale) {
        String ruleContent = plainText;
        Map<String, String> aliases = Aliases.getAvailableAliases(locale.toLanguageTag());
        for (String alias : aliases.keySet()) {
            if (!aliases.get(alias).equalsIgnoreCase(includedKeys)) continue;
            ruleContent = ruleContent.replaceAll("(?i)" + Pattern.quote(alias), aliases.get(alias));
        }
        return ruleContent;
    }

    public static void appendCustomAliasesFromFile(String filePath) throws FileNotFoundException {
        if (filePath == null) {
            return;
        }
        FileSystemUtils.fileShouldExists((String)filePath, (String)("A custom Alias File: " + filePath + " could not be found."));
        try {
            String plain = FileSystemUtils.readFile((String)filePath);
            HashMap<String, String> aliases = new HashMap<String, String>();
            if (plain != null) {
                for (String line : plain.split(System.lineSeparator())) {
                    String[] keyValue = line.split("=");
                    if (keyValue == null || keyValue.length != 2) continue;
                    String key = keyValue[0].trim();
                    String value = keyValue[1].trim();
                    if (value.contains(",")) {
                        for (String v : value.split(",")) {
                            aliases.put(v.trim(), key);
                        }
                        continue;
                    }
                    aliases.put(value, key);
                }
            }
            if (aliases.size() > 0) {
                Aliases.appendCustomAliases(aliases);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void appendCustomAliases(Map<String, String> aliases) {
        if (aliases == null) {
            return;
        }
        if (_customAliases == null) {
            _customAliases = new HashMap<String, String>();
        }
        for (String alias : aliases.keySet()) {
            if (_customAliases.containsKey(alias)) {
                _customAliases.replace(alias, aliases.get(alias));
                continue;
            }
            _customAliases.put(alias, aliases.get(alias));
        }
    }

    public static void appendCustomAliases(String key, String value) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(key, value);
        Aliases.appendCustomAliases(map);
    }

    public static void validateAliases() throws Exception {
        ArrayList out = new ArrayList();
        Object locales = null;
        if (locales != null) {
            for (void locale : locales) {
                Map available = null;
                for (String key : available.keySet()) {
                    for (String key2 : available.keySet()) {
                        if (key == key2) continue;
                    }
                }
            }
        }
        if (out.size() > 0) {
            throw new OpenValidationException(String.join((CharSequence)", ", out));
        }
    }
}

