/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.antlr.transformation.util;

import io.openvalidation.antlr.transformation.util.FunctionTypeResolverBase;
import io.openvalidation.common.ast.operand.ASTOperandBase;
import io.openvalidation.common.ast.operand.ASTOperandFunction;
import io.openvalidation.common.ast.operand.ASTOperandStaticNumber;
import io.openvalidation.common.ast.operand.ASTOperandVariable;
import io.openvalidation.common.ast.operand.property.ASTOperandProperty;
import io.openvalidation.common.data.DataPropertyType;
import java.util.List;

public class FunctionFirstLastTypeResolver
extends FunctionTypeResolverBase {
    public FunctionFirstLastTypeResolver(ASTOperandFunction function) {
        super(function);
    }

    @Override
    public DataPropertyType resolveType() {
        DataPropertyType functionReturnType = DataPropertyType.Unknown;
        List parameters = this.function.getParameters();
        if (parameters.size() == 2) {
            ASTOperandBase secondParam = (ASTOperandBase)parameters.get(1);
            if (secondParam instanceof ASTOperandStaticNumber && ((ASTOperandStaticNumber)secondParam).getNumberValue() == 1.0) {
                ASTOperandBase firstParam = (ASTOperandBase)parameters.get(0);
                if (firstParam instanceof ASTOperandProperty && firstParam.getDataType() == DataPropertyType.Array) {
                    functionReturnType = ((ASTOperandProperty)firstParam).getArrayContentType();
                } else if (firstParam instanceof ASTOperandFunction) {
                    functionReturnType = ((ASTOperandFunction)firstParam).getArrayContentType();
                }
            } else {
                functionReturnType = DataPropertyType.Array;
            }
        } else if (parameters.size() == 1) {
            ASTOperandBase firstParam = (ASTOperandBase)parameters.get(0);
            if (firstParam instanceof ASTOperandProperty && firstParam.getDataType() == DataPropertyType.Array) {
                functionReturnType = ((ASTOperandProperty)firstParam).getArrayContentType();
            } else if (firstParam instanceof ASTOperandFunction) {
                functionReturnType = ((ASTOperandFunction)firstParam).getArrayContentType();
            } else if (firstParam instanceof ASTOperandVariable && firstParam.getDataType() == DataPropertyType.Array) {
                functionReturnType = ((ASTOperandVariable)firstParam).getArrayContentType();
            }
        }
        this.function.setDataType(functionReturnType);
        return functionReturnType;
    }
}

