/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.antlr.transformation.postprocessing;

import io.openvalidation.antlr.transformation.postprocessing.PostProcessorSubelementBase;
import io.openvalidation.common.ast.ASTItem;
import io.openvalidation.common.ast.ASTModel;
import io.openvalidation.common.ast.condition.ASTCondition;
import io.openvalidation.common.ast.condition.ASTConditionBase;
import io.openvalidation.common.ast.condition.ASTConditionGroup;
import io.openvalidation.common.ast.operand.ASTOperandBase;
import io.openvalidation.common.ast.operand.ASTOperandFunction;
import io.openvalidation.common.ast.operand.ASTOperandStaticNumber;
import io.openvalidation.common.ast.operand.ASTOperandStaticString;
import io.openvalidation.common.ast.operand.ASTOperandVariable;
import io.openvalidation.common.ast.operand.lambda.ASTOperandLambdaCondition;
import io.openvalidation.common.ast.operand.property.ASTOperandProperty;
import io.openvalidation.common.data.DataPropertyType;
import io.openvalidation.common.utils.NumberParsingUtils;
import java.util.function.Predicate;

public class PostModelWhereOnSimpleTypeResolver
extends PostProcessorSubelementBase<ASTModel, ASTOperandFunction> {
    @Override
    protected Predicate<ASTOperandFunction> getFilter() {
        return function -> {
            ASTItem secondParam;
            ASTOperandBase firstParam;
            boolean result = false;
            DataPropertyType arrayContentType = DataPropertyType.Unknown;
            if (function.getName().equals("WHERE") && function.getParameters().size() > 1 && (arrayContentType = this.getArrayContentType(firstParam = (ASTOperandBase)function.getParameters().get(0))) != DataPropertyType.Unknown && (secondParam = (ASTItem)function.getParameters().get(1)) instanceof ASTOperandLambdaCondition) {
                ASTConditionBase conditionBase = ((ASTOperandLambdaCondition)secondParam).getCondition();
                this.resolve(conditionBase, ((ASTOperandLambdaCondition)secondParam).getLambdaToken(), arrayContentType);
            }
            return result;
        };
    }

    private DataPropertyType getArrayContentType(ASTOperandBase firstParam) {
        DataPropertyType arrayContentType = DataPropertyType.Unknown;
        if (firstParam.getDataType() == DataPropertyType.Array) {
            if (firstParam instanceof ASTOperandProperty) {
                arrayContentType = ((ASTOperandProperty)firstParam).getArrayContentType();
            } else if (firstParam instanceof ASTOperandVariable) {
                arrayContentType = ((ASTOperandVariable)firstParam).getArrayContentType();
            }
        }
        return arrayContentType;
    }

    private void resolve(ASTConditionBase conditionBase, String lambdaToken, DataPropertyType arrayContentType) {
        if (conditionBase instanceof ASTConditionGroup) {
            ASTConditionGroup group = (ASTConditionGroup)conditionBase;
            for (ASTConditionBase child : group.getConditions()) {
                this.resolve(child, lambdaToken, arrayContentType);
            }
        } else if (conditionBase instanceof ASTCondition) {
            ASTCondition condition = (ASTCondition)conditionBase;
            ASTOperandBase leftOperand = condition.getLeftOperand();
            ASTOperandBase rightOperand = condition.getRightOperand();
            if (arrayContentType == DataPropertyType.Decimal && leftOperand instanceof ASTOperandStaticString && rightOperand instanceof ASTOperandStaticString) {
                this.resolveStaticNumbers(condition, leftOperand, rightOperand);
                leftOperand = condition.getLeftOperand();
                rightOperand = condition.getRightOperand();
            }
            if (leftOperand != null && leftOperand.getDataType() == arrayContentType || rightOperand != null && rightOperand.getDataType() == arrayContentType) {
                ASTOperandProperty replacementProperty = new ASTOperandProperty();
                replacementProperty.setLambdaToken(lambdaToken);
                replacementProperty.setDataType(arrayContentType);
                ASTOperandBase newLeftOperand = leftOperand;
                ASTOperandBase newRightOperand = rightOperand;
                if (leftOperand instanceof ASTOperandStaticString) {
                    replacementProperty.setSource(leftOperand.getOriginalSource());
                    newLeftOperand = replacementProperty;
                } else if (leftOperand == null) {
                    replacementProperty.setSource("");
                    newLeftOperand = replacementProperty;
                } else if (rightOperand instanceof ASTOperandStaticString) {
                    replacementProperty.setSource(rightOperand.getOriginalSource());
                    newRightOperand = replacementProperty;
                } else if (rightOperand == null) {
                    replacementProperty.setSource("");
                    newRightOperand = replacementProperty;
                }
                condition.setLeftOperand(newLeftOperand);
                condition.setRightOperand(newRightOperand);
            }
        }
    }

    private void resolveStaticNumbers(ASTCondition condition, ASTOperandBase leftOperand, ASTOperandBase rightOperand) {
        ASTOperandBase newLeft = leftOperand;
        String leftStringValue = ((ASTOperandStaticString)leftOperand).getValue();
        ASTOperandBase newRight = rightOperand;
        String rightStringValue = ((ASTOperandStaticString)rightOperand).getValue();
        if (NumberParsingUtils.containsNumber((String)leftStringValue)) {
            newLeft = new ASTOperandStaticNumber(NumberParsingUtils.extractNumber((String)leftStringValue).doubleValue());
            newLeft.setSource(leftOperand.getOriginalSource());
        }
        if (NumberParsingUtils.containsNumber((String)rightStringValue)) {
            newRight = new ASTOperandStaticNumber(NumberParsingUtils.extractNumber((String)rightStringValue).doubleValue());
            newRight.setSource(rightOperand.getOriginalSource());
        }
        condition.setLeftOperand(newLeft);
        condition.setRightOperand(newRight);
    }

    @Override
    protected void processItem(ASTOperandFunction item) {
    }
}

