/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.antlr.transformation.postprocessing;

import io.openvalidation.antlr.transformation.postprocessing.PostProcessorContext;
import io.openvalidation.antlr.transformation.postprocessing.PostProcessorSubelementBase;
import io.openvalidation.common.ast.ASTActionBase;
import io.openvalidation.common.ast.ASTActionError;
import io.openvalidation.common.ast.ASTComparisonOperator;
import io.openvalidation.common.ast.ASTItem;
import io.openvalidation.common.ast.ASTModel;
import io.openvalidation.common.ast.ASTRule;
import io.openvalidation.common.ast.condition.ASTCondition;
import io.openvalidation.common.ast.condition.ASTConditionBase;
import io.openvalidation.common.ast.operand.ASTOperandBase;
import io.openvalidation.common.ast.operand.property.ASTOperandProperty;
import io.openvalidation.common.utils.StreamUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class PostModelNullCheckRulesCreator
extends PostProcessorSubelementBase<ASTModel, ASTCondition> {
    @Override
    public void process(ASTItem model, PostProcessorContext context) {
        this.setContext(context);
        List<ASTOperandProperty> properties = model.collectItemsOfType(ASTCondition.class).stream().flatMap(c -> c.getAllParentProperties().stream()).filter(StreamUtils.distinctByKey(p -> p.getPathAsString())).collect(Collectors.toList());
        if (properties != null && properties.size() > 0) {
            ArrayList nullCheckRules = new ArrayList();
            properties.forEach(p -> {
                ASTRule rule = new ASTRule();
                ASTCondition condition = new ASTCondition();
                condition.setLeftOperand((ASTOperandBase)p);
                condition.setOperator(ASTComparisonOperator.EMPTY);
                rule.setCondition((ASTConditionBase)condition);
                rule.setAction((ASTActionBase)new ASTActionError("field: '" + p.getPathAsString() + "' should not be null or empty"));
                nullCheckRules.add(rule);
            });
            ((ASTModel)model).setNullCheckRules(nullCheckRules);
        }
    }

    @Override
    protected Predicate<? super ASTCondition> getFilter() {
        return null;
    }

    @Override
    protected void processItem(ASTCondition item) {
    }
}

