/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.antlr.transformation.parsetree;

import io.openvalidation.antlr.generated.mainParser;
import io.openvalidation.antlr.transformation.ParseTreeUtils;
import io.openvalidation.antlr.transformation.TransformerBase;
import io.openvalidation.antlr.transformation.TransformerContext;
import io.openvalidation.antlr.transformation.parsetree.PTConditionTransformer;
import io.openvalidation.common.ast.ASTItem;
import io.openvalidation.common.ast.condition.ASTCondition;
import io.openvalidation.common.ast.condition.ASTConditionBase;
import io.openvalidation.common.ast.condition.ASTConditionConnector;
import io.openvalidation.common.ast.condition.ASTConditionGroup;
import io.openvalidation.common.utils.StringUtils;
import io.openvalidation.common.utils.ThrowingConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.antlr.v4.runtime.tree.ParseTree;

public class PTConditionGroupTransformer
extends TransformerBase<PTConditionGroupTransformer, ASTConditionGroup, mainParser.Condition_groupContext> {
    public PTConditionGroupTransformer(mainParser.Condition_groupContext treeCntx, TransformerContext fctx) {
        super(treeCntx, fctx);
    }

    @Override
    public ASTConditionGroup transform() throws Exception {
        ArrayList<ASTCondition> conditionList = new ArrayList<ASTCondition>();
        AtomicReference connector = new AtomicReference();
        AtomicReference connectorSource = new AtomicReference();
        this.eachTreeChild((ThrowingConsumer<ParseTree>)((ThrowingConsumer)c -> {
            if (ParseTreeUtils.getSymbol(c) == 18) {
                connector.set(ParseTreeUtils.getCombinator(c));
                connectorSource.set(c.getText());
            }
            if (c instanceof mainParser.Condition_exprContext) {
                PTConditionTransformer conditionTrns;
                ASTItem condition = this.createASTItem((ParseTree)c);
                ASTConditionConnector cntr = (ASTConditionConnector)connector.get();
                if (condition instanceof ASTCondition) {
                    ASTCondition cnd = (ASTCondition)condition;
                    if (cntr != null) {
                        cnd.setConnector(cntr);
                        cnd.setSource(ParseTreeUtils.getTextFromConnectorAndNode((mainParser.Condition_exprContext)((Object)c)));
                    }
                    cnd.setIndentationLevel(this.factoryCntx.getCurrentConditionIndentation());
                    conditionList.add(cnd);
                } else if (condition != null && (condition = (conditionTrns = new PTConditionTransformer(null, this.factoryCntx)).transformImplicitCondition(condition, (ParseTree)c)) != null) {
                    ASTCondition cnd = (ASTCondition)condition;
                    if (cntr != null) {
                        cnd.setConnector(cntr);
                        cnd.setSource(ParseTreeUtils.getTextFromConnectorAndNode((mainParser.Condition_exprContext)((Object)c)));
                    }
                    cnd.setIndentationLevel(this.factoryCntx.getCurrentConditionIndentation());
                    conditionList.add(cnd);
                }
                connector.set(null);
                this.factoryCntx.setTrailingWhitespaceAsCurrentIndentation(c.getText());
            }
        }));
        this.factoryCntx.setCurrentConditionIndentation(0);
        ASTConditionGroup result = this.createNestedStructure(conditionList);
        result.setSource(((mainParser.Condition_groupContext)this.antlrTreeCntx).getText());
        this.UpdateSubGroupSources(result);
        return result;
    }

    private void UpdateSubGroupSources(ASTConditionGroup group) {
        String prevSource = "";
        String totalSource = StringUtils.isNullOrEmpty((String)group.getPreprocessedSource()) ? ((mainParser.Condition_groupContext)this.antlrTreeCntx).getText() : group.getPreprocessedSource();
        for (ASTConditionBase condition : group.getConditions()) {
            if (condition instanceof ASTConditionGroup) {
                ASTConditionGroup cond = (ASTConditionGroup)condition;
                this.UpdateSubGroupSources(cond);
                if (StringUtils.isNullOrEmpty((String)condition.getPreprocessedSource())) {
                    int startIndex = StringUtils.isNullOrEmpty((String)prevSource) ? 0 : totalSource.indexOf(prevSource) + prevSource.length();
                    ASTConditionBase lastMember = (ASTConditionBase)cond.getConditions().get(cond.getConditions().size() - 1);
                    String source = totalSource.substring(startIndex, totalSource.indexOf(lastMember.getPreprocessedSource()) + lastMember.getPreprocessedSource().length());
                    cond.setSource(source);
                }
            }
            prevSource = condition.getPreprocessedSource();
        }
    }

    private void normalize(List<ASTCondition> list) {
        int i;
        int lowestIndent = Integer.MAX_VALUE;
        for (i = 1; i < list.size(); ++i) {
            if (list.get(i).getIndentationLevel() >= lowestIndent) continue;
            lowestIndent = list.get(i).getIndentationLevel();
        }
        for (i = 1; i < list.size(); ++i) {
            list.get(i).setRelativeIndentationLevel(list.get(i).getIndentationLevel() - lowestIndent);
        }
    }

    private ASTConditionGroup createNestedStructure(List<ASTCondition> conditions) {
        ASTConditionGroup conditionGroup = this.createNestedStructureRecursive(conditions);
        ASTConditionBase result = this.unpackSingleElementGroups(conditionGroup);
        this.updateAllSubgroupsConnectors(result);
        return this.wrapIfNecessary(result);
    }

    private ASTConditionGroup createNestedStructureRecursive(List<ASTCondition> conditions) {
        if (conditions.size() > 0) {
            boolean subGroupExists;
            ASTConditionGroup group = new ASTConditionGroup();
            List<ASTCondition> remainingConditions = conditions;
            this.normalize(remainingConditions);
            int lowestIndentationLevel = this.getLowestIndentationLevel(remainingConditions);
            int subgroupStartIndex = this.getSubGroupStartIndex(remainingConditions, lowestIndentationLevel);
            int subgroupEndIndex = this.getIndexOfReturningToLowestIndentation(remainingConditions, subgroupStartIndex, lowestIndentationLevel);
            boolean bl = subGroupExists = subgroupStartIndex > -1;
            while (subGroupExists) {
                List<ASTCondition> initialConditionsOnSameLevel = remainingConditions.subList(0, subgroupStartIndex);
                this.addEachConditionAsExpressionGroupWithSingleElement(group, initialConditionsOnSameLevel);
                List<ASTCondition> subGroupConditions = remainingConditions.subList(subgroupStartIndex, subgroupEndIndex);
                ASTConditionGroup subGroup = this.createNestedStructureRecursive(subGroupConditions);
                group.addCondition((ASTConditionBase)subGroup);
                remainingConditions = remainingConditions.subList(subgroupEndIndex, remainingConditions.size());
                lowestIndentationLevel = this.getLowestIndentationLevel(remainingConditions);
                subgroupStartIndex = this.getSubGroupStartIndex(remainingConditions, lowestIndentationLevel);
                subgroupEndIndex = this.getIndexOfReturningToLowestIndentation(remainingConditions, subgroupStartIndex, lowestIndentationLevel);
                subGroupExists = subgroupStartIndex != -1;
            }
            this.addEachConditionAsExpressionGroupWithSingleElement(group, remainingConditions);
            return group;
        }
        throw new IllegalStateException("size of condition list is 0");
    }

    private int getSubGroupStartIndex(List<ASTCondition> remainingConditions, int lowestIndentationLevel) {
        int subgroupStartIndex = this.getIndexOfFirstDeeperIndentation(remainingConditions, lowestIndentationLevel);
        if (subgroupStartIndex > 0) {
            --subgroupStartIndex;
        }
        return subgroupStartIndex;
    }

    private void addEachConditionAsExpressionGroupWithSingleElement(ASTConditionGroup expressionGroup, List<ASTCondition> conditionList) {
        for (ASTCondition condition : conditionList) {
            ASTConditionGroup singleElementGroup = new ASTConditionGroup();
            singleElementGroup.addCondition((ASTConditionBase)condition);
            expressionGroup.addCondition((ASTConditionBase)singleElementGroup);
        }
    }

    private int getIndexOfReturningToLowestIndentation(List<ASTCondition> conditionList, int startIndex, int lowestIndentationLevel) {
        if (startIndex >= conditionList.size() || startIndex < 0) {
            return -1;
        }
        for (int i = startIndex + 1; i < conditionList.size(); ++i) {
            if (conditionList.get(i).getRelativeIndentationLevel() > lowestIndentationLevel) continue;
            return i;
        }
        return conditionList.size();
    }

    private int getIndexOfFirstDeeperIndentation(List<ASTCondition> conditionList, int lowestIndentationLevel) {
        for (int i = 0; i < conditionList.size(); ++i) {
            if (conditionList.get(i).getRelativeIndentationLevel() <= lowestIndentationLevel) continue;
            return i;
        }
        return -1;
    }

    private int getLowestIndentationLevel(List<ASTCondition> conditionList) {
        if (conditionList.size() > 0) {
            int min = conditionList.get(0).getRelativeIndentationLevel();
            for (ASTCondition condition : conditionList) {
                if (condition.getRelativeIndentationLevel() >= min) continue;
                min = condition.getRelativeIndentationLevel();
            }
            return min;
        }
        return Integer.MAX_VALUE;
    }

    private ASTConditionBase unpackSingleElementGroups(ASTConditionGroup group) {
        for (int i = 0; i < group.getConditions().size(); ++i) {
            ASTConditionBase currentElement = (ASTConditionBase)group.getConditions().get(i);
            if (!(currentElement instanceof ASTConditionGroup)) continue;
            ASTConditionGroup currentGroup = (ASTConditionGroup)currentElement;
            int nrOfContainedElements = currentGroup.getConditions().size();
            boolean firstElementIsCondition = currentGroup.getConditions().get(0) instanceof ASTCondition;
            if (nrOfContainedElements == 1 && firstElementIsCondition) {
                group.getConditions().set(i, currentGroup.getConditions().get(0));
                continue;
            }
            ASTConditionBase unpackedSubGroup = this.unpackSingleElementGroups(currentGroup);
            group.getConditions().set(i, unpackedSubGroup);
        }
        if (group.getConditions().size() == 1) {
            return (ASTConditionBase)group.getConditions().get(0);
        }
        return group;
    }

    private void updateAllSubgroupsConnectors(ASTConditionBase conditionBase) {
        if (conditionBase instanceof ASTConditionGroup) {
            ASTConditionGroup parentGroup = (ASTConditionGroup)conditionBase;
            this.updateOperator(parentGroup);
            this.updateOperatorsOfSubgroups(parentGroup);
        }
    }

    private void updateOperatorsOfSubgroups(ASTConditionGroup parentGroup) {
        for (ASTConditionBase subExpression : parentGroup.getConditions()) {
            if (!(subExpression instanceof ASTConditionGroup)) continue;
            this.updateAllSubgroupsConnectors(subExpression);
        }
    }

    private void updateOperator(ASTConditionGroup group) {
        ASTConditionBase firstElem = (ASTConditionBase)group.getConditions().get(0);
        while (!(firstElem instanceof ASTCondition)) {
            List subGroupConditions = ((ASTConditionGroup)firstElem).getConditions();
            firstElem = (ASTConditionBase)subGroupConditions.get(0);
        }
        ASTConditionConnector connector = firstElem.getConnector();
        firstElem.setConnector(null);
        group.setConnector(connector);
    }

    private ASTConditionGroup wrapIfNecessary(ASTConditionBase result) {
        if (result instanceof ASTCondition) {
            ASTConditionGroup wrappedCondition = new ASTConditionGroup();
            wrappedCondition.addCondition(result);
            return wrappedCondition;
        }
        return (ASTConditionGroup)result;
    }
}

