/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.antlr.transformation;

import io.openvalidation.antlr.transformation.TransformerContext;
import io.openvalidation.antlr.transformation.TransformerFactory;
import io.openvalidation.antlr.transformation.parsetree.PTContentTransformer;
import io.openvalidation.common.ast.ASTItem;
import io.openvalidation.common.ast.builder.ASTBuilderBase;
import io.openvalidation.common.ast.builder.ASTOperandFunctionBuilder;
import io.openvalidation.common.ast.operand.ASTOperandBase;
import io.openvalidation.common.ast.operand.ASTOperandVariable;
import io.openvalidation.common.ast.operand.ASTSemanticOperator;
import io.openvalidation.common.ast.operand.property.ASTOperandProperty;
import io.openvalidation.common.data.DataArrayProperty;
import io.openvalidation.common.data.DataProperty;
import io.openvalidation.common.data.DataPropertyBase;
import io.openvalidation.common.data.DataPropertyType;
import io.openvalidation.common.data.DataSemanticOperator;
import io.openvalidation.common.data.DataVariableReference;
import io.openvalidation.common.utils.StringUtils;
import io.openvalidation.common.utils.ThrowingConsumer;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public abstract class TransformerBase<TFactory, TModel extends ASTItem, TPRContext extends ParserRuleContext> {
    protected TPRContext antlrTreeCntx;
    protected TransformerContext factoryCntx;
    protected Class<TFactory> cls;

    public TransformerBase(TPRContext treeCntx, TransformerContext fctx) {
        this.antlrTreeCntx = treeCntx;
        this.factoryCntx = fctx;
    }

    protected void eachTreeChild(ThrowingConsumer<? super ParseTree> action) throws Exception {
        if (this.antlrTreeCntx != null) {
            this.eachTreeChild(((ParserRuleContext)this.antlrTreeCntx).children, action);
        }
    }

    protected void eachTreeChild(List<ParseTree> children, ThrowingConsumer<? super ParseTree> action) throws Exception {
        if (children != null) {
            children.forEach(action);
        }
    }

    public abstract TModel transform() throws Exception;

    public <T extends TransformerBase> T loadFactory(ParseTree tree) {
        TransformerBase<TFactory, TModel, TPRContext> factory = TransformerFactory.create(tree, this.factoryCntx);
        return (T)(factory != null ? factory : null);
    }

    public ASTItem createASTItem(ParseTree tree) throws Exception {
        ASTItem item;
        TransformerBase factory = TransformerFactory.create(tree, this.factoryCntx);
        ASTItem aSTItem = item = factory != null ? (ASTItem)factory.transform() : null;
        if (item != null) {
            item.setSource(tree.getText());
        }
        return item;
    }

    public <TBuilder extends ASTBuilderBase> TBuilder createBuilder(Class<TBuilder> bldrCls) throws Exception {
        return this.createBuilder(bldrCls, this.antlrTreeCntx.getText());
    }

    public <TBuilder extends ASTBuilderBase> TBuilder createBuilder(Class<TBuilder> bldrCls, String altSource) throws Exception {
        ASTBuilderBase builder = (ASTBuilderBase)bldrCls.newInstance();
        builder.create();
        builder.withSource(altSource);
        return (TBuilder)builder;
    }

    public ASTOperandBase createProperty(DataPropertyBase property, String content) {
        ASTOperandProperty operand = null;
        if (property instanceof DataProperty) {
            operand = new ASTOperandProperty(((DataProperty)property).getFullNameAsParts());
            operand.setDataType(property.getType());
            operand.setSource(content);
            if (property.getType() == DataPropertyType.Array) {
                operand.setArrayContentType(property.getArrayContentType());
            }
        } else if (property instanceof DataVariableReference) {
            operand = new ASTOperandVariable(property.getName());
            operand.setSource(content);
            operand.setDataType(property.getType());
        } else if (property instanceof DataArrayProperty) {
            DataArrayProperty p = (DataArrayProperty)property;
            ASTOperandFunctionBuilder functionBuilder = new ASTOperandFunctionBuilder();
            functionBuilder.createArrayOfFunction(p);
            operand = (ASTOperandBase)functionBuilder.getModel();
            operand.setSource(content);
            operand.setDataType(DataPropertyType.Array);
        } else if (property != null && property instanceof DataSemanticOperator) {
            DataSemanticOperator dso = (DataSemanticOperator)property;
            ASTOperandBase semanticOperand = this.createProperty(dso.getOperandName());
            operand = new ASTSemanticOperator(dso, semanticOperand);
            operand.setSource(content);
            String cleaned = content.replaceAll(dso.getName(), "");
            cleaned = StringUtils.stripSpecialWords((String)cleaned);
            ASTOperandBase secondOperand = this.createProperty(cleaned);
            ((ASTSemanticOperator)operand).setSecondOperand(secondOperand, cleaned, content);
        }
        return operand;
    }

    public ASTOperandBase createProperty(String content) {
        DataPropertyBase property = this.factoryCntx.resolveProperty(content);
        return this.createProperty(property, content);
    }

    public TModel postprocess(TModel model) {
        this.factoryCntx.getPostProcessor().process((ASTItem)model);
        return model;
    }

    public ASTItem resolveContent(String text) {
        PTContentTransformer ct = new PTContentTransformer(null, this.factoryCntx);
        return ct.resolveContentString(text);
    }
}

