/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.antlr.transformation;

import io.openvalidation.antlr.generated.mainParser;
import io.openvalidation.common.ast.ASTArithmeticalOperator;
import io.openvalidation.common.ast.ASTComparisonOperator;
import io.openvalidation.common.ast.condition.ASTConditionConnector;
import io.openvalidation.common.exceptions.OpenValidationException;
import io.openvalidation.common.utils.LINQ;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.antlr.v4.runtime.tree.TerminalNodeImpl;

public class ParseTreeUtils {
    public static int getSymbol(ParseTree node) {
        if (ParseTreeUtils.isSymbol(node)) {
            return ((TerminalNodeImpl)node).getSymbol().getType();
        }
        return -1;
    }

    public static boolean isSymbol(ParseTree node) {
        if (node instanceof TerminalNodeImpl) {
            Token symbol = ((TerminalNodeImpl)node).getSymbol();
            return symbol != null && symbol.getType() > -1;
        }
        return false;
    }

    public static ASTConditionConnector getCombinator(ParseTree c) throws Exception {
        String str = c.getText().replaceAll("\u02ac[a-zA-Z0-9_]+$", "\u02ac");
        if (str.equals("\u02acand\u02ac")) {
            return ASTConditionConnector.AND;
        }
        if (str.equals("\u02acor\u02ac")) {
            return ASTConditionConnector.OR;
        }
        if (str.equals("\u02acunless\u02ac")) {
            return ASTConditionConnector.UNLESS;
        }
        throw new OpenValidationException("unknown Connector: " + str);
    }

    public static ASTComparisonOperator getOperator(TerminalNode terminalNode) throws Exception {
        String str = terminalNode.getText();
        if (str != null) {
            str = str.replace("\u02acoperator\u02ac", "").replaceAll("\u02ac[a-zA-Z0-9_]+", "").toUpperCase();
            return ASTComparisonOperator.valueOf((String)str);
        }
        throw new OpenValidationException(" UNKNOWN COMPARISON OPERATOR: " + str);
    }

    public static ASTArithmeticalOperator getArithmeticalOperator(ParseTree node) throws OpenValidationException {
        String str = node.getText();
        if (str != null) {
            switch (str = str.replace("\u02acarithmoperator\u02ac", "").replaceAll("\u02ac[a-zA-Z0-9_]+", "").toLowerCase()) {
                case "add": {
                    return ASTArithmeticalOperator.Addition;
                }
                case "subtract": {
                    return ASTArithmeticalOperator.Subtraction;
                }
                case "multiply": {
                    return ASTArithmeticalOperator.Multiplication;
                }
                case "divide": {
                    return ASTArithmeticalOperator.Division;
                }
                case "modulo": {
                    return ASTArithmeticalOperator.Modulo;
                }
                case "power": {
                    return ASTArithmeticalOperator.Power;
                }
            }
        }
        throw new OpenValidationException("unknown Arithmetical Operator: " + str);
    }

    public static String extractFunctionName(TerminalNode function) {
        if (function != null) {
            return ParseTreeUtils.extractFunctionName(function.getText());
        }
        return null;
    }

    public static String extractFunctionName(String function) {
        if (function != null) {
            return function.replace("\u02acfunction\u02ac", "").replaceFirst("\u02ac[a-zA-Z0-9_]+", "").toUpperCase();
        }
        return function;
    }

    public static String extractCONSTRAINT(TerminalNode constraint) {
        return constraint.toString().replace("\u02acconstraint\u02ac", "").replaceAll("\u02ac[a-zA-Z0-9_]+", "");
    }

    public static boolean isMUSTConstraint(TerminalNode constraint) {
        String constr = ParseTreeUtils.extractCONSTRAINT(constraint);
        return constr.equals("must") || constr.equals("mustnot");
    }

    public static boolean isMUSTExceptNotConstraint(TerminalNode constraint) {
        String constr = ParseTreeUtils.extractCONSTRAINT(constraint);
        return constr.equals("must");
    }

    public static String getTextFromConnectorAndNode(mainParser.Condition_exprContext tree) {
        String value = tree.getText();
        mainParser.Condition_groupContext mother = (mainParser.Condition_groupContext)tree.parent;
        List children = mother.children;
        int pos = -1;
        for (int i = 0; i < children.size(); ++i) {
            if (!((ParseTree)children.get(i)).equals((Object)tree)) continue;
            pos = i;
        }
        if (pos == 0) {
            value = tree.getText();
        } else if (ParseTreeUtils.getSymbol((ParseTree)children.get(pos - 1)) == 18) {
            if (pos < 2) {
                String temp = mother.getText();
                value = temp.substring(0, temp.indexOf(tree.getText()) + tree.getText().length());
            } else {
                String previous = ParseTreeUtils.getPreviousConditionText(mother, pos);
                value = mother.getText().substring(mother.getText().indexOf(previous) + previous.length(), mother.getText().indexOf(value) + value.length());
            }
        }
        return value;
    }

    public static ASTComparisonOperator getEffectiveOperator(List<TerminalNode> operators) throws Exception {
        List tnoperators;
        if (operators != null && operators.size() > 0 && (tnoperators = LINQ.where(operators, o -> ParseTreeUtils.getSymbol((ParseTree)o) == 14)) != null && tnoperators.size() > 0) {
            if (tnoperators.size() == 1) {
                return ParseTreeUtils.getOperator((TerminalNode)tnoperators.get(0));
            }
            List comps = LINQ.select((List)tnoperators, o -> {
                try {
                    return ParseTreeUtils.getOperator(o);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            });
            return LINQ.any((List)comps, c -> c != ASTComparisonOperator.EQUALS) ? (ASTComparisonOperator)LINQ.findFirst((List)comps, c -> c != ASTComparisonOperator.EQUALS) : (ASTComparisonOperator)comps.get(0);
        }
        return null;
    }

    private static String getPreviousConditionText(mainParser.Condition_groupContext parent, int pos) {
        String value = "";
        --pos;
        while (pos > -1) {
            if (parent.children.get(pos) instanceof mainParser.Condition_exprContext) {
                value = ((ParseTree)parent.children.get(pos)).getText();
                break;
            }
            --pos;
        }
        return value;
    }

    public static String getEffectiveRuleIndicator(List<TerminalNode> indicators) {
        List strindicators;
        if (indicators != null && indicators.size() > 0 && (strindicators = LINQ.where(indicators, o -> ParseTreeUtils.getSymbol((ParseTree)o) == 10).stream().map(t -> ParseTreeUtils.extractCONSTRAINT(t)).collect(Collectors.toList())) != null && strindicators.size() > 0) {
            if (strindicators.size() == 1) {
                return (String)strindicators.get(0);
            }
            return LINQ.any(strindicators, i -> i.equals("mustnot")) ? (String)LINQ.findFirst(strindicators, i -> i.equals("mustnot")) : (String)strindicators.get(0);
        }
        return null;
    }
}

