/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.antlr;

import io.openvalidation.antlr.generated.mainParser;
import io.openvalidation.antlr.transformation.ParseTreeUtils;
import io.openvalidation.common.ast.ASTComparisonOperator;
import io.openvalidation.common.data.DataPropertyBase;
import io.openvalidation.common.data.DataPropertyType;
import io.openvalidation.common.data.DataSemanticOperator;
import io.openvalidation.common.data.DataVariableReference;
import io.openvalidation.common.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;

public class NamesExtractor {
    public static List<DataPropertyBase> getNames(ParseTree ctx) {
        return NamesExtractor.getDataProperties(ctx);
    }

    public static List<DataPropertyBase> getDataProperties(ParseTree ctx) {
        ArrayList<DataPropertyBase> result = new ArrayList<DataPropertyBase>();
        if (ctx instanceof mainParser.NameContext && ((mainParser.NameContext)ctx).unknown() != null) {
            if (ctx.getParent() instanceof mainParser.Semantic_operatorContext) {
                result.add(NamesExtractor.createDataSemanticOperator(ctx));
            } else if (ctx.getParent() instanceof mainParser.VariableContext) {
                String originText;
                String name = ((mainParser.NameContext)ctx).unknown().getText().trim();
                DataPropertyType type = NamesExtractor.determineDataPropertyType(ctx);
                mainParser.VariableContext variableContext = (mainParser.VariableContext)ctx.getParent();
                String string = originText = variableContext.expression() != null ? variableContext.expression().getText() : "";
                if (!name.isEmpty()) {
                    result.add((DataPropertyBase)new DataVariableReference(name, type, originText));
                }
            }
        }
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            List<DataPropertyBase> childVars;
            ParseTree elem = ctx.getChild(i);
            if (elem == null || (childVars = NamesExtractor.getDataProperties(elem)) == null || childVars.size() <= 0) continue;
            result.addAll(childVars);
        }
        return result;
    }

    private static DataPropertyBase createDataVariableReference(ParseTree ctx) {
        String name = ((mainParser.NameContext)ctx).unknown().getText().trim();
        DataPropertyType type = NamesExtractor.determineDataPropertyType(ctx);
        mainParser.VariableContext variableContext = (mainParser.VariableContext)ctx.getParent();
        String originText = variableContext.expression() != null ? variableContext.expression().getText() : "";
        return new DataVariableReference(name, type, originText);
    }

    private static DataPropertyBase createDataSemanticOperator(ParseTree ctx) {
        String name = ((mainParser.NameContext)ctx).unknown().getText().trim();
        String operandName = null;
        name = StringUtils.reverseKeywords((String)name);
        DataPropertyType type = NamesExtractor.determineDataPropertyType(ctx);
        mainParser.Semantic_operatorContext semanticOperatorContext = (mainParser.Semantic_operatorContext)ctx.getParent();
        ASTComparisonOperator operator = null;
        if (semanticOperatorContext.unknown() != null && semanticOperatorContext.unknown().OPERATOR_COMP() != null) {
            try {
                operator = ParseTreeUtils.getEffectiveOperator(semanticOperatorContext.unknown().OPERATOR_COMP());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (semanticOperatorContext.unknown().STRING().size() > 0) {
                operandName = semanticOperatorContext.unknown().STRING(0).getText();
            }
        }
        return new DataSemanticOperator(name, operandName, type, operator);
    }

    private static DataPropertyType determineDataPropertyType(ParseTree ctx) {
        DataPropertyType type = DataPropertyType.Unknown;
        if (ctx.getParent() instanceof mainParser.VariableContext) {
            mainParser.ExpressionContext expressionContext = ((mainParser.VariableContext)ctx.getParent()).expression();
            type = expressionContext != null && expressionContext.children != null && expressionContext.children.size() > 0 ? (expressionContext.condition() != null || expressionContext.condition_group() != null ? DataPropertyType.Boolean : (expressionContext.arithmetic() != null ? DataPropertyType.Decimal : (expressionContext.accessor() != null ? DataPropertyType.Unknown : DataPropertyType.Unknown))) : DataPropertyType.Unknown;
        }
        return type;
    }
}

