/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.antlr.transformation.postprocessing;

import io.openvalidation.antlr.transformation.postprocessing.PostProcessorContext;
import io.openvalidation.antlr.transformation.postprocessing.PostProcessorSubelementBase;
import io.openvalidation.common.ast.ASTItem;
import io.openvalidation.common.ast.ASTModel;
import io.openvalidation.common.ast.ASTVariable;
import io.openvalidation.common.ast.condition.ASTCondition;
import io.openvalidation.common.ast.operand.ASTOperandBase;
import io.openvalidation.common.ast.operand.ASTOperandVariable;
import io.openvalidation.common.ast.operand.property.ASTOperandProperty;
import io.openvalidation.common.ast.operand.property.ASTPropertyStaticPart;
import io.openvalidation.common.data.DataProperty;
import io.openvalidation.common.data.DataPropertyBase;
import io.openvalidation.common.data.DataSchema;
import io.openvalidation.common.data.DataVariableReference;
import io.openvalidation.common.utils.StringUtils;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class PostModelMissingRightOperandResolver
extends PostProcessorSubelementBase<ASTModel, ASTCondition> {
    private List<ASTVariable> variableDefinitions = null;

    @Override
    public void process(ASTItem item, PostProcessorContext context) {
        this.variableDefinitions = item.collectItemsOfType(ASTVariable.class);
        super.process(item, context);
    }

    @Override
    protected Predicate<? super ASTCondition> getFilter() {
        return c -> c.hasSimpleComparisonOperator() && c.hasLeftOperand() && !c.hasRightOperand() && c.getLeftOperand().isPropertyOrVariable();
    }

    @Override
    protected void processItem(ASTCondition item) {
        DataSchema schema = this.getContext().getSchema();
        ASTOperandBase leftOperand = item.getLeftOperand();
        List allPossibleResolutions = schema.resolveAll(leftOperand.getPreprocessedSource());
        ASTOperandBase rightOperand = this.extractOperand(leftOperand, allPossibleResolutions);
        item.setRightOperand(rightOperand);
        if (rightOperand != null) {
            this.rearrangeOperands(item);
        }
    }

    private ASTOperandBase extractOperand(ASTOperandBase leftOperand, List<DataPropertyBase> allPossibleResolutions) {
        String leftOperandFullName = leftOperand instanceof ASTOperandProperty ? ((ASTOperandProperty)leftOperand).getPathAsString() : leftOperand.getName();
        List possibleResolutions = allPossibleResolutions.stream().filter(p -> p.getType() == leftOperand.getDataType() && !p.getFullNameLowerCase().equals(leftOperandFullName.toLowerCase())).collect(Collectors.toList());
        ASTOperandBase rightOperand = null;
        if (possibleResolutions.size() == 1) {
            DataPropertyBase foundProperty = (DataPropertyBase)possibleResolutions.get(0);
            rightOperand = this.createOperandBase(foundProperty, leftOperand.getPreprocessedSource());
        }
        return rightOperand;
    }

    private void rearrangeOperands(ASTCondition condition) {
        boolean rightOccursInSourceFirst;
        String sharedPrepSource = condition.getLeftOperand().getPreprocessedSource();
        int indexInSourceLeft = this.getIndexOf(condition.getLeftOperand(), sharedPrepSource);
        int indexInSourceRight = this.getIndexOf(condition.getRightOperand(), sharedPrepSource);
        boolean bl = rightOccursInSourceFirst = indexInSourceRight < indexInSourceLeft;
        if (rightOccursInSourceFirst) {
            ASTOperandBase temp = condition.getLeftOperand();
            condition.setLeftOperand(condition.getRightOperand());
            condition.setRightOperand(temp);
        }
    }

    private int getIndexOf(ASTOperandBase leftOperand, String sharedPrepSource) {
        int index = -1;
        if (leftOperand instanceof ASTOperandProperty) {
            index = StringUtils.indexOfIgnoreCase((String)sharedPrepSource, (String)((ASTOperandProperty)leftOperand).getPathAsString());
        } else if (leftOperand instanceof ASTOperandVariable) {
            index = StringUtils.indexOfIgnoreCase((String)sharedPrepSource, (String)((ASTOperandVariable)leftOperand).getVariableName());
        }
        return index;
    }

    private ASTOperandBase createOperandBase(DataPropertyBase propertyBase, String preproSource) {
        ASTOperandProperty operandBase = null;
        if (propertyBase instanceof DataProperty) {
            ASTOperandProperty operandProperty = new ASTOperandProperty();
            operandProperty.setPath(Arrays.stream(((DataProperty)propertyBase).getFullNameAsParts()).map(part -> new ASTPropertyStaticPart(part)).collect(Collectors.toList()));
            operandProperty.setDataType(propertyBase.getType());
            operandProperty.setSource(preproSource);
            operandBase = operandProperty;
        } else if (propertyBase instanceof DataVariableReference) {
            ASTOperandVariable operandVariable = new ASTOperandVariable(propertyBase.getName());
            operandVariable.setSource(preproSource);
            operandVariable.setDataType(propertyBase.getType());
            operandVariable.setVariable(this.lookUpVariableByName(propertyBase.getName()));
            operandBase = operandVariable;
        }
        return operandBase;
    }

    private ASTVariable lookUpVariableByName(String name) {
        ASTVariable var = null;
        for (ASTVariable v : this.variableDefinitions) {
            if (!v.getName().equals(name)) continue;
            var = v;
            break;
        }
        return var;
    }
}

