/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.antlr.transformation.postprocessing;

import io.openvalidation.antlr.transformation.postprocessing.PostProcessorSelfBase;
import io.openvalidation.common.ast.ASTComparisonOperator;
import io.openvalidation.common.ast.condition.ASTCondition;
import io.openvalidation.common.ast.operand.ASTOperandArray;
import io.openvalidation.common.ast.operand.ASTOperandBase;
import io.openvalidation.common.ast.operand.ASTOperandStaticString;
import io.openvalidation.common.utils.Constants;
import io.openvalidation.common.utils.StringUtils;
import java.util.function.Predicate;

public class PostConditionArrayResolver
extends PostProcessorSelfBase<ASTCondition> {
    @Override
    protected Predicate<ASTCondition> getFilter() {
        return c -> !(!c.hasLeftOperand() || !c.hasRightOperand() || c.getOperator() != ASTComparisonOperator.EQUALS && c.getOperator() != ASTComparisonOperator.NOT_EQUALS && c.getOperator() != ASTComparisonOperator.AT_LEAST_ONE_OF && c.getOperator() != ASTComparisonOperator.ONE_OF && c.getOperator() != ASTComparisonOperator.NONE_OF || !c.getLeftOperand().isStringData() && !c.getRightOperand().isStringData());
    }

    @Override
    protected void processItem(ASTCondition condition) {
        ASTOperandArray rightOperandArray;
        ASTOperandArray leftOperandArray = this.resolveArrayInOperand(condition.getLeftOperand());
        if (leftOperandArray != null) {
            condition.setLeftOperand((ASTOperandBase)leftOperandArray);
        }
        if ((rightOperandArray = this.resolveArrayInOperand(condition.getRightOperand())) != null) {
            condition.setRightOperand((ASTOperandBase)rightOperandArray);
        }
        if (leftOperandArray != null || rightOperandArray != null) {
            if (condition.getOperator() == ASTComparisonOperator.EQUALS) {
                condition.setOperator(ASTComparisonOperator.AT_LEAST_ONE_OF);
            } else if (condition.getOperator() == ASTComparisonOperator.NOT_EQUALS) {
                condition.setOperator(ASTComparisonOperator.NONE_OF);
            }
        }
    }

    public ASTOperandArray resolveArrayInOperand(ASTOperandBase operand) {
        String val;
        ASTOperandArray result = null;
        if (operand != null && operand instanceof ASTOperandStaticString && !StringUtils.isNullOrEmpty((String)(val = ((ASTOperandStaticString)operand).getValue())) && (val = StringUtils.trimSpecialChars((String)val)).contains(",")) {
            result = new ASTOperandArray();
            for (String delimiter : Constants.ARRAY_DELIMITER_ALIASES) {
                val = val.replaceAll(" " + delimiter + " ", ",");
            }
            for (String v : val.split(",")) {
                result.add((ASTOperandBase)new ASTOperandStaticString(StringUtils.stripSpecialWords((String)v.trim())));
            }
            result.setSource(operand.getPreprocessedSource());
        }
        return result;
    }
}

