/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.antlr.transformation.parsetree;

import io.openvalidation.antlr.generated.mainParser;
import io.openvalidation.antlr.transformation.ParseTreeUtils;
import io.openvalidation.antlr.transformation.TransformerBase;
import io.openvalidation.antlr.transformation.TransformerContext;
import io.openvalidation.common.ast.ASTItem;
import io.openvalidation.common.ast.builder.ASTOperandFunctionBuilder;
import io.openvalidation.common.ast.condition.ASTCondition;
import io.openvalidation.common.ast.condition.ASTConditionBase;
import io.openvalidation.common.ast.operand.ASTOperandBase;
import io.openvalidation.common.ast.operand.ASTOperandFunction;
import io.openvalidation.common.ast.operand.ASTOperandStaticString;
import io.openvalidation.common.ast.operand.ASTOperandVariable;
import io.openvalidation.common.ast.operand.property.ASTOperandProperty;
import io.openvalidation.common.utils.StringUtils;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public class PTLambdaTransformer
extends TransformerBase<PTLambdaTransformer, ASTOperandBase, mainParser.LambdaContext> {
    public PTLambdaTransformer(mainParser.LambdaContext treeCntx, TransformerContext fctx) {
        super(treeCntx, fctx);
    }

    @Override
    public ASTOperandBase transform() throws Exception {
        ASTOperandFunction out;
        ASTOperandFunction outerFunction = null;
        ASTOperandBase arrayItem = null;
        ASTOperandFunction mapFunction = null;
        ASTOperandFunction whereFunction = null;
        ASTConditionBase condition = this.createLambdaCondition(((mainParser.LambdaContext)this.antlrTreeCntx).accessor_with());
        if (((mainParser.LambdaContext)this.antlrTreeCntx).content() != null) {
            String outerFunctionCnt = null;
            outerFunction = this.createOuterFunction(((mainParser.LambdaContext)this.antlrTreeCntx).content().FUNCTION());
            arrayItem = this.createFromArray(((mainParser.LambdaContext)this.antlrTreeCntx).lambda_from());
            if (outerFunction != null) {
                outerFunctionCnt = ((mainParser.LambdaContext)this.antlrTreeCntx).content().getText().replace(((mainParser.LambdaContext)this.antlrTreeCntx).content().FUNCTION().get(0).getText(), "");
            }
            if (arrayItem == null) {
                String content = outerFunction != null && outerFunction.getParameters().size() > 0 ? outerFunctionCnt : ((mainParser.LambdaContext)this.antlrTreeCntx).content().getText();
                arrayItem = this.createFromContent(content);
            }
            if (arrayItem != null && !StringUtils.isNullOrEmpty(outerFunctionCnt) && ((mainParser.LambdaContext)this.antlrTreeCntx).lambda_from() != null) {
                mapFunction = this.createMapFunction(arrayItem, outerFunctionCnt);
            }
        }
        return (out = this.createResultFunction(outerFunction, mapFunction, whereFunction = this.createWhereFunction(arrayItem, condition), arrayItem)) != null ? out : arrayItem;
    }

    private ASTOperandProperty resolveLambdaProperty(ASTOperandStaticString staticOperand) {
        if (staticOperand != null && this.factoryCntx.getSchema().isLambdaPropertyOfArray(staticOperand.getValue())) {
            ASTOperandProperty property = new ASTOperandProperty(new String[]{staticOperand.getValue()});
            property.setSource(staticOperand.getPreprocessedSource());
            return property;
        }
        return null;
    }

    private ASTConditionBase createLambdaCondition(mainParser.Accessor_withContext withContext) throws Exception {
        ASTItem lambda;
        ASTConditionBase condition = null;
        if (withContext != null && (lambda = this.createASTItem((ParseTree)((mainParser.LambdaContext)this.antlrTreeCntx).accessor_with())) != null && lambda instanceof ASTConditionBase) {
            condition = (ASTConditionBase)lambda;
            condition.walk(w -> {
                ASTOperandProperty property;
                if (w.getParent() instanceof ASTCondition && (property = this.resolveLambdaProperty((ASTOperandStaticString)w.getCurrentAs(ASTOperandStaticString.class))) != null) {
                    ASTCondition cnd = (ASTCondition)w.getParentAs(ASTCondition.class);
                    if (cnd.getLeftOperand().equals(w.getCurrent())) {
                        cnd.setLeftOperand((ASTOperandBase)property);
                    } else if (cnd.getRightOperand().equals(w.getCurrent())) {
                        cnd.setRightOperand((ASTOperandBase)property);
                    }
                }
            }, ASTOperandStaticString.class);
        }
        return condition;
    }

    private ASTOperandFunction createOuterFunction(List<TerminalNode> functions) {
        ASTOperandFunction outFunction = null;
        if (functions != null && functions.size() > 0) {
            String outerFunctionName = ParseTreeUtils.extractFunctionName(functions.get(0));
            ASTOperandFunctionBuilder outerFunctionBuilder = new ASTOperandFunctionBuilder();
            ((ASTOperandFunctionBuilder)outerFunctionBuilder.create()).withName(outerFunctionName);
            outFunction = (ASTOperandFunction)outerFunctionBuilder.getModel();
        }
        return outFunction;
    }

    private ASTOperandBase createFromArray(mainParser.Lambda_fromContext fromContext) throws Exception {
        ASTItem arrayProperty = null;
        if (fromContext != null && fromContext.content() != null && (arrayProperty = this.createASTItem((ParseTree)fromContext.content())) != null && arrayProperty instanceof ASTOperandBase) {
            return (ASTOperandBase)arrayProperty;
        }
        return null;
    }

    private ASTOperandBase createFromContent(String content) throws Exception {
        if (!StringUtils.isNullOrEmpty((String)content)) {
            return this.createProperty(content);
        }
        return null;
    }

    private ASTOperandFunction createWhereFunction(ASTOperandBase arrayItem, ASTConditionBase condition) {
        ASTOperandFunction whereFunction = null;
        if (arrayItem != null && condition != null) {
            ASTOperandFunctionBuilder builder = new ASTOperandFunctionBuilder();
            builder.createWhereFunction(arrayItem).addLambdaConditionParamenter(condition);
            whereFunction = (ASTOperandFunction)builder.getModel();
        }
        return whereFunction;
    }

    private ASTOperandFunction createMapFunction(ASTOperandBase arrayProperty, String lambdaProperty) {
        if (arrayProperty != null && arrayProperty instanceof ASTOperandBase && !StringUtils.isNullOrEmpty((String)lambdaProperty) && this.factoryCntx.getSchema().isLambdaPropertyOfArray(lambdaProperty)) {
            String[] path = null;
            String[] lambdaProperties = new String[]{!StringUtils.isNullOrEmpty((String)lambdaProperty) ? lambdaProperty.trim() : null};
            if (arrayProperty instanceof ASTOperandVariable) {
                path = ((ASTOperandVariable)arrayProperty).getPathAsArray();
            } else if (arrayProperty instanceof ASTOperandProperty) {
                path = ((ASTOperandProperty)arrayProperty).getPathAsArray();
            }
            ASTOperandFunctionBuilder builder = new ASTOperandFunctionBuilder();
            builder.createArrayOfFunction(path, lambdaProperties);
            return (ASTOperandFunction)builder.getModel();
        }
        return null;
    }

    private String getValueOfFirstFunctionParameter(ASTOperandFunction function) {
        if (function != null && function.getParameters() != null && function.getParameters().size() > 0 && function.getParameters().get(0) instanceof ASTOperandStaticString) {
            return ((ASTOperandStaticString)function.getParameters().get(0)).getValue();
        }
        return null;
    }

    protected ASTOperandFunction createResultFunction(ASTOperandFunction outerFunction, ASTOperandFunction mapFunction, ASTOperandFunction whereFunction, ASTOperandBase arrayItem) {
        ASTOperandFunction resultFunction = whereFunction;
        if (outerFunction != null) {
            resultFunction = outerFunction;
            if (mapFunction != null) {
                if (whereFunction != null) {
                    mapFunction.replaceFirstParameter(whereFunction);
                }
                resultFunction.replaceFirstParameter(mapFunction);
            } else if (whereFunction != null) {
                resultFunction.replaceFirstParameter(whereFunction);
            } else if (arrayItem != null) {
                resultFunction.addParameter(arrayItem);
            }
        } else if (mapFunction != null) {
            if (whereFunction != null) {
                mapFunction.replaceFirstParameter(whereFunction);
            }
            resultFunction = mapFunction;
        }
        return resultFunction;
    }
}

