/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.antlr.transformation.parsetree;

import io.openvalidation.antlr.generated.mainParser;
import io.openvalidation.antlr.transformation.ParseTreeUtils;
import io.openvalidation.antlr.transformation.TransformerBase;
import io.openvalidation.antlr.transformation.TransformerContext;
import io.openvalidation.common.ast.ASTArithmeticalOperator;
import io.openvalidation.common.ast.ASTItem;
import io.openvalidation.common.ast.builder.ASTOperandArithmeticalBuilder;
import io.openvalidation.common.ast.operand.ASTOperandStaticNumber;
import io.openvalidation.common.ast.operand.ASTOperandStaticString;
import io.openvalidation.common.ast.operand.ASTOperandVariable;
import io.openvalidation.common.ast.operand.arithmetical.ASTOperandArithmetical;
import io.openvalidation.common.ast.operand.arithmetical.ASTOperandArithmeticalOperation;
import io.openvalidation.common.ast.operand.property.ASTOperandProperty;
import io.openvalidation.common.exceptions.ASTValidationException;
import io.openvalidation.common.utils.NumberParsingUtils;
import io.openvalidation.common.utils.StringUtils;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.antlr.v4.runtime.tree.ParseTree;

public class PTArithmeticTransformer
extends TransformerBase<PTArithmeticTransformer, ASTOperandArithmetical, mainParser.ArithmeticContext> {
    private AtomicReference<ASTArithmeticalOperator> lastOperator;
    private String lastOperatorSource = "";
    private String input = ((mainParser.ArithmeticContext)this.antlrTreeCntx).getText();

    public PTArithmeticTransformer(mainParser.ArithmeticContext treeCntx, TransformerContext fctx) {
        super(treeCntx, fctx);
    }

    @Override
    public ASTOperandArithmetical transform() throws Exception {
        ASTOperandArithmeticalOperation operation = this.extractArithmeticalOperation(((mainParser.ArithmeticContext)this.antlrTreeCntx).children);
        ASTOperandArithmetical arithmetical = new ASTOperandArithmetical();
        arithmetical.setOperation(operation);
        if (this.input != null) {
            arithmetical.setSource(this.input);
        }
        return arithmetical;
    }

    private ASTOperandArithmeticalOperation extractArithmeticalOperation(List<ParseTree> children) throws Exception {
        return this.extractArithmeticalOperation(children, 0);
    }

    private ASTOperandArithmeticalOperation extractArithmeticalOperation(List<ParseTree> children, int currentNestingDepth) throws Exception {
        boolean subArithmeticalExists;
        ASTOperandArithmeticalBuilder builder = this.createBuilder(ASTOperandArithmeticalBuilder.class);
        List<ParseTree> remainingChildren = children;
        int startIndexOfSubArithmetical = this.getFirstOpenParenChildIndex(remainingChildren, currentNestingDepth);
        int endIndexOfSubArithmetical = this.getIndexOfMatchingClosedParen(remainingChildren, startIndexOfSubArithmetical, currentNestingDepth);
        if (startIndexOfSubArithmetical == 0 && endIndexOfSubArithmetical == remainingChildren.size()) {
            startIndexOfSubArithmetical = this.getFirstOpenParenChildIndex(remainingChildren, 1, currentNestingDepth);
            endIndexOfSubArithmetical = this.getIndexOfMatchingClosedParen(remainingChildren, startIndexOfSubArithmetical, currentNestingDepth);
        }
        boolean bl = subArithmeticalExists = startIndexOfSubArithmetical != -1;
        while (subArithmeticalExists) {
            List<ParseTree> onSameLevel = remainingChildren.subList(0, startIndexOfSubArithmetical);
            this.addToArithmetical(builder, onSameLevel);
            List<ParseTree> subOperationChildren = remainingChildren.subList(startIndexOfSubArithmetical, endIndexOfSubArithmetical);
            AtomicReference<ASTArithmeticalOperator> localLastOperator = this.lastOperator;
            String localLastOperatorSource = this.lastOperatorSource;
            this.lastOperator = null;
            this.lastOperatorSource = "";
            ASTOperandArithmeticalOperation subOperation = this.extractArithmeticalOperation(subOperationChildren, currentNestingDepth + 1);
            builder.withOperation(subOperation, localLastOperator.get(), localLastOperatorSource);
            remainingChildren = remainingChildren.subList(endIndexOfSubArithmetical, remainingChildren.size());
            startIndexOfSubArithmetical = this.getFirstOpenParenChildIndex(remainingChildren, currentNestingDepth);
            endIndexOfSubArithmetical = this.getIndexOfMatchingClosedParen(remainingChildren, startIndexOfSubArithmetical, currentNestingDepth);
            if (startIndexOfSubArithmetical == 0 && endIndexOfSubArithmetical == remainingChildren.size()) {
                startIndexOfSubArithmetical = this.getFirstOpenParenChildIndex(remainingChildren, 1, currentNestingDepth);
                endIndexOfSubArithmetical = this.getIndexOfMatchingClosedParen(remainingChildren, startIndexOfSubArithmetical, currentNestingDepth);
            }
            subArithmeticalExists = startIndexOfSubArithmetical != -1;
        }
        this.addToArithmetical(builder, remainingChildren);
        this.setSource(((ASTOperandArithmetical)builder.getModel()).getOperation(), children);
        return ((ASTOperandArithmetical)builder.getModel()).getOperation();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addToArithmetical(ASTOperandArithmeticalBuilder builder, List<ParseTree> toAdd) throws Exception {
        this.lastOperator = new AtomicReference();
        for (ParseTree c : toAdd) {
            if (ParseTreeUtils.getSymbol(c) == 3) {
                ASTArithmeticalOperator operator = ParseTreeUtils.getArithmeticalOperator(c);
                this.lastOperator.set(operator);
                this.lastOperatorSource = c.getText();
                continue;
            }
            ASTItem item = this.createASTItem(c);
            if (item != null) {
                if (item instanceof ASTOperandProperty) {
                    builder.withProperty((ASTOperandProperty)item, this.lastOperator.get(), this.lastOperatorSource);
                } else if (item instanceof ASTOperandStaticNumber) {
                    builder.withNumber((ASTOperandStaticNumber)item, this.lastOperator.get(), this.lastOperatorSource);
                } else if (item instanceof ASTOperandVariable) {
                    builder.withVariable((ASTOperandVariable)item, this.lastOperator.get(), this.lastOperatorSource);
                } else {
                    if (!(item instanceof ASTOperandStaticString)) throw new ASTValidationException("arithmetical operand has unsupported type: '" + item.getType() + "'", item);
                    Double value = NumberParsingUtils.extractDouble((String)((ASTOperandStaticString)item).getValue());
                    if (value != null) {
                        ASTOperandStaticNumber num = new ASTOperandStaticNumber(value.doubleValue());
                        num.setSource(item.getPreprocessedSource());
                        builder.withNumber(num, this.lastOperator.get(), this.lastOperatorSource);
                    } else {
                        builder.withString((ASTOperandStaticString)item, this.lastOperator.get(), this.lastOperatorSource);
                    }
                }
            } else {
                builder.withEmptyOperand(c.getText(), this.lastOperator.get(), this.lastOperatorSource);
            }
            this.lastOperatorSource = "";
            this.lastOperator.set(null);
        }
    }

    private int getIndexOfMatchingClosedParen(List<ParseTree> children, int indexOfFirstOpenParen, int nestingDepth) {
        if (indexOfFirstOpenParen < 0) {
            return -1;
        }
        int numberOfOpenParens = this.parenthesisCountDifference(children.get(indexOfFirstOpenParen).getText()) - nestingDepth;
        for (int i = indexOfFirstOpenParen + 1; i < children.size(); ++i) {
            int parenCountDifference = this.parenthesisCountDifference(children.get(i).getText());
            if ((numberOfOpenParens += parenCountDifference) > 0 || parenCountDifference >= 0) continue;
            return i + 1;
        }
        return -1;
    }

    private int getFirstOpenParenChildIndex(List<ParseTree> children, int searchStartIndex, int nestingDepth) {
        for (int i = searchStartIndex; i < children.size(); ++i) {
            if (this.parenthesisCountDifference(children.get(i).getText()) <= 0) continue;
            if (i == 0) {
                if (this.parenthesisCountDifference(children.get(0).getText()) <= nestingDepth) continue;
                return 0;
            }
            return i;
        }
        return -1;
    }

    private int getFirstOpenParenChildIndex(List<ParseTree> children, int nestingDepth) {
        return this.getFirstOpenParenChildIndex(children, 0, nestingDepth);
    }

    private int parenthesisCountDifference(String text) {
        int openParentheses = this.countOpenParentheses(text);
        int closedParentheses = this.countClosedParentheses(text);
        return openParentheses - closedParentheses;
    }

    private int countClosedParentheses(String text) {
        return text.length() - text.replaceAll("\\)", "").length();
    }

    private int countOpenParentheses(String text) {
        return text.length() - text.replaceAll("\\(", "").length();
    }

    private void setSource(ASTOperandArithmeticalOperation operation, List<ParseTree> children) {
        StringBuilder sb = new StringBuilder();
        for (ParseTree child : children) {
            sb.append(child.getText());
        }
        String sourceWithCorrectNumberOfParens = this.correctNumOfParens(sb.toString());
        operation.setSource(sourceWithCorrectNumberOfParens);
    }

    private String correctNumOfParens(String source) {
        String result = source;
        int parenDiff = this.parenthesisCountDifference(source);
        if (parenDiff < 0) {
            result = StringUtils.mirrorString((String)result);
            for (int i = 0; i < -parenDiff; ++i) {
                result = result.replaceFirst("[^)]*\\)", "");
            }
            result = StringUtils.mirrorString((String)result);
        } else if (parenDiff > 0) {
            for (int i = 0; i < parenDiff; ++i) {
                result = result.replaceFirst("[^(]*\\(", "");
            }
        }
        return result;
    }
}

