/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.antlr.transformation;

import io.openvalidation.antlr.transformation.postprocessing.PostProcessor;
import io.openvalidation.common.data.DataPropertyBase;
import io.openvalidation.common.data.DataSchema;

public class TransformerContext {
    private DataSchema _schema;
    private PostProcessor _postProcessor;
    private int currentConditionIndentation;

    public TransformerContext(DataSchema schema) {
        this._schema = schema != null ? schema : new DataSchema();
        this._postProcessor = new PostProcessor(this._schema);
        this.currentConditionIndentation = 0;
    }

    public DataSchema getSchema() {
        return this._schema;
    }

    public DataPropertyBase resolveProperty(String content) {
        return this.getSchema().resolve(content);
    }

    public void setTrailingWhitespaceAsCurrentIndentation(String text) {
        int trailingWhitespaceStartIndex = 0;
        for (int i = text.length() - 1; i >= 0; --i) {
            if (text.charAt(i) == ' ' || text.charAt(i) == '\n' || text.charAt(i) == '\r') continue;
            trailingWhitespaceStartIndex = i + 1;
            i = -1;
        }
        String trailingWhitespace = text.substring(trailingWhitespaceStartIndex);
        trailingWhitespace = trailingWhitespace.replaceAll("\\r\\n", "");
        trailingWhitespace = trailingWhitespace.replaceAll("\\n", "");
        int indentation = trailingWhitespace.length() / 4 * 4;
        this.setCurrentConditionIndentation(indentation);
    }

    public int getCurrentConditionIndentation() {
        return this.currentConditionIndentation;
    }

    public void setCurrentConditionIndentation(int currentConditionIndentation) {
        this.currentConditionIndentation = currentConditionIndentation;
    }

    public PostProcessor getPostProcessor() {
        return this._postProcessor;
    }
}

