/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.antlr;

import io.openvalidation.antlr.generated.mainParser;
import io.openvalidation.common.data.DataPropertyType;
import io.openvalidation.common.data.DataVariableReference;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;

public class NamesExtractor {
    public static List<DataVariableReference> getNames(ParseTree ctx) {
        return NamesExtractor.getNamesFromContext(ctx);
    }

    private static List<DataVariableReference> getNamesFromContext(ParseTree ctx) {
        ArrayList<DataVariableReference> result = new ArrayList<DataVariableReference>();
        if (ctx instanceof mainParser.NameContext && ((mainParser.NameContext)ctx).unknown() != null) {
            String name = ((mainParser.NameContext)ctx).unknown().getText().trim();
            DataPropertyType type = NamesExtractor.determineDataPropertyType(ctx);
            mainParser.VariableContext variableContext = (mainParser.VariableContext)ctx.getParent();
            String originText = variableContext.expression() != null ? variableContext.expression().getText() : "";
            result.add(new DataVariableReference(name, type, originText));
        }
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            List<DataVariableReference> childVars;
            ParseTree elem = ctx.getChild(i);
            if (elem == null || (childVars = NamesExtractor.getNamesFromContext(elem)) == null || childVars.size() <= 0) continue;
            result.addAll(childVars);
        }
        return result;
    }

    private static DataPropertyType determineDataPropertyType(ParseTree ctx) {
        DataPropertyType type = DataPropertyType.Unknown;
        if (ctx.getParent() instanceof mainParser.VariableContext) {
            mainParser.ExpressionContext expressionContext = ((mainParser.VariableContext)ctx.getParent()).expression();
            type = expressionContext != null && expressionContext.children != null && expressionContext.children.size() > 0 ? (expressionContext.condition() != null || expressionContext.condition_group() != null ? DataPropertyType.Boolean : (expressionContext.arithmetic() != null ? DataPropertyType.Decimal : (expressionContext.accessor() != null ? DataPropertyType.Unknown : DataPropertyType.Unknown))) : DataPropertyType.Unknown;
        }
        return type;
    }
}

