/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.otproto;

import io.opentelemetry.api.common.Labels;
import io.opentelemetry.proto.common.v1.StringKeyValue;
import io.opentelemetry.proto.metrics.v1.AggregationTemporality;
import io.opentelemetry.proto.metrics.v1.DoubleDataPoint;
import io.opentelemetry.proto.metrics.v1.DoubleGauge;
import io.opentelemetry.proto.metrics.v1.DoubleHistogram;
import io.opentelemetry.proto.metrics.v1.DoubleHistogramDataPoint;
import io.opentelemetry.proto.metrics.v1.DoubleSum;
import io.opentelemetry.proto.metrics.v1.InstrumentationLibraryMetrics;
import io.opentelemetry.proto.metrics.v1.IntDataPoint;
import io.opentelemetry.proto.metrics.v1.IntGauge;
import io.opentelemetry.proto.metrics.v1.IntSum;
import io.opentelemetry.proto.metrics.v1.Metric;
import io.opentelemetry.proto.metrics.v1.ResourceMetrics;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.extension.otproto.CommonAdapter;
import io.opentelemetry.sdk.extension.otproto.ResourceAdapter;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.resources.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class MetricAdapter {
    public static List<ResourceMetrics> toProtoResourceMetrics(Collection<MetricData> metricData) {
        Map<Resource, Map<InstrumentationLibraryInfo, List<Metric>>> resourceAndLibraryMap = MetricAdapter.groupByResourceAndLibrary(metricData);
        ArrayList<ResourceMetrics> resourceMetrics = new ArrayList<ResourceMetrics>(resourceAndLibraryMap.size());
        for (Map.Entry<Resource, Map<InstrumentationLibraryInfo, List<Metric>>> entryResource : resourceAndLibraryMap.entrySet()) {
            ArrayList<InstrumentationLibraryMetrics> instrumentationLibraryMetrics = new ArrayList<InstrumentationLibraryMetrics>(entryResource.getValue().size());
            for (Map.Entry<InstrumentationLibraryInfo, List<Metric>> entryLibrary : entryResource.getValue().entrySet()) {
                instrumentationLibraryMetrics.add(InstrumentationLibraryMetrics.newBuilder().setInstrumentationLibrary(CommonAdapter.toProtoInstrumentationLibrary(entryLibrary.getKey())).addAllMetrics((Iterable)entryLibrary.getValue()).build());
            }
            resourceMetrics.add(ResourceMetrics.newBuilder().setResource(ResourceAdapter.toProtoResource(entryResource.getKey())).addAllInstrumentationLibraryMetrics(instrumentationLibraryMetrics).build());
        }
        return resourceMetrics;
    }

    private static Map<Resource, Map<InstrumentationLibraryInfo, List<Metric>>> groupByResourceAndLibrary(Collection<MetricData> metricDataList) {
        HashMap<Resource, Map<InstrumentationLibraryInfo, List<Metric>>> result = new HashMap<Resource, Map<InstrumentationLibraryInfo, List<Metric>>>();
        for (MetricData metricData : metricDataList) {
            if (metricData.isEmpty()) continue;
            Resource resource = metricData.getResource();
            HashMap<InstrumentationLibraryInfo, List> libraryInfoListMap = (HashMap<InstrumentationLibraryInfo, List>)result.get(metricData.getResource());
            if (libraryInfoListMap == null) {
                libraryInfoListMap = new HashMap<InstrumentationLibraryInfo, List>();
                result.put(resource, libraryInfoListMap);
            }
            List metricList = libraryInfoListMap.computeIfAbsent(metricData.getInstrumentationLibraryInfo(), k -> new ArrayList());
            metricList.add(MetricAdapter.toProtoMetric(metricData));
        }
        return result;
    }

    static Metric toProtoMetric(MetricData metricData) {
        Metric.Builder builder = Metric.newBuilder().setName(metricData.getName()).setDescription(metricData.getDescription()).setUnit(metricData.getUnit());
        switch (metricData.getType()) {
            case LONG_SUM: {
                MetricData.LongSumData longSumData = metricData.getLongSumData();
                builder.setIntSum(IntSum.newBuilder().setIsMonotonic(longSumData.isMonotonic()).setAggregationTemporality(MetricAdapter.mapToTemporality(longSumData.getAggregationTemporality())).addAllDataPoints(MetricAdapter.toIntDataPoints(longSumData.getPoints())).build());
                break;
            }
            case DOUBLE_SUM: {
                MetricData.DoubleSumData doubleSumData = metricData.getDoubleSumData();
                builder.setDoubleSum(DoubleSum.newBuilder().setIsMonotonic(doubleSumData.isMonotonic()).setAggregationTemporality(MetricAdapter.mapToTemporality(doubleSumData.getAggregationTemporality())).addAllDataPoints(MetricAdapter.toDoubleDataPoints(doubleSumData.getPoints())).build());
                break;
            }
            case SUMMARY: {
                MetricData.DoubleSummaryData doubleSummaryData = metricData.getDoubleSummaryData();
                builder.setDoubleHistogram(DoubleHistogram.newBuilder().setAggregationTemporality(AggregationTemporality.AGGREGATION_TEMPORALITY_DELTA).addAllDataPoints(MetricAdapter.toSummaryDataPoints(doubleSummaryData.getPoints())).build());
                break;
            }
            case LONG_GAUGE: {
                MetricData.LongGaugeData longGaugeData = metricData.getLongGaugeData();
                builder.setIntGauge(IntGauge.newBuilder().addAllDataPoints(MetricAdapter.toIntDataPoints(longGaugeData.getPoints())).build());
                break;
            }
            case DOUBLE_GAUGE: {
                MetricData.DoubleGaugeData doubleGaugeData = metricData.getDoubleGaugeData();
                builder.setDoubleGauge(DoubleGauge.newBuilder().addAllDataPoints(MetricAdapter.toDoubleDataPoints(doubleGaugeData.getPoints())).build());
            }
        }
        return builder.build();
    }

    private static AggregationTemporality mapToTemporality(MetricData.AggregationTemporality temporality) {
        switch (temporality) {
            case CUMULATIVE: {
                return AggregationTemporality.AGGREGATION_TEMPORALITY_CUMULATIVE;
            }
            case DELTA: {
                return AggregationTemporality.AGGREGATION_TEMPORALITY_DELTA;
            }
        }
        return AggregationTemporality.AGGREGATION_TEMPORALITY_UNSPECIFIED;
    }

    static List<IntDataPoint> toIntDataPoints(Collection<MetricData.Point> points) {
        ArrayList<IntDataPoint> result = new ArrayList<IntDataPoint>(points.size());
        for (MetricData.Point point : points) {
            MetricData.LongPoint longPoint = (MetricData.LongPoint)point;
            IntDataPoint.Builder builder = IntDataPoint.newBuilder().setStartTimeUnixNano(longPoint.getStartEpochNanos()).setTimeUnixNano(longPoint.getEpochNanos()).setValue(longPoint.getValue());
            List<StringKeyValue> labels = MetricAdapter.toProtoLabels(longPoint.getLabels());
            if (!labels.isEmpty()) {
                builder.addAllLabels(labels);
            }
            result.add(builder.build());
        }
        return result;
    }

    static Collection<DoubleDataPoint> toDoubleDataPoints(Collection<MetricData.Point> points) {
        ArrayList<DoubleDataPoint> result = new ArrayList<DoubleDataPoint>(points.size());
        for (MetricData.Point point : points) {
            MetricData.DoublePoint doublePoint = (MetricData.DoublePoint)point;
            DoubleDataPoint.Builder builder = DoubleDataPoint.newBuilder().setStartTimeUnixNano(point.getStartEpochNanos()).setTimeUnixNano(point.getEpochNanos()).setValue(doublePoint.getValue());
            List<StringKeyValue> labels = MetricAdapter.toProtoLabels(point.getLabels());
            if (!labels.isEmpty()) {
                builder.addAllLabels(labels);
            }
            result.add(builder.build());
        }
        return result;
    }

    static List<DoubleHistogramDataPoint> toSummaryDataPoints(Collection<MetricData.Point> points) {
        ArrayList<DoubleHistogramDataPoint> result = new ArrayList<DoubleHistogramDataPoint>(points.size());
        for (MetricData.Point point : points) {
            MetricData.DoubleSummaryPoint doubleSummaryPoint = (MetricData.DoubleSummaryPoint)point;
            DoubleHistogramDataPoint.Builder builder = DoubleHistogramDataPoint.newBuilder().setStartTimeUnixNano(point.getStartEpochNanos()).setTimeUnixNano(point.getEpochNanos()).setCount(doubleSummaryPoint.getCount()).setSum(doubleSummaryPoint.getSum());
            List<StringKeyValue> labels = MetricAdapter.toProtoLabels(point.getLabels());
            if (!labels.isEmpty()) {
                builder.addAllLabels(labels);
            }
            if (!doubleSummaryPoint.getPercentileValues().isEmpty()) {
                MetricAdapter.addBucketValues(doubleSummaryPoint.getPercentileValues(), builder);
            }
            result.add(builder.build());
        }
        return result;
    }

    static void addBucketValues(List<MetricData.ValueAtPercentile> valueAtPercentiles, DoubleHistogramDataPoint.Builder builder) {
        for (MetricData.ValueAtPercentile valueAtPercentile : valueAtPercentiles) {
            builder.addBucketCounts((long)valueAtPercentile.getValue());
            builder.addExplicitBounds(valueAtPercentile.getPercentile());
        }
        builder.addBucketCounts(0L);
    }

    static List<StringKeyValue> toProtoLabels(Labels labels) {
        if (labels.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<StringKeyValue> result = new ArrayList<StringKeyValue>(labels.size());
        labels.forEach((key, value) -> result.add(StringKeyValue.newBuilder().setKey(key).setValue(value).build()));
        return result;
    }

    private MetricAdapter() {
    }
}

