/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.trace;

import io.opentelemetry.api.trace.TraceState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nullable;

public final class TraceStateBuilder {
    public static final int MAX_VENDOR_ID_SIZE = 13;
    private static final TraceState EMPTY = TraceState.create(Collections.emptyList());
    private static final int MAX_KEY_VALUE_PAIRS = 32;
    private static final int KEY_MAX_SIZE = 256;
    private static final int VALUE_MAX_SIZE = 256;
    private static final int MAX_TENANT_ID_SIZE = 240;
    private final TraceState parent;
    @Nullable
    private ArrayList<TraceState.Entry> entries;

    TraceStateBuilder() {
        this.parent = EMPTY;
    }

    TraceStateBuilder(TraceState parent) {
        Objects.requireNonNull(parent, "parent");
        this.parent = parent;
    }

    public TraceStateBuilder set(String key, String value) {
        if (!TraceStateBuilder.isKeyValid(key) || !TraceStateBuilder.isValueValid(value) || this.entries != null && this.entries.size() >= 32) {
            return this;
        }
        TraceState.Entry entry = TraceState.Entry.create(key, value);
        if (this.entries == null) {
            this.entries = new ArrayList<TraceState.Entry>(this.parent.getEntries());
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            if (!this.entries.get(i).getKey().equals(entry.getKey())) continue;
            this.entries.remove(i);
            break;
        }
        this.entries.add(0, entry);
        return this;
    }

    public TraceStateBuilder remove(String key) {
        if (key == null) {
            return this;
        }
        if (this.entries == null) {
            this.entries = new ArrayList<TraceState.Entry>(this.parent.getEntries());
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            if (!this.entries.get(i).getKey().equals(key)) continue;
            this.entries.remove(i);
            break;
        }
        return this;
    }

    public TraceState build() {
        if (this.entries == null) {
            return this.parent;
        }
        return TraceState.create(this.entries);
    }

    private static boolean isKeyValid(@Nullable String key) {
        if (key == null) {
            return false;
        }
        if (key.length() > 256 || key.isEmpty() || TraceStateBuilder.isNotLowercaseLetterOrDigit(key.charAt(0))) {
            return false;
        }
        boolean isMultiTenantVendorKey = false;
        for (int i = 1; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (TraceStateBuilder.isNotLegalKeyCharacter(c)) {
                return false;
            }
            if (c != '@') continue;
            if (isMultiTenantVendorKey) {
                return false;
            }
            isMultiTenantVendorKey = true;
            if (i > 240) {
                return false;
            }
            if (key.length() - i <= 13) continue;
            return false;
        }
        if (!isMultiTenantVendorKey) {
            return TraceStateBuilder.isNotDigit(key.charAt(0));
        }
        return true;
    }

    private static boolean isNotLegalKeyCharacter(char c) {
        return TraceStateBuilder.isNotLowercaseLetterOrDigit(c) && c != '_' && c != '-' && c != '@' && c != '*' && c != '/';
    }

    private static boolean isNotLowercaseLetterOrDigit(char ch) {
        return (ch < 'a' || ch > 'z') && TraceStateBuilder.isNotDigit(ch);
    }

    private static boolean isNotDigit(char ch) {
        return ch < '0' || ch > '9';
    }

    private static boolean isValueValid(@Nullable String value) {
        if (value == null) {
            return false;
        }
        if (value.length() > 256 || value.charAt(value.length() - 1) == ' ') {
            return false;
        }
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c != ',' && c != '=' && c >= ' ' && c <= '~') continue;
            return false;
        }
        return true;
    }
}

